<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.driver_create')); ?></h3>
        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo route('drivers'); ?>"><?php echo e(trans('lang.driver_plural')); ?></a>
                </li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.driver_create')); ?></li>
            </ol>
        </div>
    </div>


    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card pb-4">

                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default"
                            style="display: none;"><?php echo e(trans('lang.processing')); ?></div>
                        <div class="error_top"></div>
                        <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php endif; ?>
                        <form action="<?php echo e(route('drivers.store')); ?>" method="post" enctype="multipart/form-data"
                            id="create_driver">
                            <?php echo csrf_field(); ?>

                            <div class="row restaurant_payout_create">
                                <div class="restaurant_payout_create-inner">
                                    <fieldset>
                                        <legend><?php echo e(trans('lang.driver_details')); ?></legend>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.first_name')); ?></label>
                                            <div class="col-7">
                                                <input type="hidden" class="form-control user_first_name" name="id">
                                                <input type="text" class="form-control user_first_name" name="nom"
                                                    value="<?php echo e(Request::old('nom')); ?>">
                                                <div class="form-text text-muted"><?php echo e(trans('lang.first_name_help')); ?>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.last_name')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control user_last_name" name="prenom"
                                                    value="<?php echo e(Request::old('prenom')); ?>">
                                                <div class="form-text text-muted"><?php echo e(trans('lang.last_name_help')); ?></div>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.email')); ?></label>
                                            <div class="col-7">
                                                <input type="email" class="form-control user_email" name="email"
                                                    value="<?php echo e(Request::old('email')); ?>">
                                                <div class="form-text text-muted"><?php echo e(trans('lang.user_email_help')); ?>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.password')); ?></label>
                                            <div class="col-7">
                                                <input type="password" class="form-control user_password"
                                                    name="password" value="<?php echo e(Request::old('password')); ?>">
                                                <div class="form-text text-muted"><?php echo e(trans('lang.user_password_help')); ?>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.user_phone')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control user_phone" name="phone"
                                                    value="<?php echo e(Request::old('phone')); ?>">
                                                <div class="form-text text-muted">
                                                    <?php echo e(trans('lang.user_phone_help')); ?></div>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.zone')); ?></label>
                                            <div class="col-7">
                                                <select class="form-control" name="zone[]" id="zone" multiple="multiple">
                                                <?php $__currentLoopData = $zones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($zone->id); ?>"><?php echo e($zone->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="form-text text-muted w-50">
                                                    <?php echo e(trans("lang.select_zone_help")); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Driver Type</label>
                                            <?php
                                            $type = ['In house driver','Outside driver']
                                            ?>
                                            <div class="col-7">
                                                <select class="form-control" name="driver_type">
                                                    <option value="">Select Driver Type</option>
                                                    <?php $__currentLoopData = $type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>

                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.profile_image')); ?></label>
                                            <div class="col-7">
                                                <input type="file" class="" name="photo"
                                                    value="<?php echo e(Request::old('photo')); ?>" onchange="readURL(this);">
                                                <div class="form-text text-muted"><?php echo e(trans('lang.profile_image_help')); ?>

                                                </div>
                                            </div>
                                            <div id="image_preview" style="display: none; padding-left: 15px;">
                                                <img class="rounded" style="width:50px" id="uploding_image" src="#"
                                                    alt="image">
                                            </div>
                                        </div>


                                        <div class="form-check  width-50">
                                            <input type="checkbox" class="col-7 form-check-inline user_active"
                                                id="user_active" name="statut" value="yes">
                                            <label class="col-3 control-label"
                                                for="user_active"><?php echo e(trans('lang.active')); ?></label>
                                        </div>
                                        <div class="form-check  width-50">
                                            <input type="checkbox" class="col-7 form-check-inline parcel_delivery"
                                                id="parcel_delivery" name="parcel_delivery" value="yes">
                                            <label class="col-3 control-label"
                                                for="parcel_delivery"><?php echo e(trans('lang.active_parcel_delivery')); ?></label>
                                        </div>

                                    </fieldset>

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.car_details')); ?></legend>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_type')); ?></label>
                                            <div class="col-7">
                                                <select class="form-control model" name="id_type_vehicule"
                                                    id="id_type_vehicule">
                                                    <option value=""><?php echo e(trans('lang.select_type')); ?></option>
                                                    <?php $__currentLoopData = $vehicleType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($value->id); ?>"><?php echo e($value->libelle); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_brand')); ?></label>
                                            <div class="col-7">
                                                <select class="form-control brand_id" name="brand">
                                                    <option value=""><?php echo e(trans('lang.select_brand')); ?></option>
                                                    <?php $__currentLoopData = $brand; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($value->id); ?>"><?php echo e($value->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>

                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_model')); ?></label>
                                            <div class="col-7">
                                                <select class="form-control model" name="model" id="model">
                                                    <option value=""><?php echo e(trans('lang.select_model')); ?></option>
                                                </select>
                                                <div class="form-text text-muted"><?php echo e(trans('lang.car_model_help')); ?></div>
                                            </div>
                                        </div>


                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_km')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control model" name="km"
                                                    value="<?php echo e(Request::old('km')); ?>">
                                                <div class="form-text text-muted"><?php echo e(trans('lang.vehicle_km_help')); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_milage')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control model" name="milage"
                                                    value="<?php echo e(Request::old('milage')); ?>">
                                                <div class="form-text text-muted"><?php echo e(trans('lang.vehicle_milage_help')); ?>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.vehicle_numberplate')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control car_number" name="car_number"
                                                    value="<?php echo e(Request::old('car_number')); ?>">
                                                <div class="form-text text-muted"><?php echo e(trans('lang.car_number_help')); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_color')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control color" name="color"
                                                    value="<?php echo e(Request::old('color')); ?>">
                                                <div class="form-text text-muted">
                                                    <?php echo e(trans("lang.car_color_help")); ?>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.number_of_pessanger')); ?></label>
                                            <div class="col-7">
                                                <input type="number" class="form-control" name="passenger"
                                                    value="<?php echo e(Request::old('passenger')); ?>">
                                                <div class="form-text text-muted w-50">
                                                    <?php echo e(trans("lang.number_of_passenger_help")); ?>

                                                </div>

                                            </div>
                                        </div>
                                    </fieldset>
                                    <fieldset>
                                        <legend><?php echo e(trans('lang.bank_details')); ?></legend>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.bank_name')); ?></label>
                                            <div class="col-7">
                                                <input type="text" name="bank_name" class="form-control" id="bankName">

                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.branch_name')); ?></label>
                                            <div class="col-7">
                                                <input type="text" name="branch_name" class="form-control"
                                                    id="branchName">

                                            </div>

                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.holder_name')); ?></label>
                                            <div class="col-7">
                                                <input type="text" name="holder_name" class="form-control"
                                                    id="holderName">

                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.account_number')); ?></label>
                                            <div class="col-7">
                                                <input type="text" name="account_number" class="form-control"
                                                    id="accountNumber">

                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans("lang.ifsc_code")); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control user_phone" name="ifsc_code">

                                            </div>

                                        </div>
                                        <div class="form-group row width-50">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.other_information')); ?></label>
                                            <div class="col-7">
                                                <input type="text" name="other_information" class="form-control"
                                                    id="otherDetails">

                                            </div>
                                        </div>

                                    </fieldset>

                                    <div class="form-group col-12 text-center btm-btn">
                                        <button type="submit" class="btn btn-primary save_driver_btn"><i
                                                class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
                                        <a href="<?php echo route('drivers'); ?>" class="btn btn-default"><i
                                                class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
                                    </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function () {
        $('select[name="brand"]').on('change', function () {

            var brand_id = $(this).val();
            var id_type_vehicule = $('select[name="id_type_vehicule"]').val();
            var url = "<?php echo e(route('driver.model',':brandId')); ?>";
            url = url.replace(':brandId', brand_id);

            if (brand_id) {
                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        id_type_vehicule: id_type_vehicule,
                        _token: '<?php echo e(csrf_token()); ?>',
                    },

                    dataType: 'json',
                    success: function (data) {
                        $('select[name="model"]').empty();
                        $('select[name="model"]').append('<option value=""><?php echo e(trans("lang.select_model")); ?></option>');
                        $.each(data.model, function (key, value) {
                            $('select[name="model"]').append('<option value="' + value.id + '">' + value.name + '</option>');
                        });
                    }
                });
            } else {
                // $('select[name="model"]').append('<option value="">' + "No data found" + '</option>');
                $('select[name="model"]').empty();
            }
        });


    });

    function readURL(input) {
        console.log(input.files);
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
                $('#image_preview').show();
                $('#uploding_image').attr('src', e.target.result);


            }

            reader.readAsDataURL(input.files[0]);
        }
    }

    function readURLNic(input) {
        console.log(input.files);
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
                $('#placeholder_img_thumb').show();
                $('#user_nic_image').attr('src', e.target.result);
            }

            reader.readAsDataURL(input.files[0]);
        }
    }


</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/drivers/create.blade.php ENDPATH**/ ?>