

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">

  <div class="row page-titles">

    <div class="col-md-5 align-self-center">

      <h3 class="text-themecolor"><?php echo e(trans('lang.all_rental_rides')); ?></h3>

    </div>

    <div class="col-md-7 align-self-center">

      <ol class="breadcrumb">

        <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>

        <li class="breadcrumb-item active"><?php echo e(trans('lang.all_rental_rides')); ?></li>

      </ol>

    </div>

    <div>

    </div>

  </div>


  <div class="container-fluid">

    <div class="row">

      <div class="col-12">

        <div class="card">

          <div class="card-body">

            <h4 class="card-title"></h4>

            <div class="userlist-topsearch d-flex mb-3">
              <!-- <div class="userlist-top-left">
                                  <a class="nav-link" href="javascript:void(0);" data-toggle="modal" data-target="#typeVehicleModal"><i class="fa fa-plus mr-2"></i><?php echo e(trans('lang.create_new_ride')); ?></a>
                                </div>  -->

              <div class="userlist-top-left">
                <a class="nav-link do_not_create" href="<?php echo e(route('admin.request.create.rental')); ?>"><i class="fa fa-plus mr-2"></i><?php echo e(trans('lang.add_new_rental_ride')); ?></a>
              </div>

              <div id="users-table_filter" class="ml-auto">
                <label><?php echo e(trans('lang.search_by')); ?>

                  <div class="form-group  mb-0">
                    <?php if($id != ''): ?>
                    <form action="<?php echo e(url('rides/all', ['id' => $id])); ?>" method="get">
                      <?php else: ?>
                      <form action="<?php echo e(route('rides.all')); ?>" method="get">
                        <?php endif; ?>
                        <?php if(isset($_GET['selected_search']) && $_GET['selected_search'] != ''): ?>
                        <select name="selected_search" id="selected_search" class="form-control input-sm">
                          <option value="userName" <?php if($_GET['selected_search']=='userName' ): ?> selected="selected" <?php endif; ?>>
                            <?php echo e(trans('lang.user_name')); ?>

                          </option>
                          <option value="driverName" <?php if($_GET['selected_search']=='driverName' ): ?> selected="selected"
                            <?php endif; ?>><?php echo e(trans('lang.driver_name')); ?></option>
                          <option value="status" <?php if($_GET['selected_search']=='status' ): ?> selected="selected" <?php endif; ?>>
                            <?php echo e(trans('lang.status')); ?>

                          </option>
                          <option value="type" <?php if($_GET['selected_search']=='type' ): ?> selected="selected" <?php endif; ?>>
                            <?php echo e(trans('lang.ride_type')); ?>

                          </option>
                        </select>
                        <?php else: ?>
                        <select name="selected_search" id="selected_search" class="form-control input-sm">
                          <option value="userName"><?php echo e(trans('lang.user_name')); ?></option>
                          <option value="driverName"><?php echo e(trans('lang.driver_name')); ?></option>
                          <option value="status"><?php echo e(trans('lang.status')); ?></option>
                          <option value="type"><?php echo e(trans('lang.ride_type')); ?></option>

                        </select>
                        <?php endif; ?>

                        <div class="search-box position-relative">
                          <?php if(isset($_GET['search']) && $_GET['search'] != ''): ?>
                          <input type="text" class="search form-control" name="search" id="search"
                            value="<?php echo e($_GET['search']); ?>">
                          <select id="ride_status" class="form-control" name="ride_status" style="display: none">
                            <option value="confirmed"><?php echo e(trans('lang.confirmed')); ?></option>
                            <option value="new"><?php echo e(trans('lang.new')); ?></option>
                            <option value="on ride"><?php echo e(trans('lang.on_ride')); ?></option>
                            <option value="completed"><?php echo e(trans('lang.completed')); ?></option>
                            <option value="rejected"><?php echo e(trans('lang.rejected')); ?></option>
                            <option value="driver_rejected"><?php echo e(trans('lang.driver_rejected')); ?></option>
                          </select>

                          <?php elseif(isset($_GET['ride_status']) && $_GET['ride_status'] != ''): ?>
                          <input type="text" class="search form-control" name="search" id="search" style="display:none">
                          <select id="ride_status" class="search form-control" name="ride_status">
                            <option <?php if($_GET['ride_status']=='confirmed' ): ?>selected="selected" <?php endif; ?> value="confirmed">
                              <?php echo e(trans('lang.confirmed')); ?>

                            </option>

                            <option <?php if($_GET['ride_status']=='new' ): ?>selected="selected" <?php endif; ?> value="new">
                              <?php echo e(trans('lang.new')); ?>

                            </option>

                            <option <?php if($_GET['ride_status']=='on ride' ): ?>selected="selected" <?php endif; ?> value="on ride">
                              <?php echo e(trans('lang.on_ride')); ?>

                            </option>

                            <option <?php if($_GET['ride_status']=='completed' ): ?>selected="selected" <?php endif; ?> value="completed">
                              <?php echo e(trans('lang.completed')); ?>

                            </option>

                            <option <?php if($_GET['ride_status']=='rejected' ): ?>selected="selected" <?php endif; ?> value="rejected">
                              <?php echo e(trans('lang.rejected')); ?>

                            </option>

                            <option <?php if($_GET['ride_status']=='driver_rejected' ): ?>selected="selected" <?php endif; ?>
                              value="driver_rejected"><?php echo e(trans('lang.driver_rejected')); ?></option>

                          </select>

                          <?php else: ?>
                          <input type="text" class="search form-control" name="search" id="search">
                          <select id="ride_status" class="search form-control" name="ride_status" style="display: none">
                            <option value="confirmed"><?php echo e(trans('lang.confirmed')); ?></option>
                            <option value="new"><?php echo e(trans('lang.new')); ?></option>

                            <option value="on ride"><?php echo e(trans('lang.on_ride')); ?></option>
                            <option value="completed"><?php echo e(trans('lang.completed')); ?></option>
                            <option value="rejected"><?php echo e(trans('lang.rejected')); ?></option>
                            <option value="driver_rejected"><?php echo e(trans('lang.driver_rejected')); ?></option>

                          </select>
                          <?php endif; ?>

                          <?php if(isset($_GET['search_one']) && $_GET['search_one'] != ''): ?>
                          <input type="text" class="search form-control" name="search_one" id="search_one"
                            value="<?php echo e($_GET['search_one']); ?>" style="display: none">
                          <select id="ride_type" class="form-control" name="ride_type" style="display: none">
                            <option value="normal"><?php echo e(trans('lang.normal')); ?></option>
                            <option value="dispatcher"><?php echo e(trans('lang.dispatcher')); ?></option>
                            <option value="driver_created"><?php echo e(trans('lang.created_driver')); ?></option>

                          </select>

                          <?php elseif(isset($_GET['ride_type']) && $_GET['ride_type'] != ''): ?>
                          <input type="text" class="search form-control" name="search_one" id="search_one"
                            style="display:none">
                          <select id="ride_type" class="search form-control" name="ride_type">
                            <option <?php if($_GET['ride_type']=='normal' ): ?>selected="selected" <?php endif; ?> value="normal">
                              <?php echo e(trans('lang.normal')); ?>

                            </option>

                            <option <?php if($_GET['ride_type']=='dispatcher' ): ?>selected="selected" <?php endif; ?> value="dispatcher">
                              <?php echo e(trans('lang.dispatcher')); ?>

                            </option>
                            <option <?php if($_GET['ride_type']=='driver_created' ): ?>selected="selected" <?php endif; ?>
                              value="driver_created"><?php echo e(trans('lang.created_driver')); ?></option>

                          </select>

                          <?php else: ?>
                          <input type="text" class="search form-control" name="search_one" id="search_one"
                            style="display: none">
                          <select id="ride_type" class="search form-control" name="ride_type" style="display: none">
                            <option value="normal"><?php echo e(trans('lang.normal')); ?></option>
                            <option value="dispatcher"><?php echo e(trans('lang.dispatcher')); ?></option>
                          </select>
                          <?php endif; ?>



                          <button type="submit" class="btn-flat position-absolute"><i class="fa fa-search"></i></button>
                        </div>
                        <button onclick="searchtext();"
                          class="btn btn-warning btn-flat"><?php echo e(trans('lang.search')); ?></button>
                        <a class="btn btn-warning btn-flat" href="<?php echo e(url('rides/all')); ?>">Clear</a>

                      </form>

                  </div>
                </label>

              </div>


            </div>

            <div class="table-responsive m-t-10">

              <table id="example24"
                class="display nowrap table table-hover table-striped table-bordered table table-striped"
                cellspacing="0" width="100%">
                <thead>
                  <tr>
                    <th class="delete-all"><input type="checkbox" id="is_active"><label class="col-3 control-label"
                        for="is_active"><a id="deleteAll" class="do_not_delete" href="javascript:void(0)"><i
                            class="fa fa-trash"></i> All</a></label></th>
                    <th><?php echo e(trans('lang.ride_id')); ?></th>
                    <th><?php echo e(trans('lang.user_name')); ?></th>
                    <th><?php echo e(trans('lang.driver_name')); ?></th>
                    
                    <th>Advance Payment</th>
                    <th>Remaining Payment</th>

                    <th><?php echo e(trans('lang.cost_amount')); ?></th>
                    <th>Rental Package Details</th>
                    <th><?php echo e(trans('lang.ride_type')); ?></th>
                    <th><?php echo e(trans('lang.status')); ?></th>

                    <th><?php echo e(trans('lang.created')); ?></th>
                    <th><?php echo e(trans('lang.actions')); ?></th>

                  </tr>
                </thead>
                <tbody id="append_list12">
                  <?php if(count($rides) > 0): ?>
                  <?php $__currentLoopData = $rides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ride): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td class="delete-all"><input type="checkbox" id="is_open_<?php echo e($ride->id); ?>" class="is_open"
                        dataid="<?php echo e($ride->id); ?>"><label class="col-3 control-label" for="is_open_<?php echo e($ride->id); ?>"></label>
                    </td>

                    <td><a href="<?php echo e(route('ride.show', ['id' => $ride->id])); ?>"><?php echo e($ride->id); ?></a>
                    </td>
                    <td>
                      <?php if($ride->user_id != null): ?>
                      <a href="<?php echo e(route('users.show', ['id' => $ride->user_id])); ?>"><?php echo e($ride->userPrenom); ?>

                        <?php echo e($ride->userNom); ?> <br> [<?php echo e($ride->user_phone); ?>]
                      </a>
                      <?php else: ?>
                      <?php
                      $userInfo = json_decode($ride->user_info, true);
                      ?>
                      <?php echo e($userInfo ? $userInfo['name'] : ''); ?> <br> [<?php echo e($ride->user_phone); ?>]
                      <?php endif; ?>
                    </td>
                    <td>
                      <?php if($ride->driver_id != null): ?>
                      <a href="<?php echo e(route('driver.show', ['id' => $ride->driver_id])); ?>"><?php echo e($ride->driverPrenom); ?>

                        <?php echo e($ride->driverNom); ?> <br> [<?php echo e($ride->driver_phone); ?>]</a>
                      <?php endif; ?>
                    </td>
                    <td>
                      <span>
                        <?php echo e($currency->symbole."".number_format(floatval($ride->advance_payment),$currency->decimal_digit)); ?>

                        <?php if($ride->razorpay_transaction_id != 0 && $ride->razorpay_transaction_id != ''): ?>
                        <br> [ Razorpay - <?php echo e($ride->razorpay_transaction_id); ?> ]
                        <?php endif; ?>

                      </span>
                    </td>

                    <td>
                      <span>
                        <?php echo e($currency->symbole."".number_format(floatval($ride->remaining_payment),$currency->decimal_digit)); ?>

                        <?php if($ride->statut == 'completed'): ?>
                        <?php if($ride->id_payment_method == 5): ?>
                        <br> CASH
                        <?php else: ?> if($ride->id_payment_method == 15)
                        [ Razorpay - <?php echo e($ride->transaction_id); ?> ]
                        <?php endif; ?>
                        <?php endif; ?>

                      </span>
                    </td>

                    
                    <?php
                    $montant = floatval($ride->montant);
                    $total_price = $montant;

                    $discount = $ride->discount;
                    if ($discount) {
                      $total_price = $montant - $discount;
                    }
                    $tax = json_decode($ride->tax, true);
                    $totalTaxAmount = 0;
                    if (!empty($tax)) {
                      for ($i = 0; $i < sizeof($tax); $i++) {
                        $data = $tax[$i];
                        if ($data['type'] == "Percentage") {
                          $taxValue = (floatval($data['value']) * $total_price) / 100;
                        } else {
                          $taxValue = floatval($data['value']);
                        }
                        $totalTaxAmount += floatval(number_format($taxValue, $currency->decimal_digit));
                      }
                      $total_price = floatval($total_price) + $totalTaxAmount;
                    }
                    if ($ride->tip_amount) {
                      $total_price = floatval($total_price) + floatval($ride->tip_amount);
                    }
                    ?>
                    <td>
                      <!-- <?php echo e($total_price); ?> -->
                      <?php if($currency->symbol_at_right == "true"): ?>
                      <?php echo e(number_format(floatval($total_price), $currency->decimal_digit) . "" . $currency->symbole); ?>

                      <?php else: ?>
                      <?php echo e($currency->symbole . "" . number_format(floatval($total_price), $currency->decimal_digit)); ?>

                      <?php endif; ?>
                      </span>
                    </td>
                    <td>
                      Hours : <?php echo e($ride->hours); ?><br>
                      Kilometers : <?php echo e($ride->kilometers); ?><br>
                      Price : <?php echo e($ride->price); ?><br>
                      Car : <?php echo e($ride->vehicle_libelle); ?>


                    </td>
                    <td><?php if($ride->ride_type == "dispatcher"): ?>
                      <?php echo e(trans('lang.dispatcher')); ?>

                      <?php elseif($ride->ride_type == "driver"): ?>
                      <?php echo e(trans('lang.created_driver')); ?>

                      <?php else: ?>
                      <?php echo e(trans('lang.normal')); ?>

                      <?php endif; ?>
                    </td>

                    <td>
                      <?php if($ride->statut == "completed"): ?>
                      <span class="badge badge-success"><?php echo e($ride->statut); ?><span>
                          <?php elseif($ride->statut == "confirmed"): ?>
                          <span class="badge badge-success"><?php echo e($ride->statut); ?><span>
                              <?php elseif($ride->statut == "new"): ?>
                              <span class="badge badge-primary"><?php echo e($ride->statut); ?><span>
                                  <?php elseif($ride->statut == "rejected"): ?>
                                  <span class="badge badge-danger"><?php echo e($ride->statut); ?><span>
                                      <?php elseif($ride->statut == "driver_rejected"): ?>
                                      <span class="badge badge-danger"><?php echo e(trans("lang.driver_rejected")); ?><span>
                                          <?php else: ?>
                                          <span class="badge badge-warning"><?php echo e($ride->statut); ?><span>
                                              <?php endif; ?>
                    </td>
                    <td class="dt-time"><span class="date"><?php echo e(date('d F Y', strtotime($ride->creer))); ?></span>
                      <span class="time"><?php echo e(date('h:i A', strtotime($ride->creer))); ?></span>

                    </td>
                    <td class="action-btn">

                      <?php if($ride->driver_id == null): ?>
                      <a href="<?php echo e(route('ride.assign-driver', ['id' => $ride->id])); ?>" class="" data-toggle="tooltip"
                        data-original-title="Assign Driver"><i class="fa fa-user-circle"></i></a>
                      <?php endif; ?>

                      <a href="<?php echo e(route('ride.show', ['id' => $ride->id])); ?>" class="" data-toggle="tooltip"
                        data-original-title="Details"><i class="fa fa-eye"></i></a>


                      



                      <a id="'+val.id+'" class="do_not_delete" name="user-delete"
                        href="<?php echo e(route('ride.delete', ['rideid' => $ride->id])); ?>"><i class="fa fa-trash"></i></a>
                    </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  <?php else: ?>
                  <tr>
                    <td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td>
                  </tr>
                  <?php endif; ?>
                </tbody>
              </table>

              <nav aria-label="Page navigation example" class="custom-pagination">
                <!-- <?php echo e($rides->withQueryString()->links()); ?> -->
                <?php echo e($rides->appends(request()->query())->links()); ?>

              </nav>
              <?php echo e($rides->withQueryString()->links('pagination.pagination')); ?>

            </div>
          </div>

        </div>

      </div>

    </div>

  </div>

</div>

</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
  $("#is_active").click(function() {
    $("#example24 .is_open").prop('checked', $(this).prop('checked'));

  });

  $("#deleteAll").click(function() {
    if ($('#example24 .is_open:checked').length) {
      if (confirm('Are You Sure want to Delete Selected Data ?')) {
        var arrayUsers = [];
        $('#example24 .is_open:checked').each(function() {
          var dataId = $(this).attr('dataId');
          arrayUsers.push(dataId);

        });

        arrayUsers = JSON.stringify(arrayUsers);
        var url = "<?php echo e(url('ride/delete', 'rideid')); ?>";
        url = url.replace('rideid', arrayUsers);

        $(this).attr('href', url);
      }
    } else {
      alert('Please Select Any One Record .');
    }
  });

  $(document).ready(function() {

    if ($('#selected_search').val() == "status") {
      jQuery('#search_one').hide();
      jQuery('#search').val('');
    } else {
      jQuery('#search_one').hide();
      jQuery('#ride_status').val('');

    }
    if ($('#selected_search').val() == "type") {
      jQuery('#search').hide();
      jQuery('#search_one').val('');
    } else {
      //jQuery('#search').hide();
      jQuery('#ride_type').val('');

    }

  })
  $(document.body).on('change', '#selected_search', function() {

    if (jQuery(this).val() == 'status') {
      jQuery('#search_one').hide();
      jQuery('#ride_status').show();
      jQuery('#ride_status').val('new');
      jQuery('#search').val('');
      jQuery('#search').hide();
    } else {
      jQuery('#search_one').hide();
      jQuery('#ride_status').hide();
      jQuery('#ride_status').val('');
      jQuery('#search').show();

    }

    if (jQuery(this).val() == 'type') {
      jQuery('#search').hide();
      jQuery('#ride_type').show();
      jQuery('#ride_type').val('normal');
      jQuery('#search_one').val('');
      jQuery('#search_one').hide();
    } else {
      //jQuery('#search').hide();
      jQuery('#ride_type').hide();
      jQuery('#ride_type').val('');
      // jQuery('#search_one').show();

    }

  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/rides/all_rental_rides.blade.php ENDPATH**/ ?>