<?php $__env->startSection('content'); ?>
<div class="page-wrapper">

    <div class="row page-titles">

        <div class="col-md-5 align-self-center">

            <h3 class="text-themecolor"><?php echo e(trans('lang.complaints')); ?></h3>

        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a>
                </li>
                <li class="breadcrumb-item active">
                    <?php echo e(trans('lang.complaints')); ?>

                </li>
            </ol>
        </div>

    </div>

    <div class="container-fluid">

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <div class="userlist-topsearch d-flex mb-3">

                            <div id="users-table_filter" class="ml-auto">

                                <label><?php echo e(trans('lang.search_by')); ?>


                                    <div class="form-group">

                                        <form action="<?php echo e(route('complaints')); ?>" method="get">
                                            <?php if(isset($_GET['selected_search']) && $_GET['selected_search'] != ''): ?>
                                            <select name="selected_search" id="selected_search"
                                                class="form-control input-sm">
                                                <option value="title" <?php if($_GET['selected_search']=='title' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.title')); ?></option>
                                                <option value="message" <?php if($_GET['selected_search']=='message' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.message')); ?></option>
                                                <option value="status" <?php if($_GET['selected_search']=='status' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.status')); ?></option>
                                            </select>
                                            <?php else: ?>
                                            <select name="selected_search" id="selected_search"
                                                class="form-control input-sm">
                                                <option value="title"><?php echo e(trans('lang.title')); ?></option>
                                                <option value="message"><?php echo e(trans('lang.message')); ?></option>
                                                <option value="status"><?php echo e(trans('lang.status')); ?></option>

                                            </select>
                                            <?php endif; ?>
                                            <div class="search-box position-relative">
                                                <?php if(isset($_GET['search']) && $_GET['search'] != ''): ?>
                                                <input type="text" class="search form-control" name="search" id="search"
                                                    value="<?php echo e($_GET['search']); ?>">
                                                <select id="status" class="form-control" name="status"
                                                    style="display: none">
                                                    <option value="initiated"><?php echo e(trans('lang.initiated')); ?></option>
                                                    <option value="processing"><?php echo e(trans('lang.processing')); ?></option>
                                                    <option value="completed"><?php echo e(trans('lang.completed')); ?></option>
                                                </select>
                                                <?php elseif(isset($_GET['status']) && $_GET['status']!=''): ?>
                                                <input type="text" class="search form-control" name="search" id="search"
                                                    style="display:none">
                                                <select id="status" class="search form-control" name="status">
                                                    <option <?php if($_GET['status']=='initiated' ): ?>selected="selected" <?php endif; ?>
                                                        value="initiated"><?php echo e(trans('lang.initiated')); ?></option>

                                                    <option <?php if($_GET['status']=='processing' ): ?>selected="selected"
                                                        <?php endif; ?> value="processing"><?php echo e(trans('lang.processing')); ?></option>

                                                    <option <?php if($_GET['status']=='completed' ): ?>selected="selected" <?php endif; ?>
                                                        value="completed"><?php echo e(trans('lang.completed')); ?></option>
                                                </select>

                                                <?php else: ?>
                                                <input type="text" class="search form-control" name="search"
                                                    id="search">
                                                <select id="status" class="form-control" name="status"
                                                    style="display: none">
                                                    <option value="initiated"><?php echo e(trans('lang.initiated')); ?></option>
                                                    <option value="processing"><?php echo e(trans('lang.processing')); ?></option>
                                                    <option value="completed"><?php echo e(trans('lang.completed')); ?></option>
                                                </select>

                                                <?php endif; ?>
                                                <button type="submit" class="btn-flat position-absolute"><i
                                                        class="fa fa-search"></i></button>
                                                <a class="btn btn-warning btn-flat"
                                                    href="<?php echo e(url('complaints')); ?>">Clear</a>
                                            </div>
                                        </form>
                                    </div>
                                </label>
                            </div>

                        </div>

                        <div class="table-responsive m-t-10">

                            <table id="example24"
                                class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                cellspacing="0" width="100%">

                                <thead>

                                    <tr>
                                        <th class="delete-all"><input type="checkbox" id="is_active"><label
                                                class="col-3 control-label" for="is_active"><a id="deleteAll"
                                                    class="do_not_delete" href="javascript:void(0)"><i
                                                        class="fa fa-trash"></i> All</a></label></th>
                                        <th><?php echo e(trans('lang.order_id')); ?></th>
                                        <th><?php echo e(trans('lang.order_type')); ?></th>
                                        <th><?php echo e(trans('lang.driver_plural')); ?></th>
                                        <th><?php echo e(trans('lang.userName')); ?></th>
                                        <th><?php echo e(trans('lang.title')); ?></th>
                                        <th><?php echo e(trans('lang.complaint_by')); ?></th>
                                        <th><?php echo e(trans('lang.status')); ?></th>
                                        <th><?php echo e(trans('lang.created')); ?></th>
                                        <th><?php echo e(trans('lang.actions')); ?></th>
                                    </tr>

                                </thead>

                                <tbody id="append_list1">
                                    <?php if(count($complaints) > 0): ?>
                                    <?php $__currentLoopData = $complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td class="delete-all"><input type="checkbox" id="is_open_<?php echo e($complaint->id); ?>"
                                                class="is_open" dataid="<?php echo e($complaint->id); ?>"><label
                                                class="col-3 control-label" for="is_open_<?php echo e($complaint->id); ?>"></label>
                                        </td>

                                        <?php if(!empty($complaint->id_ride)): ?>
                                        <?php if(!empty($complaint->rideId)): ?>
                                        <td><a href="<?php echo e(route('ride.show', ['id' => $complaint->id_ride])); ?>"><?php echo e($complaint->id_ride); ?></a></td>
                                         <?php else: ?><td></td>
                                         <?php endif; ?>       
                                        <td><?php echo e(trans('lang.ride')); ?>

                                        </td>
                                        <?php else: ?>
                                        <?php if(!empty($complaint->parcelId)): ?>
                                        <td><a href="<?php echo e(route('parcel.show', ['id' => $complaint->id_parcel])); ?>"><?php echo e($complaint->id_parcel); ?></a></td>
                                        <?php else: ?><td></td>
                                        <?php endif; ?>
                                        <td><?php echo e(trans('lang.parcel')); ?></td>
                                        <?php endif; ?>
                                        <td><a href="<?php echo e(route('driver.show', ['id' => $complaint->driverId])); ?>"><?php echo e($complaint->driverName); ?></a></td>
                                        <td><a href="<?php echo e(route('users.show', ['id' => $complaint->userId])); ?>"><?php echo e($complaint->userName); ?></a></td>
                                        <td><?php echo e($complaint->title); ?></td>
                                        <td><?php echo e($complaint->user_type); ?></td>
                                        <td>
                                         <?php if($complaint->status=="completed"): ?>
                                          <span class="badge badge-success"><?php echo e($complaint->status); ?></span>
                                        <?php elseif($complaint->status == "processing"): ?>                                      
                                            <span class="badge badge-warning"> <?php echo e($complaint->status); ?></span>
                                        <?php elseif($complaint->status == "initiated"): ?>                                      
                                            <span class="badge badge-primary"> <?php echo e($complaint->status); ?></span>
                                        <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="date"><?php echo e(date('d F Y',strtotime($complaint->created))); ?></span>
                                            <span class="time"><?php echo e(date('h:i A',strtotime($complaint->created))); ?></span>
                                        </td>
                                        <td class="action-btn">
                                            <a href="javascript:void(0)" id="<?php echo e($complaint->id); ?>" class="complaint-show"
                                                data-toggle="tooltip" data-original-title="Details"><i
                                                    class="fa fa-eye"></i></a>
                                            <a id="'+val.id+'" class="do_not_delete" name="user-delete"
                                                href="<?php echo e(route('complaints.delete', ['id' => $complaint->id])); ?>"><i
                                                    class="fa fa-trash"></i></a>
                                        </td>
                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <tr>
                                        <td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>

                            </table>

                            <nav aria-label="Page navigation example" class="custom-pagination">
                                <?php echo e($complaints->appends(request()->query())->links()); ?>

                            </nav>
                            <?php echo e($complaints->links('pagination.pagination')); ?>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>
<div class="modal fade" id="showComplaintModal" tabindex="-1" role="dialog" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered location_modal">

        <div class="modal-content">

            <div class="modal-header">

                <h5 class="modal-title locationModalTitle"><?php echo e(trans('lang.complaint_detail')); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>

            </div>

            <div class="modal-body">

                <form action="<?php echo e(route('complaints.update')); ?>" method="post" class="">
                    <?php echo csrf_field(); ?>

                    <div class="form-row">

                        <div class="form-group row">
                            <input type="text" name="complaint_id" id="complaint_id" hidden>
                            <div class="form-group row width-100">
                                <label class="col-12 control-label"><?php echo e(trans('lang.title')); ?></label>

                                <div class="col-12 title">
                                </div>
                            </div>
                            <div class="form-group row width-100">
                                <label class="col-12 control-label"><?php echo e(trans('lang.message')); ?></label>

                                <div class="col-12 message">
                                </div>
                            </div>
                            <div class="form-group row width-100">
                                <label class="col-12 control-label"><?php echo e(trans('lang.status')); ?></label>
                                <div class="col-12">
                                    <?php
                                    $status = ['initiated' => 'initiated', 'processing'=> 'processing','completed' =>
                                    'completed',]
                                    ?>
                                    <select name="complaint_status" class="form-control" class="status"
                                        id="complaint_status">
                                        <?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>"> <?php echo e($value); ?>

                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>

                                </div>
                            </div>

                        </div>

                    </div>


                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" id="add-wallet-btn"><?php echo e(trans('submit')); ?></a>
                        </button>
                        <button type="button" class="btn btn-primary" data-dismiss="modal" aria-label="Close">
                            <?php echo e(trans('close')); ?></a>
                        </button>

                    </div>
                </form>


            </div>
        </div>

    </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
    $(document).ready(function () {

    })

    $("#is_active").click(function () {
        $("#example24 .is_open").prop('checked', $(this).prop('checked'));

    });

    $("#deleteAll").click(function () {
        if ($('#example24 .is_open:checked').length) {
            if (confirm('Are You Sure want to Delete Selected Data ?')) {
                var arrayUsers = [];
                $('#example24 .is_open:checked').each(function () {
                    var dataId = $(this).attr('dataId');
                    arrayUsers.push(dataId);

                });

                arrayUsers = JSON.stringify(arrayUsers);
                var url = "<?php echo e(url('complaints/delete', 'id')); ?>";
                url = url.replace('id', arrayUsers);

                $(this).attr('href', url);
            }
        } else {
            alert('Please Select Any One Record .');
        }
    });

    $('.complaint-show').on('click', function () {
        var id = this.id;
        var url = "<?php echo e(url('complaints/show', 'id')); ?>";
        url = url.replace('id', id);

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: url,
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                $('.title').text(data.title);
                $('.message').text(data.description);
                $('#complaint_status [value="' + data.status + '"]').attr('selected', 'true');
                $('#complaint_id').val(id);
                $('#showComplaintModal').modal('show');
            },
        })
    })
    $(document).ready(function () {

        if ($('#selected_search').val() == "status") {
            jQuery('#search').val('');
        } else {
            jQuery('#status').val('');

        }
    })

    $(document.body).on('change', '#selected_search', function () {

        if (jQuery(this).val() == 'status') {
            jQuery('#status').show();
            jQuery('#status').val('initiated');
            jQuery('#search').val('');
            jQuery('#search').hide();
        } else {
            jQuery('#status').hide();
            jQuery('#status').val('');
            jQuery('#search').show();

        }
    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/complaints/index.blade.php ENDPATH**/ ?>