<?php $__env->startSection('content'); ?>

<div class="page-wrapper">


    <div class="row page-titles">

        <div class="col-md-5 align-self-center">

            <h3 class="text-themecolor"><?php echo e(trans('lang.coupon_plural')); ?></h3>

        </div>

        <div class="col-md-7 align-self-center">

            <ol class="breadcrumb">

                <li class="breadcrumb-item">
                    <a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a>
                </li>

                <li class="breadcrumb-item active">
                    <?php echo e(trans('lang.coupon_table')); ?>

                </li>

            </ol>

        </div>

        <div>

        </div>

    </div>

    <div class="container-fluid">

        <div class="row">

            <div class="col-12">

                <?php if (@$id != '') { ?>
                    <div class="menu-tab">
                        <ul>
                            <li>
                                <a href="<?php echo e(route('restaurants.view',$id)); ?>"><?php echo e(trans('lang.tab_basic')); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('restaurants.foods',$id)); ?>"><?php echo e(trans('lang.tab_foods')); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('restaurants.orders',$id)); ?>"><?php echo e(trans('lang.tab_orders')); ?></a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('restaurants.reviews',$id)); ?>"><?php echo e(trans('lang.tab_reviews')); ?></a>
                            </li>
                            <li class="active">
                                <a href="<?php echo e(route('restaurants.coupons',$id)); ?>"><?php echo e(trans('lang.tab_promos')); ?></a>
                            <li>
                                <a href="<?php echo e(route('restaurants.payout',$id)); ?>"><?php echo e(trans('lang.tab_payouts')); ?></a>
                            </li>
                            <!-- <li class="active">
                            <a href="<?php echo e(route('restaurants.coupons',$id)); ?>"><?php echo e(trans('lang.tab_coupons')); ?></a>
                            </li> -->
                        </ul>
                    </div>
                <?php } ?>

                <div class="card">
                    <div class="card-header" style="display:none">
                        <ul class="nav nav-tabs align-items-end card-header-tabs w-100">
                            <li class="nav-item">
                                <a class="nav-link active" href="<?php echo url()->current(); ?>"><i
                                        class="fa fa-list mr-2"></i><?php echo e(trans('lang.coupon_table')); ?></a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="<?php echo route('coupons.create'); ?>"><i
                                        class="fa fa-plus mr-2"></i><?php echo e(trans('lang.coupon_create')); ?></a>
                            </li>

                        </ul>
                    </div>
                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default"
                            style="display: none;">
                            Processing...
                        </div>

                        <div class="userlist-topsearch d-flex mb-3">

                            <div class="userlist-top-left">
                                <a class="nav-link do_not_create" href="<?php echo route('coupons.create'); ?>"><i
                                        class="fa fa-plus mr-2"></i><?php echo e(trans('lang.coupon_create')); ?></a>
                            </div>

                            <div id="users-table_filter" class="ml-auto">
                                <label><?php echo e(trans('lang.search_by')); ?>

                                    <div class="form-group mb-0">
                                        <form action="<?php echo e(route('coupons')); ?>" method="get">
                                            <?php if(isset($_GET['selected_search']) && $_GET['selected_search'] != ''): ?>
                                            <select name="selected_search" id="selected_search"
                                                class="form-control input-sm">
                                                <option value="code" <?php if($_GET[ 'selected_search' ]=='code' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.coupon_code')); ?></option>

                                                <option value="discount" <?php if($_GET[ 'selected_search' ]=='discount' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.coupon_discount')); ?></option>
                                            </select>
                                            <?php else: ?>
                                            <select name="selected_search" id="selected_search"
                                                class="form-control input-sm">
                                                <option value="code"><?php echo e(trans('lang.coupon_code')); ?></option>
                                                <option value="discount"><?php echo e(trans('lang.coupon_discount')); ?></option>
                                            </select>
                                            <?php endif; ?>
                                            <div class="search-box position-relative">
                                                <?php if(isset($_GET['search']) && $_GET['search'] != ''): ?>
                                                <input type="text" class="search form-control" name="search" id="search"
                                                    value="<?php echo e($_GET['search']); ?>">
                                                <?php else: ?>
                                                <input type="text" class="search form-control" name="search" id="search">
                                                <?php endif; ?>
                                                <button type="submit" class="btn-flat position-absolute">
                                                    <i class="fa fa-search"></i>
                                                </button>
                                                <!-- <input type="search" id="search" class="search form-control" placeholder="Search" aria-controls="users-table"></label>&nbsp;<button onclick="searchtext();" class="btn btn-warning btn-flat">Search</button>&nbsp; -->
                                                <!-- <button onclick="searchclear();" class="btn btn-warning btn-flat">Clear</button> -->
                                                <a class="btn btn-warning btn-flat" href="<?php echo e(url('coupons')); ?>">Clear</a>
                                            </div>
                                        </form>
                                    </div>
                                </label>
                            </div>
                        </div>

                        <div class="table-responsive m-t-10">

                            <table id="example24"
                                class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                cellspacing="0" width="100%">

                                <thead>

                                    <tr>

                                        <th class="delete-all"><input type="checkbox" id="is_active"><label
                                                class="col-3 control-label" for="is_active"><a id="deleteAll"
                                                    class="do_not_delete"
                                                    href="javascript:void(0)"><i
                                                        class="fa fa-trash"></i> All</a></label></th>

                                        <th><?php echo e(trans('lang.coupon_code')); ?></th>

                                        <th><?php echo e(trans('lang.coupon_discount')); ?></th>

                                        <th><?php echo e(trans('lang.percent_type')); ?></th>
                                        <th><?php echo e(trans('lang.coupon_type')); ?></th>

                                        <th><?php echo e(trans('lang.title')); ?></th>
                                        <th><?php echo e(trans('lang.coupon_description')); ?></th>
                                        <th><?php echo e(trans('lang.rating')); ?></th>

                                        <th><?php echo e(trans('lang.coupon_expires_at')); ?></th>

                                        <th><?php echo e(trans('lang.coupon_enabled')); ?></th>

                                        <th><?php echo e(trans('lang.actions')); ?></th>

                                    </tr>

                                </thead>

                                <tbody id="append_list1">
                                    <?php if(count($discounts) > 0): ?>
                                    <?php $__currentLoopData = $discounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $discount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="delete-all"><input type="checkbox"
                                                id="is_open_<?php echo e($discount->id); ?>"
                                                class="is_open"
                                                dataid="<?php echo e($discount->id); ?>"><label
                                                class="col-3 control-label"
                                                for="is_open_<?php echo e($discount->id); ?>"></label></td>

                                        <td><?php echo e($discount->code); ?></td>
                                        <td><?php echo e($discount->discount ?? '-'); ?></td>
                                        <td><?php echo e($discount->type); ?></td>
                                        <td><?php echo e($discount->coupon_type); ?></td>
                                        <td><?php echo e($discount->title ?? '-'); ?></td>
                                        <td><?php echo e($discount->discription); ?></td>
                                        <td><?php echo e($discount->rating ?? '-'); ?></td>
                                        <td>
                                            <span class="date"><?php echo e(date('d F Y',strtotime($discount->expire_at))); ?></span>
                                            <span class="time"><?php echo e(date('h:i A',strtotime($discount->expire_at))); ?></span>
                                        </td>
                                        <td><?php if($discount->statut=="yes"): ?>
                                            <label class="switch"><input type="checkbox" checked id="<?php echo e($discount->id); ?>" name="publish"><span class="slider round"></span></label>
                                            <?php else: ?> <label class="switch"><input type="checkbox" id="<?php echo e($discount->id); ?>" name="publish"><span class="slider round"></span></label>
                                            <?php endif; ?>
                                        </td>

                                        <!-- <td class="action-btn"><a href="<?php echo e(route('coupons.edit', ['id' => $discount->id])); ?>"><i class="fa fa-edit"></i></a></td> -->
                                        <td class="action-btn">
                                            <a href="<?php echo e(route('coupons.show', ['id' => $discount->id])); ?>" class=""
                                                data-toggle="tooltip" data-original-title="Details"><i
                                                    class="fa fa-eye"></i></a>
                                            <a href="<?php echo e(route('coupons.edit', ['id' => $discount->id])); ?>" class="do_not_edit"><i
                                                    class="fa fa-edit"></i></a><a id="'+val.id+'" class="do_not_delete"
                                                name="coupon-delete"
                                                href="<?php echo e(route('coupons.delete', ['id' => $discount->id])); ?>"><i
                                                    class="fa fa-trash"></i></a>
                                        </td>

                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <tr>
                                        <td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>

                            </table>

                            <!-- <nav aria-label="Page navigation example">
                                <ul class="pagination justify-content-center">
                                    <li class="page-item ">
                                        <a class="page-link" href="javascript:void(0);" id="users_table_previous_btn"
                                           onclick="prev()" data-dt-idx="0" tabindex="0"><?php echo e(trans('lang.previous')); ?></a>
                                    </li>
                                    <li class="page-item">
                                        <a class="page-link" href="javascript:void(0);" id="users_table_next_btn"
                                           onclick="next()" data-dt-idx="2" tabindex="0"><?php echo e(trans('lang.next')); ?></a>
                                    </li>
                                </ul>
                            </nav> -->
                            <nav aria-label="Page navigation example" class="custom-pagination">
                                <!-- <?php echo e($discounts->links()); ?> -->
                                <?php echo e($discounts->appends(request()->query())->links()); ?>

                            </nav>
                            <?php echo e($discounts->links('pagination.pagination')); ?>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
    $("#is_active").click(function() {
        $("#example24 .is_open").prop('checked', $(this).prop('checked'));

    });

    $("#deleteAll").click(function() {
        if ($('#example24 .is_open:checked').length) {
            if (confirm('Are You Sure want to Delete Selected Data ?')) {
                var arrayUsers = [];
                $('#example24 .is_open:checked').each(function() {
                    var dataId = $(this).attr('dataId');
                    arrayUsers.push(dataId);

                });

                arrayUsers = JSON.stringify(arrayUsers);
                var url = "<?php echo e(url('coupons/delete', 'id')); ?>";
                url = url.replace('id', arrayUsers);

                $(this).attr('href', url);
            }
        } else {
            alert('Please Select Any One Record .');
        }
    });
    /* toggal publish action code start*/
    // $(document).on("click", "input[name='publish']", function(e) {

    //     var ischeck = $(this).is(':checked');
    //     var id = this.id;

    //     $.ajax({
    //         headers: {
    //             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    //         },
    //         url: 'coupon/switch',
    //         method: "POST",
    //         data: {
    //             'ischeck': ischeck,
    //             'id': id
    //         },
    //         success: function(res) {
    //             console.log(res);

    //         },
    //         error: function(xhr) {
    //             alert(xhr.responseJSON.message);
    //             location.reload();
    //         }
    //     });

    // });


    $('.switch input[type="checkbox"]').on('change', function() {
        let ischeck = $(this).is(':checked');
        let id = $(this).attr('id');

        $.ajax({
            url: 'coupon/switch',
            method: 'POST',
            data: {
                id: id,
                ischeck: ischeck,
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(res) {
                if (!res.status) {
                    alert(res.message);
                    window.location.reload(true);
                }
            },
            error: function(xhr) {
                alert(xhr.responseJSON.message);
                location.reload();
            }
        });
    });



    /*toggal publish action code end*/
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/coupons/index.blade.php ENDPATH**/ ?>