<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">


        <div class="row page-titles">

            <div class="col-md-5 align-self-center">

                <h3 class="text-themecolor"><?php echo e(trans('lang.driver_wallet_transaction_plural')); ?></h3>

            </div>

            <div class="col-md-7 align-self-center">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(trans('lang.driver_wallet_transaction_plural')); ?></li>
                </ol>
            </div>

            <div>

            </div>

        </div>


        <div class="container-fluid">

            <div class="row">

                <div class="col-12">

                    <div class="card">
                        <div class="card-header">
                            <ul class="nav nav-tabs align-items-end card-header-tabs w-100">
                                <li class="nav-item">
                                    <a class="nav-link active" href="<?php echo url()->current(); ?>"><i
                                                class="fa fa-list mr-2"></i><?php echo e(trans('lang.driver_wallet_transaction_table')); ?>

                                    </a>
                                </li>

                            </ul>
                        </div>
                        <div class="card-body">
                            <div id="data-table_processing" class="dataTables_processing panel panel-default"
                                 style="display: none;"><?php echo e(trans('lang.processing')); ?></div>

                            <?php if($id!=''): ?>
                                <form action="<?php echo e(url('walletstransactions/driver',['id'=>$id])); ?>" method="get">
                                    <?php else: ?>
                                        <form action="<?php echo e(route('walletstransactions.driver')); ?>" method="get">
                                            <?php endif; ?>


                                            <div id="users-table_filter" class="pull-right">
                                                <label><?php echo e(trans('lang.search_by')); ?>

                                                    <?php if(isset($_GET['selected_search']) && $_GET['selected_search'] != ''): ?>
                                                        <select name="selected_search" id="selected_search"
                                                                class="form-control input-sm">
                                                            <option value="transaction_id" <?php if($_GET[
                                            'selected_search']=='transaction_id'): ?>
                                                            selected="selected" <?php endif; ?>><?php echo e(trans('lang.transaction_id')); ?></option>

                                                        </select>
                                                    <?php else: ?>
                                                        <select name="selected_search" id="selected_search"
                                                                class="form-control input-sm">
                                                            <option value="transaction_id"><?php echo e(trans('lang.transaction_id')); ?></option>

                                                        </select>
                                                    <?php endif; ?>
                                                    <div class="form-group">

                                                        <?php if(isset($_GET['payment_status']) && $_GET['payment_status'] != ''): ?>

                                                            <input type="text" id="search" name="search"
                                                                   class="search form-control" placeholder="Search"
                                                                   aria-controls="users-table" style="display: none">

                                                        <?php elseif(isset($_GET['search']) && $_GET['search'] != ''): ?>
                                                            <input type="text" id="search" name="search"
                                                                   class="search form-control" placeholder="Search"
                                                                   aria-controls="users-table"
                                                                   value="<?php echo e($_GET['search']); ?>">

                                                        <?php else: ?>

                                                            <input type="text" id="search" name="search"
                                                                   class="search form-control" placeholder="Search"
                                                                   aria-controls="users-table">
                                                    <?php endif; ?>

                                                </label>

                                                &nbsp;<button onclick="searchtext();"
                                                              class="btn btn-warning btn-flat"><?php echo e(trans('lang.search')); ?></button>&nbsp;


                                                <?php if($id!=''): ?>
                                                    <a href="<?php echo e(url('walletstransactions/driver',['id'=>$id])); ?>"
                                                    class="btn btn-warning btn-flat"><?php echo e(trans('lang.clear')); ?></a>
                                                <?php else: ?>
                                                    <a href="<?php echo e(route('walletstransactions.driver')); ?>"
                                                    class="btn btn-warning btn-flat"><?php echo e(trans('lang.clear')); ?></a>
                                                <?php endif; ?>


                                            </div>
                                        </form>
                        </div>


                        <div class="table-responsive m-t-10">


                            <table id="example24"
                                   class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                   cellspacing="0" width="100%">

                                <thead>

                                <tr>
                                    <th><?php echo e(trans('lang.transaction_id')); ?></th>
                                    <?php if($id==''): ?>
                                    <th><?php echo e(trans('lang.driver')); ?></th>
                                    <?php endif; ?>
                                    <th><?php echo e(trans('lang.amount')); ?></th>
                                    <th><?php echo e(trans('lang.date')); ?></th>
                                    <th><?php echo e(trans('lang.payment_method')); ?></th>
                                    <th><?php echo e(trans('lang.payment_status')); ?></th>
                                </tr>

                                </thead>

                                <tbody id="append_list1">

                                  <?php if(count($transaction) > 0): ?>
                                <?php $__currentLoopData = $transaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                    <!-- <td><?php echo e($data->id); ?></td> -->
                                        <td><?php echo e($data->id); ?></td>
                                        <?php if($id==''): ?>
                                        <td>
                                            <a href="<?php echo e(route('driver.show',['id'=>$data->userId])); ?>"><?php echo e($data->firstname); ?> <?php echo e($data->lastname); ?></a>
                                        </td>
                                        <?php endif; ?>
                                        <td>
                                         <?php if($currency->symbol_at_right=="true"): ?>
                                            <?php if(substr($data->amount,0,1)=="-"): ?>
                                            <span style="color:red">(-<?php echo e(number_format(floatval(substr($data->amount,1)),$currency->decimal_digit)."".$currency->symbole); ?>)</span>
                                            <?php else: ?>
                                            <span style="color:green"><?php echo e(number_format(floatval($data->amount),$currency->decimal_digit)."".$currency->symbole); ?></span>
                                            <?php endif; ?>
                                         <?php else: ?>
                                             <?php if(substr($data->amount,0,1)=="-"): ?>
                                               <span style="color:red">(-<?php echo e($currency->symbole."".number_format(floatval(substr($data->amount,1)),$currency->decimal_digit)); ?>)</span>
                                             <?php else: ?>
                                              <span style="color:green"><?php echo e($currency->symbole."".number_format(floatval($data->amount),$currency->decimal_digit)); ?></span>
                                             <?php endif; ?>
                    
                                         <?php endif; ?>   
                                        </td>
                                        <td>
                                            <span class="date"><?php echo e(date('d F Y',strtotime($data->creer))); ?></span>
                                            <span class="time"><?php echo e(date('h:i A',strtotime($data->creer))); ?></span>
                                        </td>
                                        
                                        <?php if($data->image): ?>
                                            <td><img class="rounded" style="width:50px"
                                                src="<?php echo e(asset('/assets/images/payment_method/'.$data->image)); ?>"
                                                 alt="image"></td>
											<?php else: ?>
											<td><?php echo e($data->payment_method); ?></td>
                                        <?php endif; ?>

                                        
                                        <td>
                                                <span class="badge badge-success"><?php echo e(trans('lang.success')); ?></span>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 <?php else: ?>
                                	<tr><td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td></tr>
                                <?php endif; ?>

                                </tbody>

                            </table>
                            <nav aria-label="Page navigation example" class="custom-pagination">
                            <?php echo e($transaction->appends(request()->query())->links()); ?>

                            </nav>
                            <?php echo e($transaction->links('pagination.pagination')); ?>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    </div>

    </div>
    </div>



<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
      /*  $(document).ready(function () {
            $(".shadow-sm").hide();
            if($('#selected_search').val()=="transaction_id"){
              jQuery('#payment_status').val('');
            }else{
              jQuery('#search').val('');
            }
        })
        $(document.body).on('change', '#selected_search', function () {

            if (jQuery(this).val() == 'payment_status') {
                jQuery('#payment_status').show();
                  jQuery('#payment_status').val('success');
                jQuery('#search').val('');
                jQuery('#search').hide();
            } else {

                jQuery('#payment_status').hide();
                jQuery('#payment_status').val('');
                jQuery('#search').show();

            }
        });*/
    </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/transactions/driver_wallet.blade.php ENDPATH**/ ?>