<?php $__env->startSection('content'); ?>


<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.vehicle_type')); ?></h3>
        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('vehicle/index')); ?>"><?php echo e(trans('lang.vehicle_type')); ?></a>
                </li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.create_vehicle_type')); ?></li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card pb-4">

                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default"
                            style="display: none;"><?php echo e(trans('lang.processing')); ?></div>
                        <div class="error_top"></div>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <form action="<?php echo e(route('vehicle-type.store')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row restaurant_payout_create">
                                <div class="restaurant_payout_create-inner">


                                    <fieldset>
                                        <legend><?php echo e(trans('lang.create_vehicle_type')); ?></legend>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_type')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control"
                                                    value="<?php echo e(Request::old('libelle')); ?>" name="libelle">
                                                <!-- <div class="form-text text-muted"></div> -->
                                            </div>
                                        </div>

                                        <!-- <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.price')); ?></label>
              <div class="col-7">
                  <input type="text" class="form-control" name="prix" value="<?php echo e(Request::old('prix')); ?>">
                   <div class="form-text text-muted"></div> -->
                                        <!--</div>
                                          </div> -->

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.Image')); ?></label>
                                            <div class="col-7">
                                                <input type="file" class="form-control" name="image" value=""
                                                    onchange="readURL(this);">
                                                <!-- <div class="form-text text-muted"></div> -->
                                                <div id="image_preview" style="display: none; padding-left: 15px;">
                                                    <img class="rounded" style="width:50px" id="uploding_image" src="#"
                                                        alt="image">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <div class="form-check">
                                                <input type="checkbox" class="user_active" id="user_active"
                                                    name="status" value="Yes">
                                                <label class="col-3 control-label"
                                                    for="user_active"><?php echo e(trans('lang.active')); ?></label>

                                            </div>
                                        </div>

                                    </fieldset>
                                    <fieldset>
                                        <legend><?php echo e(trans('lang.delivery_charge')); ?></legend>

                                        <div class="form-group row width-100">
                                            <label
                                                class="col-3 control-label">Base fare</label>
                                            <div class="col-7">
                                                <input type="number" class="form-control"
                                                    name="minimum_delivery_charge_within_km"
                                                    value="<?php echo e(Request::old('minimum_delivery_charge_within_km')); ?>">
                                                <!-- <div class="form-text text-muted"></div> -->
                                            </div>
                                        </div>

                                        <div class="form-group row width-100">
                                            <label
                                                class="col-3 control-label">Minimum KM for Base Fare</label>
                                            <div class="col-7">
                                                <input type="number" class="form-control" name="minimum_delivery_charge"
                                                    value="<?php echo e(Request::old('minimum_delivery_charge')); ?>">
                                                <!-- <div class="form-text text-muted"></div> -->
                                            </div>
                                        </div>

                                     

                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label">OutStation KM</label>
                                            <div class="col-7">
                                                <input type="number" class="form-control"
                                                    value="<?php echo e(Request::old('outstation_radius')); ?>"
                                                    name="outstation_radius">
                                                <!-- <div class="form-text text-muted"></div> -->
                                            </div>
                                        </div>

                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label">Local Rate PER KM</label>
                                            <div class="col-7">
                                                <input type="number" class="form-control"
                                                    value="<?php echo e(Request::old('delivery_charge_per_km')); ?>"
                                                    name="delivery_charge_per_km">
                                                <!-- <div class="form-text text-muted"></div> -->
                                            </div>
                                        </div>

                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label">OutStation Rate Per KM</label>
                                            <div class="col-7">
                                                <input type="number" class="form-control"
                                                    value="<?php echo e(Request::old('outstation_delivery_charge_per_km')); ?>"
                                                    name="outstation_delivery_charge_per_km">
                                                <!-- <div class="form-text text-muted"></div> -->
                                            </div>
                                        </div>

                                        

                                    </fieldset>
                                    <fieldset>

                                        <legend><?php echo e(trans('lang.rental_packages')); ?></legend>
                                        <div class="row repeter">
                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"><?php echo e(trans('lang.hours')); ?></label>
                                                <div class="col-7">
                                                    <select class="form-control hours_0" id="hours" name="hours[]"
                                                        onchange="setval(0)">
                                                        <option>Select</option>
                                                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option data-value="<?php echo e($p->kilometers); ?>" value="<?php echo e($p->id); ?>">
                                                                <?php echo e($p->hours); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"><?php echo e(trans('lang.kilometers')); ?></label>
                                                <div class="col-7">
                                                    <input type="number" class="form-control kilometers_0"
                                                        name="kilometers[]" readonly>
                                                </div>
                                            </div>

                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"><?php echo e(trans('lang.price')); ?></label>
                                                <div class="col-7">
                                                    <input type="number" class="form-control" name="price[]">
                                                </div>
                                            </div>
                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"></label>
                                                <div class="col-7">

                                                    <button type="button" class="btn btn-primary "
                                                        onclick="add_rentals(0)"><i class="fa fa-plus"></i></button>

                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>

                                </div>
                            </div>
                    </div>
                    <div class="form-group col-12 text-center btm-btn">
                        <button type="submit" class="btn btn-primary  save_user_btn"><i
                                class="fa fa-save"></i><?php echo e(trans('lang.save')); ?></button>
                        <a href="<?php echo e(url('vehicle/index')); ?>" class="btn btn-default"><i
                                class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
                    </div>

                </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
    $(document).ready(function () {
        $(".shadow-sm").hide();
    })

    function readURL(input) {
        console.log(input.files);
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
                $('#image_preview').show();
                $('#uploding_image').attr('src', e.target.result);


            }

            reader.readAsDataURL(input.files[0]);
        }
    }

    function add_rentals(count) {

        count++;
        var html = `<div><div class="form-group row width-50">
                                                <label class="col-3 control-label"><?php echo e(trans('lang.hours')); ?></label>
                                                <div class="col-7">
                                                    <select class="form-control hours_`+ count + `" id="hours" name="hours[]" onchange="setval(` + count + `)">
                                                        <option>Select</option>
                                                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option data-value="<?php echo e($p->kilometers); ?>" value="<?php echo e($p->id); ?>"><?php echo e($p->hours); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"><?php echo e(trans('lang.kilometers')); ?></label>
                                                <div class="col-7">
                                                    <input type="number" class="form-control kilometers_`+ count + `" name="kilometers[]" readonly>
                                                </div>
                                            </div>

                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"><?php echo e(trans('lang.price')); ?></label>
                                                <div class="col-7">
                                                    <input type="number" class="form-control" name="price[]">
                                                </div>
                                            </div>
                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"></label>
                                                <div class="col-7">

                                                    <button type="button" class="btn btn-primary "
                                                        onclick="add_rentals(`+ count + `)"><i class="fa fa-plus"></i></button>
                                                    <button type="button" class="btn btn-danger delete_repeter "
                                                ><i class="fa fa-trash"></i></button>

                                                </div>
                                            </div></div>`;

        $('.repeter').append(html);



    }

    $(document).on("click", ".delete_repeter", function () {
        $(this).parent().parent().parent().remove();
    });

    function setval(count) {
        var val = $('.hours_' + count).find(':selected').data('value');
        $('.kilometers_' + count).val(val);
    }

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/vehicle/creates.blade.php ENDPATH**/ ?>