<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">

        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h3 class="text-themecolor"><?php echo e(trans('lang.all_rental_packages')); ?></h3>
            </div>
            <div class="col-md-7 align-self-center">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                    <li class="breadcrumb-item active">Rental Packages</li>
                </ol>
            </div>
            <div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <div class="card-body">
                            <div id="data-table_processing" class="dataTables_processing panel panel-default"
                                 style="display: none;"><?php echo e(trans('lang.processing')); ?>

                            </div>
                            <div class="userlist-topsearch d-flex mb-3">
                                <div class="userlist-top-left">
                                    <a class="nav-link" href="<?php echo route('rental-packages.create'); ?>"><i
                                                class="fa fa-plus mr-2"></i><?php echo e(trans('lang.rental_package_create')); ?></a>
                                </div>
                                <div id="users-table_filter" class="ml-auto">
                                    <label><?php echo e(trans('lang.search_by')); ?>

                                    <div class="form-group mb-0">
                                        <form action="<?php echo e(route('rental-packages')); ?>" method="get">

                                            <div class="search-box position-relative">
                                                <?php if(isset($_GET['search']) &&  $_GET['search'] != ''): ?>
                                                    <input type="text" class="search form-control" name="search"
                                                           id="search" value="<?php echo e($_GET['search']); ?>">
                                                <?php else: ?>
                                                    <input type="text" class="search form-control" name="search"
                                                           id="search">
                                                <?php endif; ?>
                                                <button type="submit" class="btn-flat position-absolute"><i
                                                            class="fa fa-search"></i></button>
                                                <!-- <input type="search" id="search" class="search form-control" placeholder="Search" aria-controls="users-table"></label>&nbsp;<button onclick="searchtext();" class="btn btn-warning btn-flat">Search</button>&nbsp; -->
                                                <!-- <button onclick="searchclear();" class="btn btn-warning btn-flat">Clear</button> -->
                                                <a class="btn btn-warning btn-flat" href="<?php echo e(url('rental/packages')); ?>">Clear</a>
                                            </div>
                                        </form>
                                    </div>
                                    </label>
                                </div>
                            </div>
                            <div class="table-responsive m-t-10">
                                <table id="example24"
                                       class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                       cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="delete-all"><input type="checkbox" id="is_active"><label
                                                    class="col-3 control-label" for="is_active"><a id="deleteAll"
                                                                                                   class="do_not_delete"
                                                                                                   href="javascript:void(0)"><i
                                                            class="fa fa-trash"></i> All</a></label></th>
                                        <th><?php echo e(trans('lang.hours')); ?></th>
                                        <th><?php echo e(trans('lang.kilometers')); ?></th>
                                        <th><?php echo e(trans('lang.status')); ?></th>
                                        <th><?php echo e(trans('lang.actions')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody id="append_list12">
                                     <?php if(count($packages) > 0): ?>
                                    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="delete-all"><input type="checkbox"
                                                                          id="is_open_<?php echo e($p->id); ?>"
                                                                          class="is_open"
                                                                          dataid="<?php echo e($p->id); ?>"><label
                                                        class="col-3 control-label"
                                                        for="is_open_<?php echo e($p->id); ?>"></label></td>

                                            
                                            <td><?php echo e($p->hours); ?></td>
                                            <td><?php echo e($p->kilometers); ?></td>

                                                <?php if($p->status == "yes"): ?>
                                              <td>  <label class="switch"><input type="checkbox" checked id="<?php echo e($p->id); ?>" name="publish">
                                              <span class="slider round"></span></label></td>

                                                <?php else: ?>
                                                  <td><label class="switch"><input type="checkbox" id="<?php echo e($p->id); ?>" name="publish"><span class="slider round"></span></label></td>
                                                <?php endif; ?>

                                            <td class="action-btn">
                                                     <a   href="<?php echo e(route('rental-packages.edit', ['id' => $p->id])); ?>"><i
                                                            class="fa fa-edit"></i></a><a id="'+val.id+'"
                                                                                          class="do_not_delete"
                                                                                          name="rental-packages-delete"
                                                                                          href="<?php echo e(route('rental-packages.delete', ['id' => $p->id])); ?>"><i
                                                            class="fa fa-trash"></i></a>
                                                </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                	<tr><td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td></tr>
                                <?php endif; ?>
                                    </tbody>
                                </table>


                                <nav aria-label="Page navigation example" class="custom-pagination">
                                    <?php echo e($packages->appends(request()->query())->links()); ?>

                                </nav>
                                <?php echo e($packages->links('pagination.pagination')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

    <script type="text/javascript">


        $(document).ready(function () {
            $(".shadow-sm").hide();
        })

        $("#is_active").click(function () {
            $("#example24 .is_open").prop('checked', $(this).prop('checked'));

        });

        $("#deleteAll").click(function () {
            if ($('#example24 .is_open:checked').length) {
              
                if (confirm('Are You Sure want to Delete Selected Data ?')) {
                    var arrayUsers = [];
                    $('#example24 .is_open:checked').each(function () {
                        var dataId = $(this).attr('dataId');
                        arrayUsers.push(dataId);

                    });

                    arrayUsers = JSON.stringify(arrayUsers);
                    var url = "<?php echo e(url('user/delete', 'id')); ?>";
                    url = url.replace('id', arrayUsers);

                   $(this).attr('href', url);
                }
            } else {
                alert('Please Select Any One Record .');
            }
        });
       
        /* toggal publish action code start*/
   $(document).on("click", "input[name='publish']", function (e) {
       var ischeck = $(this).is(':checked');
       var id = this.id;
       console.log(id);
       $.ajax({
         headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      },
          url : '/rental/packages/switch',
          method:"POST",
          data:{'ischeck':ischeck,'id':id},
          success: function(data){

          },
       });

   });

   /*toggal publish action code end*/
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/settings/all_rental_packages/index.blade.php ENDPATH**/ ?>