<?php $__env->startSection('content'); ?>

<div class="page-wrapper ridedetail-page">

	<div class="row page-titles non-printable">

		<div class="col-md-5 align-self-center">

			<h3 class="text-themecolor"><?php echo e(trans('lang.ride_detail')); ?></h3>

		</div>

		<div class="col-md-7 align-self-center">

			<ol class="breadcrumb">

				<li class="breadcrumb-item">
					<a href="<?php echo url('/dashboard'); ?>"><?php echo e(trans('lang.home')); ?></a>
				</li>

				<li class="breadcrumb-item">
					<a href="<?php echo route('rides.all'); ?>"><?php echo e(trans('lang.all_rides')); ?></a>
				</li>

				<li class="breadcrumb-item active">
					<?php echo e(trans('lang.ride_detail')); ?>

				</li>

			</ol>

		</div>
	</div>

	<div class="container-fluid">

		<div class="row">

			<div class="col-12">

				<div class="card">
					<div class="card-body">

						
		<div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;"><?php echo e(trans('lang.processing')); ?></div>
		<div class="col-md-12">
			<div class="print-top non-printable mt-3">
				<div class="text-right print-btn non-printable">
					<button type="button" class="fa fa-print non-printable" onclick="printDiv('printableArea')"></button>
				</div>
			</div>

			<hr class="non-printable">
		</div>

		<form method="post" action="<?php echo e(route('rides.update',$ride->id)); ?>" enctype="multipart/form-data">
			<?php echo csrf_field(); ?>
			<?php echo method_field("PUT"); ?>
			<div class="order_detail printableArea" id="order_detail">
				<div class="order_detail-top mb-3 ">
					<div class="row">
						<div class="order_edit-genrl col-md-12">
							<div class="card">
								<div class="card-header bg-white">
									<h3><?php echo e(trans("Requested Driver")); ?></h3>
								</div>
								<div class="card-body">


									<table class="table table-bordered" style="color: black; border: 2px solid black; width: 100%;">
										<thead>
											<tr style="background-color: #f0f0f0;">
												<th><?php echo e(trans('Name')); ?></th>
												<th><?php echo e(trans('Phone Number')); ?></th>
												<th><?php echo e(trans('Email')); ?></th>
												<th><?php echo e(trans('Driver Status')); ?></th>
												<th><?php echo e(trans('Request Status')); ?></th>
											</tr>
										</thead>
										<tbody>
											<?php $__empty_1 = true; $__currentLoopData = $assigned_driver; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
											<tr>
												<td><?php echo e($driver->driver_first_name); ?> <?php echo e($driver->driver_last_name); ?></td>
												<td><?php echo e($driver->driver_phone); ?></td>
												<td><?php echo e($driver->driver_email); ?></td>
												<td><?php echo e($driver->driver_status); ?></td>
												<td><?php echo e($driver->request_status); ?></td>
											</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
											<tr>
												<td colspan="5" style="text-align: center; color: gray;">
													<?php echo e(__('No assigned drivers found.')); ?>

												</td>
											</tr>
											<?php endif; ?>
										</tbody>
									</table>


								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="order_edit-genrl col-md-6">
							<div class="card">
								<div class="card-header bg-white">
									<h3><?php echo e(trans("lang.general_details")); ?></h3>
								</div>
								<div class="card-body">
									<div class="order_detail-top-box">
										<div class="form-group row widt-100 gendetail-col">
											<label class="col-12 control-label"><strong><?php echo e(trans('lang.ride_id')); ?>

													: </strong><span id="ride_id"><?php echo e($ride->id); ?></span></label>
										</div>


										<div class="form-group row widt-100 gendetail-col">
											<label class="col-12 control-label"><strong><?php echo e(trans('lang.date_created')); ?>

													: </strong><span id="createdAt"><?php echo e(date('d F Y h:i A',strtotime($ride->creer))); ?></span></label>
										</div>

										<div class="form-group row widt-100 gendetail-col payment_status">
											<label class="col-12 control-label"><strong><?php echo e(trans('lang.payment_status')); ?>

													: </strong>
												<span id="payment_status">

													<?php if($ride->statut_paiement=="yes"): ?>
													<span class="badge badge-success py-2 px-3">Paid</span>
													<?php else: ?>
													<span class="badge badge-warning py-2 px-3">Not paid</span>
													<?php endif; ?>

												</span>
											</label>
										</div>

										<div class="form-group row widt-100 gendetail-col payment_method">
											<label class="col-12 control-label"><strong><?php echo e(trans('lang.payment_methods')); ?>

													: </strong>
												<span id="payment_method">

													<?php if($ride->image): ?>
													<img class="rounded" style="width:70px" src="<?php echo e(asset('/assets/images/payment_method/'.$ride->image)); ?>" alt="image">
													<?php endif; ?>
												</span>
											</label>

										</div>

										<div class="form-group row widt-100 gendetail-col payment_status">
											<label class="col-12 control-label"><strong><?php echo e(trans('lang.ride_distance')); ?>

													: </strong><span id="trip_objective"><?php echo e($ride->distance." ".$ride->distance_unit); ?></span></label>
											</span>
											</label>
										</div>

										
									<div class="form-group row widt-100 gendetail-col payment_status">
										<label class="col-12 control-label"><strong><?php echo e(trans('lang.how_many_passanger')); ?>

												: </strong><span id="no_passanger"><?php echo e($ride->number_poeple); ?></span></label>
										</span>
										</label>


									</div>
									<div class="form-group row widt-100 gendetail-col payment_status">
										<label class="col-12 control-label"><strong><?php echo e(trans('lang.any_childern')); ?>

												: </strong><span id="any_childern">
												<?php if(!empty($ride->age_children1) || !empty($ride->age_children2) || !empty($ride->age_children3)): ?>
												<?php echo e("Yes"); ?>

												<?php else: ?><?php echo e("No"); ?>

												<?php endif; ?></span></label>
									</div>
									<?php if(!empty($ride->age_children1) || !empty($ride->age_children2) || !empty($ride->age_children3)): ?>
									<div class="form-group row widt-100 gendetail-col payment_status">
										<label class="col-12 control-label"><strong><?php echo e(trans('lang.age_of_childern')); ?>

												: </strong><span id="age_children"><?php echo e($ride->age_children1); ?>

												<?php echo e(!empty($ride->age_children2)? ','.$ride->age_children2 : ""); ?> <?php echo e(!empty($ride->age_children3) ? ",".$ride->age_children3 :""); ?></span></label>
										</span>
										</label>


									</div>
									<?php endif; ?>
									<div class="form-group row widt-100 gendetail-col payment_status">
										<label class="col-12 control-label"><strong><?php echo e(trans('lang.booked_by')); ?>

												: </strong>
											<?php if($ride->ride_type=="driver"): ?>
											<span id="age_children">Driver</span>
											<?php elseif($ride->ride_type=="dispatcher"): ?>
											<span id="age_children">dispatcher User
												<?php else: ?>
												<span id="age_children">Customer</span><?php endif; ?>


											</span>
										</label>

									</div>

									<div class="form-group row widt-100 gendetail-col payment_status">
										<label class="col-12 control-label"><strong><?php echo e(trans('lang.otp')); ?>

												: </strong>
											<span id="age_children"><?php echo e($ride->otp ?? '-'); ?></span>

										</label>
									</div>


									<div class="form-group row width-100 ">
										<label class="col-3 control-label"><?php echo e(trans('lang.ride_status')); ?>

											:</label>
										<div class="col-7">

											<?php
											$status = ['new' => 'new', 'confirmed' => 'confirmed', 'on ride'
											=> 'on ride', 'completed' => 'completed', 'canceled' => 'canceled', 'rejected' => 'rejected']

											?>

											<select name="order_status" class="form-control">
												<?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($key); ?>" <?php echo e(( $key == $ride->statut) ? 'selected' : ''); ?>> <?php echo e($value); ?> </option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

											</select>

										</div>
									</div>

								</div>

							</div>
						</div>
					</div>

					<div class="order_edit-genrl col-md-6">
						<div class="card">
							<div class="card-header bg-white">
								<h3><?php echo e(trans('lang.billing_details')); ?></h3>
							</div>
							<div class="card-body">
								<div class="address order_detail-top-box user-details">
									<?php $userInfo=json_decode($ride->user_info,true) ?>

									<p>
										<strong><?php echo e(trans("lang.name")); ?>: </strong>
										<span class="billing_name d-flex">
											<?php if(file_exists(public_path('assets/images/users'.'/'.$ride->photo_path)) && !empty($ride->photo_path)): ?>
											<span class="user-img"><img class="rounded" style="width:50px" src="<?php echo e(asset('assets/images/users/'.$ride->photo_path)); ?>" alt="Image"></span>

											<span class="drove-det ml-2"><span class="drv-name">
													<?php if($ride->ride_type=="driver"): ?><?php echo e(!empty($userInfo) ? $userInfo['name'] : " "); ?><?php else: ?><?php echo e($ride->userPrenom); ?> <?php echo e($ride->userNom); ?><?php endif; ?> </span>

												<br><span class="badge badge-warning text-white ml-auto"><i class="fa fa-star"></i><?php echo e($userRating); ?></span>

											</span>


											<?php else: ?>
											<span class="user-img"><img class="rounded" style="width:50px" src="<?php echo e(asset('assets/images/placeholder_image.jpg')); ?>" alt="Image"></span>
											<span class="drove-det ml-2"><span class="drv-name">
													<?php if($ride->ride_type=="driver"): ?><?php echo e(!empty($userInfo) ? $userInfo['name'] : ''); ?><?php else: ?><?php echo e($ride->userPrenom); ?> <?php echo e($ride->userNom); ?><?php endif; ?> </span>
												<br><span class="badge badge-warning text-white ml-auto"><i class="fa fa-star"></i><?php echo e($userRating); ?></span>

												<?php endif; ?>

											</span>

									</p>

									<p><strong><?php echo e(trans("lang.email")); ?>:</strong>
										<span id="billing_email"><?php if($ride->ride_type=="driver"): ?><?php echo e(!empty($userInfo) ? $userInfo['email'] : ''); ?><?php else: ?><?php echo e($ride->user_email); ?><?php endif; ?></span>
									</p>
									<p><strong><?php echo e(trans("lang.phone")); ?>:</strong>
										<span id="billing_phone"><?php if($ride->ride_type=="driver"): ?><?php echo e(!empty($userInfo) ? $userInfo['phone'] : ''); ?><?php else: ?><?php echo e($ride->user_phone); ?><?php endif; ?></span>
									</p>
								</div>
							</div>
						</div>
						<div class="card non-printable">
							<div class="card-body">
								<div class="row">

									<div class="col-12">

										<div class="box">
											<div class="box-header bb-2 border-primary">
												<h3 class="box-title"><?php echo e(trans('lang.map_view')); ?></h3>
											</div>
											<div class="box-body">
												<div id="map" style="height:300px">
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>


			<div class="order-deta-btm mt-4">
				<div class="row">
					<div class="col-md-7 order-deta-btm-left">
						<div class="card">
							<div class="box card-body p-0">
								<div class="box-header bb-2 card-header bg-white">
									<h3 class="box-title"><?php echo e(trans("lang.location_details")); ?></h3>
								</div>
								<div class="card-body">
									<div class="live-tracking-list">
										<div class="live-tracking-box track-from">


											<div class="live-tracking-inner">
												<div class="location-ride">

													<div class="from-ride"><?php echo e($ride->depart_name); ?></div>

													<div class="to-ride"><?php echo e($ride->destination_name); ?></div>

												</div>
											</div>

										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="card">
							<div class="order_addre-edit ">
								<div class="card-header bg-white">
									<h3>Advance Payment Details</h3>
								</div>
								<div class="card-body price_detail">
									<div class="order-deta-btm-right">
										<div class="order-totals-items pt-0">
											<div class="row">
												<div class="col-md-12 ml-auto">
													<div class="table-responsive bk-summary-table">
														<table class="order-totals">

															<tbody id="order_products_total">
																<?php if(!empty($ride->razorpay_transaction_id)): ?>
																<tr class="transaction_id_48fc3f15-66f1-45a7-b4b8-123563426fe4">
																	<td class="label">
																		<strong><?php echo e(trans("lang.transaction_id")); ?></strong>
																	</td>
																	<td>
																		<strong><?php echo e($ride->razorpay_transaction_id); ?></strong>
																	</td>
																</tr>
																<?php endif; ?>

																<tr class="final-rate">
																	<td class="label">Paid amount</td>
																	<td>
																		<?php if($currency->symbol_at_right=="true"): ?>
																		<?php echo e(number_format(floatval($ride->advance_payment),$currency->decimal_digit)."".$currency->symbole); ?>

																		<?php else: ?>
																		<?php echo e($currency->symbole."".number_format(floatval($ride->advance_payment),$currency->decimal_digit)); ?>

																		<?php endif; ?>
																	</td>
																</tr>
																</tr>


															</tbody>
														</table>
													</div>
												</div>
											</div>
										</div>
									</div>


								</div>
							</div>
						</div>
						<div class="card">
							<div class="order_addre-edit ">
								<div class="card-header bg-white">
									<h3><?php echo e(trans("lang.price_details")); ?></h3>
								</div>
								<div class="card-body price_detail">
									<div class="order-deta-btm-right">
										<div class="order-totals-items pt-0">
											<div class="row">
												<div class="col-md-12 ml-auto">
													<div class="table-responsive bk-summary-table">
														<table class="order-totals">

															<tbody id="order_products_total">
																<?php if(!empty($ride->transaction_id)): ?>
																<tr class="transaction_id_48fc3f15-66f1-45a7-b4b8-123563426fe4">
																	<td class="label">
																		<strong><?php echo e(trans("lang.transaction_id")); ?></strong>
																	</td>
																	<td>
																		<strong><?php echo e($ride->transaction_id); ?></strong>
																	</td>
																</tr>
																<?php endif; ?>
																<tr>
																	<td class="seprater" colspan="2">
																		<hr>
																		<span><?php echo e(trans("lang.sub_total")); ?></span>
																	</td>
																</tr>

																<tr class="final-rate">
																	<td class="label"><?php echo e(trans("lang.sub_total")); ?></td>
																	<td>
																		<?php if($currency->symbol_at_right=="true"): ?>
																		<?php echo e(number_format(floatval($ride->montant),$currency->decimal_digit)."".$currency->symbole); ?>

																		<?php else: ?>
																		<?php echo e($currency->symbole."".number_format(floatval($ride->montant),$currency->decimal_digit)); ?>

																		<?php endif; ?>
																	</td>
																</tr>
																<?php if($ride->discount > 0): ?>
																<tr>
																	<td class="seprater" colspan="2">
																		<hr>
																		<span><?php echo e(trans("lang.discount")); ?></span>
																	</td>
																</tr>

																<tr>
																	<td class="label"><?php echo e(trans("lang.discount")); ?></td>
																	<td>
																		<span style="color:red">
																			<?php if($currency->symbol_at_right=="true"): ?>
																			(- <?php echo e(number_format(floatval($ride->discount),$currency->decimal_digit)."".$currency->symbole); ?>)
																			<?php else: ?>
																			(-<?php echo e($currency->symbole."".number_format(floatval($ride->discount),$currency->decimal_digit)); ?>)
																			<?php endif; ?>
																		</span>
																	</td>
																</tr>
																<?php endif; ?>
																<?php if(!empty($taxHtml)): ?>
																<tr>
																	<td class="seprater" colspan="2">
																		<hr>
																		<span><?php echo e(trans("lang.tax_calculation")); ?></span>
																	</td>
																</tr>

																<?php echo $taxHtml; ?>

																<?php endif; ?>
																<?php if($ride->tip_amount > 0): ?>
																<tr>
																	<td class="seprater" colspan="2">
																		<hr>
																		<span><?php echo e(trans("lang.tip")); ?></span>
																	</td>
																</tr>

																<tr>
																	<td class="label"><?php echo e(trans("lang.tip_amount")); ?></td>
																	<td>
																		<?php if($currency->symbol_at_right=="true"): ?>
																		<?php echo e(number_format(floatval($ride->tip_amount),$currency->decimal_digit)."".$currency->symbole); ?>

																		<?php else: ?>
																		<?php echo e($currency->symbole."".number_format(floatval($ride->tip_amount),$currency->decimal_digit)); ?>

																		<?php endif; ?>
																	</td>
																</tr>
																<?php endif; ?>
																<tr>
																	<td class="seprater" colspan="2">
																		<hr>
																	</td>
																</tr>

																<tr class="grand-total">
																	<td class="label"><?php echo e(trans("lang.total_amount")); ?></td>
																	<td class="total_price_val">
																		<?php if($currency->symbol_at_right=="true"): ?>
																		<?php echo e(number_format(floatval($totalAmount),$currency->decimal_digit)."".$currency->symbole); ?>

																		<?php else: ?>
																		<?php echo e($currency->symbole."".number_format(floatval($totalAmount),$currency->decimal_digit)); ?>

																		<?php endif; ?>
																	</td>
																</tr>
																<?php if($ride->admin_commission != ''): ?>
																<tr>
																	<td class="label">
																		<small> <?php echo e(trans("lang.admin_commission")); ?> </small>
																	</td>
																	<td class="adminCommission_val">
																		<small>
																			<span style="color:red">
																				<?php if($currency->symbol_at_right=="true"): ?>
																				(<?php echo e(number_format(floatval($ride->admin_commission),$currency->decimal_digit)."".$currency->symbole); ?>)

																				<?php else: ?>
																				( <?php echo e($currency->symbole."".number_format(floatval($ride->admin_commission),$currency->decimal_digit)); ?>)

																				<?php endif; ?>
																			</span>
																		</small>
																	</td>
																</tr>
																<?php endif; ?>

															</tbody>
														</table>
													</div>
												</div>
											</div>
										</div>
									</div>


								</div>
							</div>
						</div>
					</div>

					<div class="col-md-5 order-deta-btm-right">
						<div class="resturant-detail">
							<div class="card">
								<div class="card-header bg-white">
									<h3 class="box-title"><?php echo e(trans('lang.driver_detail')); ?></h3>
								</div>

								<div class="card-body">
									<a href="#" class="row redirecttopage" id="resturant-view">
										<div class="col-4">
											<?php if(file_exists(public_path('assets/images/drivers'.'/'.$ride->driver_photo)) && !empty($ride->driver_photo)): ?>
											<span id="billing_name" class="d-flex"><span class="user-img"><img class="rounded" style="width:50px" src="<?php echo e(asset('assets/images/drivers/'.$ride->driver_photo)); ?>" alt="Image"></span>
												<?php else: ?>
												<span id="billing_name" class="d-flex"><span class="user-img"><img class="rounded" style="width:50px" src="<?php echo e(asset('assets/images/placeholder_image.jpg')); ?>" alt="Image"></span>
													<?php endif; ?>
										</div>
										<div class="col-8">
											<h4 class="vendor-title"><?php echo e($ride->driverPrenom); ?> <?php echo e($ride->driverNom); ?></h4>
											<span class="badge badge-warning text-white ml-auto"><i class="fa fa-star"></i><?php echo e($driverRating); ?></span>
										</div>
									</a>

									<h5 class="contact-info"><?php echo e(trans('lang.contact_info')); ?>

										:</h5>
									<p><strong><?php echo e(trans('lang.email')); ?>:</strong>
										<span id="vendor_email"><?php echo e($ride->driver_email); ?></span>
									</p>
									<p><strong><?php echo e(trans('lang.phone')); ?>:</strong>
										<span id="vendor_phone"><?php echo e($ride->driver_phone); ?></span>
									</p>

									<h5 class="contact-info"><?php echo e(trans('lang.car_info')); ?>

										:</h5>

									<p>
										<strong style="width:auto !important;"><?php echo e(trans('lang.brand')); ?>

											:</strong>
										<span id="driver_carName"><?php echo e($ride->brand); ?></span>
									</p>
									<p>
										<strong style="width:auto !important;"><?php echo e(trans('lang.car_number')); ?>

											:</strong>
										<span id="driver_carNumber"><?php echo e($ride->numberplate); ?></span>
									</p>
									<p>
										<strong style="width:auto !important;"><?php echo e(trans('lang.car_model')); ?>

											:</strong>
										<span id="driver_carNumber"><?php echo e($ride->model); ?></span>
									</p>

									<p>
										<strong style="width:auto !important;"><?php echo e(trans('lang.car_make')); ?>

											:</strong>
										<span id="driver_car_make"><?php echo e($ride->car_make); ?></span>
									</p>

									<p>
										<strong style="width:auto !important;"><?php echo e(trans('lang.zone')); ?>

											:</strong>
										<span id="driver_car_make"><?php echo e($ride->zone_name); ?></span>
									</p>
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>

	</div>
	<div class="row">
		<div class="col-md-6">
			<div class="card">
				<div class="card-header bg-white">
					<h3 class="box-title"><?php echo e(trans('lang.ride_customer_review')); ?></h3>
				</div>
				<div class="card-body">
					<p> <?php if($customer_review->isEmpty()): ?>
						<?php echo e(trans("lang.no_review_found")); ?>

						<?php else: ?>
						<?php $__currentLoopData = $customer_review; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<div class="d-inline-block d-flex">
						<?php echo e($review->comment); ?>

						<div class="ml-auto">
							<ul class="rating" data-rating="<?php echo e($review->niveau); ?>">
								<li class="rating__item"></li>
								<li class="rating__item"></li>
								<li class="rating__item"></li>
								<li class="rating__item"></li>
								<li class="rating__item"></li>
							</ul>

						</div>
					</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>
					</p>
				</div>
			</div>
		</div>
		<div class="col-md-6">
			<div class="card">
				<div class="card-header bg-white">
					<h3 class="box-title"><?php echo e(trans('lang.ride_driver_review')); ?></h3>
				</div>
				<div class="card-body">
					<p class="text-center"><?php if($driver_review->isEmpty()): ?>
						<?php echo e(trans('lang.no_review_found')); ?>

						<?php else: ?>
						<?php $__currentLoopData = $driver_review; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<div class="d-inline-block d-flex">
						<?php echo e($review->comment); ?>

						<div class="ml-auto">
							<ul class="rating" data-rating="<?php echo e($review->niveau_driver); ?>">
								<li class="rating__item"></li>
								<li class="rating__item"></li>
								<li class="rating__item"></li>
								<li class="rating__item"></li>
								<li class="rating__item"></li>
							</ul>

						</div>
					</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>
					</p>
				</div>
			</div>
		</div>


	</div>
	<div class="row">
		<div class="col-md-12">
			<div class="card">
				<div class="order_addre-edit ">
					<div class="card-header bg-white">
						<h3 class="box-title"><?php echo e(trans('lang.complaints')); ?></h3>
					</div>
					<div class="card-body price_detail">
						<div class="order-deta-btm-right">
							<div class="order-totals-items pt-0">
								<div class="row">
									<div class="col-md-12 ml-auto">
										<div class="table-responsive bk-summary-table">
											<table class="order-totals complaint-table">

												<tbody id="order_products_total">

													<?php if($complaints->count() == 0): ?>

													<p class=" text-center"><?php echo e(trans("lang.no_complaint_found")); ?></p>


													<?php else: ?>

													<?php $__currentLoopData = $complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<td class="seprater" colspan="2">
															<hr>
															<span><?php echo e(trans("lang.by")); ?> <?php echo e($complaint->user_type); ?></span>
														</td>
													</tr>

													<tr>
														<td class="label"><?php echo e(trans("lang.title")); ?></td>
														<td>
															<?php echo e($complaint->title); ?>

														</td>
													</tr>
													<tr>
														<td class="label"><?php echo e(trans("lang.message")); ?></td>
														<td>
															<?php echo e($complaint->description); ?>

														</td>
													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

													<?php endif; ?>


												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>


						</div>


						<!--  </div> -->
					</div>
				</div>
			</div>
		</div>



		<div class="form-group col-12 text-center btm-btn non-printable">
			<button type="submit" class="btn btn-primary save_order_btn"><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
			<a href="javascript:history.go(-1)" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>

		</div>

		</form>
	</div>
</div>
</div>
</div>
</div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
	var map;
	var marker;


	var myLatlng = new google.maps.LatLng('<?php echo $ride -> latitude_arrivee; ?>', '<?php echo $ride -> longitude_arrivee; ?>');
	var geocoder = new google.maps.Geocoder();
	var infowindow = new google.maps.InfoWindow();

	var mapOptions = {
		zoom: 10,
		center: myLatlng,
		streetViewControl: false,
		mapTypeId: google.maps.MapTypeId.ROADMAP
	};

	map = new google.maps.Map(document.getElementById("map"), mapOptions);

	marker = new google.maps.Marker({
		map: map,
		position: myLatlng,
		draggable: true
	});

	google.maps.event.addListener(marker, 'click', function() {
		infowindow.setContent('<?php echo $ride->destination_name; ?>');
		infowindow.open(map, marker);
	});

	//Set direction route
	let directionsService = new google.maps.DirectionsService();
	let directionsRenderer = new google.maps.DirectionsRenderer();

	directionsRenderer.setMap(map);

	const origin = {
		lat: {
			!!$ride - > latitude_depart!!
		},
		lng: {
			!!$ride - > longitude_depart!!
		}
	};
	const destination = {
		lat: {
			!!$ride - > latitude_arrivee!!
		},
		lng: {
			!!$ride - > longitude_arrivee!!
		}
	};

	const route = {
		origin: origin,
		destination: destination,
		travelMode: 'DRIVING'
	}

	directionsService.route(route, function(response, status) {
		if (status !== 'OK') {
			window.alert('Directions request failed due to ' + status);
			return;
		} else {
			directionsRenderer.setDirections(response);
			var directionsData = response.routes[0].legs[0];
		}
	});

	function printDiv(divName) {
		var css = '@page { size: portrait; }',
			head = document.head || document.getElementsByTagName('head')[0],
			style = document.createElement('style');
		style.type = 'text/css';
		style.media = 'print';

		if (style.styleSheet) {
			style.styleSheet.cssText = css;
		} else {
			style.appendChild(document.createTextNode(css));
		}

		head.appendChild(style);

		var printContents = document.getElementsByClassName(divName).html;
		window.print();

	}
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/rides/show.blade.php ENDPATH**/ ?>