<?php $__env->startSection('content'); ?>
<div class="page-wrapper">

    <div class="row page-titles">

        <div class="col-md-5 align-self-center">

            <h3 class="text-themecolor"><?php echo e(trans('lang.administration_tools_tax')); ?></h3>

        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.administration_tools')); ?></li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.administration_tools_tax')); ?></li>
            </ol>
        </div>

    </div>


    <div class="container-fluid">

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <div class="userlist-topsearch d-flex mb-3">
                            <div class="userlist-top-left">
                                <a class="nav-link do_not_create" href="<?php echo e(route('tax.create')); ?>"><i
                                        class="fa fa-plus mr-2"></i><?php echo e(trans('lang.tax_create')); ?></a>
                            </div>
                            <div id="users-table_filter" class="ml-auto">
                                <label><?php echo e(trans('lang.search_by')); ?>

                                    <div class="form-group mb-0">

                                        <form action="<?php echo e(route('tax')); ?>" method="get">
                                            <?php if(isset($_GET['selected_search']) && $_GET['selected_search'] != ''): ?>
                                            <select name="selected_search" id="selected_search"
                                                class="form-control input-sm">
                                                <option value="libelle" <?php if($_GET[ 'selected_search' ]=='libelle' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.label')); ?></option>
                                                <option value="country" <?php if($_GET[ 'selected_search' ]=='country' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.country')); ?>

                                                </option>
                                                 <option value="tax" <?php if($_GET[ 'selected_search' ]=='tax' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.tax_table')); ?>

                                                </option>
                                                <option value="type" <?php if($_GET[ 'selected_search' ]=='type' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.type')); ?>

                                                </option>


                                            </select>
                                            <?php else: ?>
                                            <select name="selected_search" id="selected_search"
                                                class="form-control input-sm">
                                                <option value="libelle"><?php echo e(trans('lang.label')); ?></option>
                                                <option value="symbole"><?php echo e(trans('lang.country')); ?></option>
                                            </select>
                                            <?php endif; ?>
                                            <div class="search-box position-relative">
                                                <?php if(isset($_GET['search']) && $_GET['search'] != ''): ?>
                                                <input type="text" class="search form-control" name="search" id="search"
                                                    value="<?php echo e($_GET['search']); ?>">
                                                <?php else: ?>
                                                <input type="text" class="search form-control" name="search"
                                                    id="search">
                                                <?php endif; ?>
                                                <button type="submit" class="btn-flat position-absolute"><i
                                                        class="fa fa-search"></i></button>
                                                <a class="btn btn-warning btn-flat"
                                                    href="<?php echo e(url('administration_tools/tax')); ?>">Clear</a>
                                            </div>
                                        </form>
                                    </div>
                                </label>
                            </div>
                        </div>

                        <div class="table-responsive m-t-10">

                            <div class="error_top"></div>
                            <?php if($errors->any()): ?>
                            <div class="alert alert-danger" style="display:none;">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                            <?php endif; ?>
                            <table id="example24"
                                class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                cellspacing="0" width="100%">

                                <thead>

                                    <tr>
                                        <th class="delete-all"><input type="checkbox" id="is_active"><label
                                                class="col-3 control-label" for="is_active"><a id="deleteAll"
                                                    class="do_not_delete" href="javascript:void(0)"><i
                                                        class="fa fa-trash"></i> All</a></label>
                                        </th>
                                        <th><?php echo e(trans('lang.label')); ?></th>
                                        <th><?php echo e(trans('lang.tax_table')); ?></th>
                                        <th><?php echo e(trans('lang.type')); ?></th>
                                        <th><?php echo e(trans('lang.status')); ?></th>
                                        <th><?php echo e(trans('lang.country')); ?></th>
                                        <th><?php echo e(trans('lang.actions')); ?></th>

                                    </tr>

                                </thead>

                                <tbody id="append_list1">
                                    <?php if(count($taxes) > 0): ?>
                                    <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="delete-all"><input type="checkbox" id="is_open_<?php echo e($tax->id); ?>"
                                                class="is_open" dataid="<?php echo e($tax->id); ?>"><label
                                                class="col-3 control-label" for="is_open_<?php echo e($tax->id); ?>"></label>
                                        </td>
                                        <td><?php echo e($tax->libelle); ?></td>
                                        <td><?php echo e($tax->value); ?></td>
                                        <td><?php echo e($tax->type); ?></td>

                                        <td><?php if($tax->statut=="yes"): ?> 
                                            <label class="switch"><input type="checkbox"
                                                    checked value="<?php echo e($tax->statut); ?>" id="<?php echo e($tax->id); ?>"
                                                    name="publish" class="switchToggal"><span class="slider round"></span></label>
                                            <?php else: ?> <label class="switch"><input type="checkbox" id="<?php echo e($tax->id); ?>"
                                                    name="publish" value="<?php echo e($tax->statut); ?>" class="switchToggal"><span
                                                    class="slider round"></span></label><span>
                                                <?php endif; ?>
                                            </td>
                                        <td><?php echo e($tax->country); ?></td>

                                        <td class="action-btn">
                                            <a href="<?php echo e(route('tax.edit', ['id' => $tax->id])); ?>"
                                                class="do_not_edit"><i class="fa fa-edit"></i></a>
                                            <a href="<?php echo e(route('tax.delete', ['id' => $tax->id])); ?>"
                                                class="do_not_delete"><i class="fa fa-trash"></i></a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <tr>
                                        <td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td>
                                    </tr>
                                    <?php endif; ?>

                                </tbody>

                            </table>

                            <nav aria-label="Page navigation example" class="custom-pagination">
                                <?php echo e($taxes->appends(request()->query())->links()); ?>

                            </nav>
                            <?php echo e($taxes->Links('pagination.pagination')); ?>

                        </div>


                    </div>

                </div>

            </div>

        </div>


    </div>

</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">

    $(document).ready(function () {
        $(".shadow-sm").hide();
    })

    /* toggal publish action code start*/
    $(document).on("click", "input[name='publish']", function (e) {
        
        var ischeck = $(this).is(':checked');
        var id = this.id;
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '../tax/switch',
            method: "POST",
            data: { 'ischeck': ischeck, 'id': id },
            success: function (data) {

            },
        });

    });

    /*toggal publish action code end*/

        $("#is_active").click(function () {
        $("#example24 .is_open").prop('checked', $(this).prop('checked'));

    });

    $("#deleteAll").click(function () {
        if ($('#example24 .is_open:checked').length) {
                if (confirm('Are You Sure want to Delete Selected Data ?')) {
                    var arrayUsers = [];
                    $('#example24 .is_open:checked').each(function () {
                        var dataId = $(this).attr('dataId');
                        arrayUsers.push(dataId);

                    });

                    arrayUsers = JSON.stringify(arrayUsers);
                    var url = "<?php echo e(url('administration_tools/tax/delete', 'id')); ?>";
                    url = url.replace('id', arrayUsers);

                    $(this).attr('href', url);
                }
            } else {
                alert('Please Select Any One Record .');
            }
        });


</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/administration_tools/tax/index.blade.php ENDPATH**/ ?>