<?php $__env->startSection('content'); ?>
<div class="page-wrapper">

    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.admin_user')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item active">Admin Users</li>
            </ol>
        </div>
        <div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">

                    <div class="card-body">
                        <div id="data-table_processing" class="dataTables_processing panel panel-default"
                            style="display: none;"><?php echo e(trans('lang.processing')); ?>

                        </div>
                        <div class="userlist-topsearch d-flex mb-3">
                            <div class="userlist-top-left">
                                <a class="nav-link" href="<?php echo route('admin-users.create'); ?>"><i
                                        class="fa fa-plus mr-2"></i><?php echo e(trans('lang.user_create')); ?></a>
                            </div>
                            <div id="users-table_filter" class="ml-auto">
                                <label><?php echo e(trans('lang.search_by')); ?>

                                    <div class="form-group mb-0">
                                        <form action="<?php echo e(route('admin-users')); ?>" method="get">

                                            <?php if(isset($_GET['selected_search']) && $_GET['selected_search'] != ''): ?>
                                            <?php //dd($_GET['selected_search']);
                                            ?>
                                            <select name="selected_search" id="selected_search"
                                                class="form-control input-sm">
                                                <option value="name" <?php if($_GET['selected_search']=='name' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.user_name')); ?></option>

                                                <option value="email" <?php if($_GET['selected_search']=='email' ): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.email')); ?></option>
                                            
                                            </select>
                                            <?php else: ?>
                                            <select name="selected_search" id="selected_search"
                                                class="form-control input-sm">
                                                <option value="name"><?php echo e(trans('lang.user_name')); ?></option>
                                                <option value="email"><?php echo e(trans('lang.email')); ?></option>                                                
                                            </select>
                                            <?php endif; ?>
                                            <div class="search-box position-relative">
                                                <?php if(isset($_GET['search']) && $_GET['search'] != ''): ?>
                                                <input type="text" class="search form-control" name="search"
                                                    id="search" value="<?php echo e($_GET['search']); ?>">
                                                <?php else: ?>
                                                <input type="text" class="search form-control" name="search"
                                                    id="search">
                                                <?php endif; ?>
                                                <button type="submit" class="btn-flat position-absolute"><i
                                                        class="fa fa-search"></i></button>
                                                <!-- <input type="search" id="search" class="search form-control" placeholder="Search" aria-controls="users-table"></label>&nbsp;<button onclick="searchtext();" class="btn btn-warning btn-flat">Search</button>&nbsp; -->
                                                <!-- <button onclick="searchclear();" class="btn btn-warning btn-flat">Clear</button> -->
                                                <a class="btn btn-warning btn-flat" href="<?php echo e(url('admin-users')); ?>">Clear</a>
                                            </div>
                                        </form>
                                    </div>
                                </label>
                            </div>
                        </div>
                        <div class="table-responsive m-t-10">
                            <table id="example24"
                                class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                cellspacing="0" width="100%">
                                <thead>
                                    <tr>

                                        <th><?php echo e(trans('lang.user_name')); ?></th>
                                        <th><?php echo e(trans('lang.email')); ?></th>
                                        <th><?php echo e(trans('lang.actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody id="append_list12">
                                    <?php if(count($users) > 0): ?>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>


                                        <td> <?php echo e($customer->name); ?>

                                        </td>
                                        <td><?php echo e($customer->email); ?></td>
                                        <td class="action-btn">

                                            <a
                                                href="<?php echo e(route('admin-users.edit', ['id' => $customer->id])); ?>"><i
                                                    class="fa fa-edit"></i>
                                            </a>
                                            <a id="'+val.id+'"
                                                class="do_not_delete"
                                                name="admin-user-delete"
                                                href="<?php echo e(route('admin-users.delete', ['id' => $customer->id])); ?>"><i
                                                    class="fa fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <tr>
                                        <td colspan="3" align="center"><?php echo e(trans("lang.no_result")); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>


                            <!-- <?php echo e($users->onEachSide(5)->links()); ?> -->
                            <nav aria-label="Page navigation example" class="custom-pagination">
                                <?php echo e($users->appends(request()->query())->links()); ?>

                            </nav>
                            <?php echo e($users->links('pagination.pagination')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
    $(document).ready(function() {
        $(".shadow-sm").hide();
    })

   

    /* toggal publish action code start*/
    $(document).on("click", "input[name='publish']", function(e) {
        var ischeck = $(this).is(':checked');
        var id = this.id;
        console.log(id);
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '/switch',
            method: "POST",
            data: {
                'ischeck': ischeck,
                'id': id
            },
            success: function(data) {

            },
        });

    });

    /*toggal publish action code end*/
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/settings/admin-users/index.blade.php ENDPATH**/ ?>