<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <div class="row page-titles">
    <div class="col-md-5 align-self-center">
      <h3 class="text-themecolor"><?php echo e(trans('lang.coupon_plural')); ?></h3>
    </div>

    <div class="col-md-7 align-self-center">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>

        <li class="breadcrumb-item"><a href="<?php echo route('coupons'); ?>"><?php echo e(trans('lang.coupon_plural')); ?></a></li>

        <li class="breadcrumb-item active"><?php echo e(trans('lang.coupon_create')); ?></li>
      </ol>
    </div>
  </div>

  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="card pb-4">

          <div class="card-body">

            <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;"><?php echo e(trans('lang.processing')); ?></div>
            <div class="error_top" style="display:none"></div>
            <?php if($errors->any()): ?>
            <div class="alert alert-danger">
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="error"><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>
            <form method="post" action="<?php echo e(route('coupons.store')); ?>" enctype="multipart/form-data">
              <?php echo csrf_field(); ?>

              <div class="row restaurant_payout_create">

                <div class="restaurant_payout_create-inner">

                  <!-- <div class="col-md-6"> -->
                  <fieldset>
                    <legend><?php echo e(trans('lang.coupon_create')); ?></legend>

                    <div class="form-group row width-50">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_code')); ?></label>
                      <div class="col-7">
                        <input type="text" type="text" class="form-control coupon_code" name="code" value="<?php echo e(Request::old('code')); ?>">
                        <div class="form-text text-muted"><?php echo e(trans("lang.coupon_code_help")); ?> </div>
                      </div>
                    </div>

                     <!-- 1. Status Dropdown -->
                    <div class="form-group row width-50">
                      <label class="col-3 control-label">Apply For</label>
                      <div class="col-7">
                        <select class="form-control" name="apply_for">
                          <option value="normal" <?php echo e(Request::old('apply_for') == 'normal' ? 'selected' : ''); ?>>Normal</option>
                          <option value="completed" <?php echo e(Request::old('apply_for') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                        </select>
                        <div class="form-text text-muted">Select the type of the coupon.</div>
                      </div>
                    </div>

                    <div class="form-group row width-50" >
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_discount_type')); ?></label>
                      <div class="col-7">
                        <select id="coupon_discount_type" class="form-control" name="type">
                          <?php if(Request::old('type') == 'Percentage'): ?>
                          <option value="Percentage" selected><?php echo e(trans('lang.coupon_percent')); ?></option>
                          <?php else: ?>
                          <option value="Percentage"><?php echo e(trans('lang.coupon_percent')); ?></option>
                          <?php endif; ?>
                          <?php if(Request::old('type') == 'Fix Price'): ?>
                          <option value="Fix Price" selected><?php echo e(trans('lang.coupon_fixed')); ?></option>
                          <?php else: ?>
                          <option value="Fix Price"><?php echo e(trans('lang.coupon_fixed')); ?></option>
                          <?php endif; ?>
                        </select>
                        <div class="form-text text-muted"><?php echo e(trans("lang.coupon_discount_type_help")); ?></div>

                      </div>
                    </div>

                    <div class="form-group row width-50" style="display: none;"  id="discount" >
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_discount')); ?></label>
                      <div class="col-7">
                        <input type="number" type="text" class="form-control coupon_discount" name="discount" value="<?php echo e(Request::old('discount')); ?>">
                        <div class="form-text text-muted"><?php echo e(trans("lang.coupon_discount_help")); ?></div>
                      </div>
                    </div>

                    <div class="form-group row width-100" style="display: none;" id="discount_slab">
                      <label class="col-3 control-label">Discount Slabs</label>
                      <div class="col-7">

                        <table class="table table-bordered" id="slab_table">
                          <thead>
                            <tr>
                              <th>Minimum Ride Amount</th>
                              <th>Discount</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            <tr>
                              <td><input type="number" name="slabs[0][min]" class="form-control"></td>
                              <td><input type="number" name="slabs[0][discount]" class="form-control"></td>
                              <td></td>
                            </tr>
                          </tbody>
                        </table>

                        <button type="button" class="btn btn-sm btn-secondary" id="add_slab">+ Add slab</button>
                      </div>
                    </div>


                    <div class="form-group row width-50">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_expires_at')); ?></label>
                      <div class="col-7">
                        <!-- <div class="form-group"> -->
                        <div class='input-group date' id='datetimepicker1'>
                          <input type='date' class="form-control date_picker input-group-addon" name="expire_at"  min="<?php echo e(now()->format('Y-m-d')); ?>" value="<?php echo e(Request::old('expire_at')); ?>" />
                          <span class="">
                            <!-- <span class="glyphicon glyphicon-calendar fa fa-calendar"></span> -->
                          </span>
                        </div>
                        <div class="form-text text-muted">
                          <?php echo e(trans("lang.coupon_expires_at_help")); ?>

                        </div>
                        <!-- </div> -->
                      </div>
                    </div>


                    <div class="form-group row width-50">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_type')); ?></label>
                      <div class="col-7">
                        <select id="coupon_type" class="form-control" name="coupon_type">
                          <?php if(Request::old('coupon_type') == 'ride'): ?>
                          <option value="Ride" selected><?php echo e(trans('lang.ride')); ?></option>
                          <?php else: ?>
                          <option value="Ride"><?php echo e(trans('lang.ride')); ?></option>
                          <?php endif; ?>
                          <?php if(Request::old('coupon_type') == 'parcel'): ?>
                          <option value="Parcel" selected><?php echo e(trans('lang.parcel')); ?></option>
                          <?php else: ?>
                          <option value="Parcel"><?php echo e(trans('lang.parcel')); ?></option>
                          <?php endif; ?>
                        </select>
                        <div class="form-text text-muted">
                          <?php echo e(trans("lang.coupon_type_help")); ?>

                        </div>
                      </div>
                    </div>

                    <div class="form-group row width-50" style="display: none;" id="minimun_amount">
                      <label class="col-3 control-label"><?php echo e(trans('Minimun amount')); ?></label>
                      <div class="col-7">
                        <input type="number" type="text" class="form-control minimun_amount" name="minimun_amount" value="<?php echo e(Request::old('minimun_amount')); ?>">
                        <div class="form-text text-muted"><?php echo e(trans("insert minimun amount")); ?></div>
                      </div>
                    </div>

                    <div class="form-group row width-50" id="number_of_time" style="display: none;">
                      <label class="col-3 control-label"><?php echo e(trans('Number of times allowed')); ?></label>
                      <div class="col-7">
                        <input type="number" type="text" class="form-control number_time_allowed" name="number_time_allowed" value="<?php echo e(Request::old('number_time_allowed')); ?>">
                        <div class="form-text text-muted"><?php echo e(trans("insert number of times for use")); ?></div>
                      </div>
                    </div>

                    <!-- 2. Rating (1 to 5) -->
                    <div class="form-group row width-50" id="rating_div" style="display: none;">
                      <label class="col-3 control-label">Rating</label>
                      <div class="col-7">
                        <select class="form-control" name="rating" id="rating_select">
                          <option value="">Select Rating</option>
                          <?php for($i = 1; $i <= 5; $i++): ?>
                            <option value="<?php echo e($i); ?>" <?php echo e(Request::old('rating') == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                            <?php endfor; ?>
                        </select>
                        <div class="form-text text-muted">Select a rating from 1 to 5.</div>
                      </div>
                    </div>


                    <div class="form-group row width-50">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_title')); ?></label>
                      <div class="col-7">
                        <input type="text" type="text" class="form-control" name="title" value="<?php echo e(Request::old('title')); ?>">
                        <div class="form-text text-muted"><?php echo e(trans("lang.coupon_title_help")); ?> </div>
                      </div>
                    </div>

                    <div class="form-group row width-100">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_description')); ?></label>
                      <div class="col-7">
                        <textarea rows="12" class="form-control coupon_description" id="coupon_description" name="discription" value="<?php echo e(Request::old('description')); ?>"><?php echo e(Request::old('description')); ?></textarea>
                        <div class="form-text text-muted"><?php echo e(trans("lang.coupon_description_help")); ?></div>
                      </div>
                    </div>

                    <!-- <div class="form-group row width-100">
              <label class="col-3 control-label"><?php echo e(trans('lang.category_image')); ?></label>
                <div class="col-7">
                  <input type="file" onChange="handleFileSelect(event)">
                  <div class="placeholder_img_thumb coupon_image"></div>
                  <div id="uploding_image"></div>
                </div>
              </div> -->

                    <div class="form-group row width-100">
                      <div class="form-check">
                        <input type="checkbox" class="coupon_enabled" id="coupon_enabled" name="statut">
                        <label class="col-3 control-label" for="coupon_enabled"><?php echo e(trans('lang.coupon_enabled')); ?></label>

                      </div>
                    </div>

                    <!-- Add inside your <fieldset> along with other form groups -->





                    <!-- </div>

          <div class="col-md-6"> -->

                    <!-- <div class="form-group row">
                    <label class="col-3 control-label"><?php echo e(trans('lang.coupon_food_id')); ?></label>
                    <div class="col-7">
                    <select id="coupon_food" class=" select2 form-control" multiple>
                      <option value=""><?php echo e(trans('lang.select_food')); ?></option>
                    </select>
                    <div class="form-text text-muted">
                      <?php echo e(trans("lang.coupon_food_id_help")); ?>

                    </div>  
                  </div>
                </div>
                <div class="form-group row">
                    <label class="col-3 control-label"><?php echo e(trans('lang.coupon_restaurant_id')); ?></label>
                    <div class="col-7">
                    <select id="coupon_restaurant" class=" select2 form-control" multiple>
                      <option vale="percent"><?php echo e(trans('lang.select_restaurant')); ?></option>
                    </select>
                    <div class="form-text text-muted">
                      <?php echo e(trans("lang.coupon_restaurant_id_help")); ?>

                    </div> 
                  </div>
                </div>
                <div class="form-group row">
                    <label class="col-3 control-label"><?php echo e(trans('lang.coupon_category_id')); ?></label>
                    <div class="col-7">
                    <select id="coupon_category" class="form-control select2" multiple>
                      <option vale="percent"><?php echo e(trans('lang.select_category')); ?></option>
                    </select>
                    <div class="form-text text-muted">
                      <?php echo e(trans("lang.coupon_category_id_help")); ?>

                    </div>  
                  </div>
                </div> -->


                    <!-- </div> -->
                  </fieldset>
                </div>

              </div>

          </div>

          <div class="form-group col-12 text-center btm-btn">
            <button type="submit" class="btn btn-primary save_coupon_btn"><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>

            <!-- <a href="<?php echo route('coupons'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a> -->
          </div>
          </form>
        </div>

      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
  let slabIndex = 1;

  $('#add_slab').click(function() {
    $('#slab_table tbody').append(`
    <tr>
      <td><input type="number" name="slabs[${slabIndex}][min]" class="form-control" required></td>
      <td><input type="number" name="slabs[${slabIndex}][discount]" class="form-control" required></td>
      <td><button type="button" class="btn btn-sm btn-danger remove_slab">X</button></td>
    </tr>
  `);
    slabIndex++;
  });

  $(document).on('click', '.remove_slab', function() {
    $(this).closest('tr').remove();
  });


  $('.save_coupon_btn').on('click', function() {

    var code = $('.coupon_code').val();
    if (code != '') {
      $('.error').html('The Code field is required!');
    }

  })

  function toggleRating() {
    var applyFor = $('select[name="apply_for"]').val();
    if (applyFor === 'completed') {
      $('#rating_div').show();
      $('#discount_slab').show();
      $('#number_of_time').hide();
      $('#discount').hide();
      $('#minimun_amount').hide();      
    } else {
      $('#rating_div').hide();
      $('#rating_select').val('');
      $('#discount_slab').hide();
      $('#number_of_time').show();
      $('#discount').show();
      $('#minimun_amount').show();      
    }
  }

  // On page load
  toggleRating();

  // On change of Apply For
  $('select[name="apply_for"]').change(function() {
    toggleRating();
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/coupons/create.blade.php ENDPATH**/ ?>