<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.settings')); ?></h3>
        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo route('settings'); ?>"><?php echo e(trans('lang.user_plural')); ?></a>
                </li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.settings')); ?></li>
            </ol>
        </div>
    </div>


    <div class="error_top"></div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card pb-4">
                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default"
                            style="display: none;">
                            <?php echo e(trans('lang.processing')); ?>

                        </div>
                        <div class="error_top"></div>
                        <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php endif; ?>
                        <form action="<?php echo e(route('settings.update',['id'=>1])); ?>" method="post"
                            enctype="multipart/form-data" id="setting_form">
                            <?php echo csrf_field(); ?>

                            <div class="row restaurant_payout_create">
                                <div class="restaurant_payout_create-inner">
                                    <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <fieldset>
                                        <legend><?php echo e(trans('lang.settings')); ?></legend>

                                        <div class="form-group row width-50">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.settings_panel_title')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control title" name="title" id="title"
                                                    value="<?php echo e($setting->title); ?>">

                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.settings_panel_footer')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control user_last_name" name="footer"
                                                    id="footer" value="<?php echo e($setting->footer); ?>">

                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label
                                                class="col-5 control-label"><?php echo e(trans('lang.website_color_settings')); ?></label>
                                            <br>
                                            <input type="color" class="ml-3" name="website_color" id="website_color"
                                                value="<?php echo e($setting->website_color); ?>">
                                        </div>
                                        <div class="form-group row width-50">
                                            <label
                                                class="col-5 control-label"><?php echo e(trans('lang.driverapp_color_settings')); ?></label>
                                            <br>
                                            <input type="color" class="ml-3" name="driverapp_color" id="driverapp_color"
                                                value="<?php echo e($setting->driverapp_color); ?>">
                                        </div>
                                        <div class="form-group row width-50">
                                            <label
                                                class="col-5 control-label"><?php echo e(trans('lang.adminpanel_color_settings')); ?></label>
                                            <br>
                                            <input type="color" class="ml-3" name="adminpanel_color"
                                                id="adminpanel_color" value="<?php echo e($setting->adminpanel_color); ?>">
                                        </div>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.driver_radios')); ?>

                                                (<?php echo e($setting->delivery_distance); ?>)</label>
                                            <div class="col-7">
                                                <input type="text" class="form-control user_phone" name="driver_radios"
                                                    id="driver_radios" value="<?php echo e($setting->driver_radios); ?>">
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.app_logo')); ?></label>
                                            <input type="file" class="col-7" name="app_logo" id="app_logo"
                                                onchange="readURL(this);">
                                            <div id="image_preview" style="padding-left: 15px;">
                                                <?php if(file_exists(public_path('assets/images/'.$setting->app_logo)) &&
                                                !empty($setting->app_logo)): ?>
                                                <img class="rounded" id="uploding_image" style="width:50px"
                                                    src="<?php echo e(asset('assets/images/').'/'.$setting->app_logo); ?>"
                                                    alt="image">
                                                <?php else: ?>
                                                <img class="rounded" id="uploding_image" style="width:50px"
                                                    src="<?php echo e(asset('assets/images/logo-placeholder-image.png')); ?>"
                                                    alt="image">
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.app_logo_small')); ?></label>
                                            <input type="file" class="col-7" name="app_logo_small" id="app_logo_small"
                                                onchange="readURL2(this);">
                                            <div id="image_preview2" style="padding-left: 15px;">
                                                <?php if(file_exists(public_path('assets/images/'.$setting->app_logo_small))
                                                && !empty($setting->app_logo_small)): ?>
                                                <img class="rounded" id="uploding_image2" style="width:50px"
                                                    src="<?php echo e(asset('assets/images/').'/'.$setting->app_logo_small); ?>"
                                                    alt="image">
                                                <?php else: ?>
                                                <img class="rounded" id="uploding_image2" style="width:50px"
                                                    src="<?php echo e(asset('assets/images/logo-placeholder-image.png')); ?>"
                                                    alt="image">
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                    </fieldset>

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.google_map_api_key')); ?></legend>

                                        <div class="form-group row width-100">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.google_map_api_key')); ?></label>
                                            <div class="col-7">
                                                <input type="password" class="form-control address_line1" name="map_key"
                                                    id="map_key" value="<?php echo e($setting->google_map_api_key); ?>">
                                            </div>
                                        </div>
                                    </fieldset>

                                    <fieldset>

                                        <legend><?php echo e(trans('lang.ride_settings')); ?></legend>

                                        <div class="form-group row width-100">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.trip_accept_reject_by_driver')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control trip_accept_reject_by_driver"
                                                    name="trip_accept_reject_by_driver"
                                                    id="trip_accept_reject_by_driver"
                                                    value="<?php echo e($setting->trip_accept_reject_driver_time_sec); ?>">
                                            </div>
                                        </div>

                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.show_ride_otp')); ?></label>
                                            <div class="col-7">
                                                <select name="show_ride_otp" id="show_ride_otp" class="form-control">
                                                    <?php if($setting->show_ride_otp == 'yes'): ?>
                                                    <option value="yes" selected>Yes</option>
                                                    <option value="no">No</option>
                                                    <?php else: ?>
                                                    <option value="no" selected>No</option>
                                                    <option value="yes">Yes</option>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                    </fieldset>

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.delivery_charge_distance')); ?></legend>
                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.distance')); ?></label>
                                            <div class="col-7">
                                                <select name="delivery_distance" id="delivery_distance"
                                                    class="form-control">
                                                    <?php if($setting->delivery_distance == 'Miles'): ?>
                                                    <option value="KM">KM</option>
                                                    <option value="Miles" selected>Miles</option>
                                                    <?php else: ?>
                                                    <option value="KM" selected>KM</option>
                                                    <option value="Miles">Miles</option>
                                                    <?php endif; ?>
                                                </select>
                                            </div>
                                        </div>
                                    </fieldset>
                                    <fieldset>
                                        <legend><?php echo e(trans('lang.initial_payment_percentage')); ?></legend>
                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.percentage')); ?></label>
                                            <div class="col-7">
                                            <input type="number" class="form-control intial_payment_percentage"
                                                        name="intial_payment_percentage"
                                                        value="<?php echo e($setting->intial_payment_percentage); ?>">
                                            </div>
                                        </div>
                                    </fieldset>

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.wallet_settings')); ?></legend>
                                        <div class="form-group row width-100">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.minimum_deposit_amount')); ?></label>

                                            <div class="col-7">
                                                <div class="control-inner">
                                                    <input type="number" class="form-control minimum_deposit_amount"
                                                        name="minimum_deposit_amount"
                                                        value="<?php echo e($setting->minimum_deposit_amount); ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group row width-100">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.minimum_withdrawal_amount')); ?></label>

                                            <div class="col-7">
                                                <div class="control-inner">
                                                    <input type="number" class="form-control minimum_withdrawal_amount"
                                                        name="minimum_withdrawal_amount"
                                                        value="<?php echo e($setting->minimum_withdrawal_amount); ?>">
                                                </div>
                                            </div>
                                        </div>

                                    </fieldset>

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.referral_settings')); ?></legend>
                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.referral_amount')); ?></label>

                                            <div class="col-7">
                                                <div class="control-inner">
                                                    <input type="number" class="form-control referral_amount"
                                                        name="referral_amount" value="<?php echo e($setting->referral_amount); ?>">
                                                    <span class="currentCurrency"><?php echo e($currency->symbole); ?></span>
                                                    <div class="form-text text-muted">
                                                        <?php echo e(trans("lang.referral_amount_help")); ?>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.parcel_delivery_feature')); ?></legend>
                                        <div class="form-group row width-100">
                                            <div class="form-check">
                                                <input type="checkbox" class="active" id="parcel_active"
                                                    name="parcel_active" <?php echo e(($setting->parcel_active=="yes") ? "checked"
                                                : ""); ?>>
                                                <label class="col-3 control-label"
                                                    for="parcel_active"><?php echo e(trans('lang.active')); ?></label>
                                            </div>
                                        </div>
                                        <div class="parcel_setting">
                                            <div class="form-group row width-100">
                                                <label
                                                    class="col-3 control-label"><?php echo e(trans('lang.delivery_charge_parcel')); ?></label>
                                                <div class="col-7">
                                                    <input type="number" class="form-control delivery_charge_parcel"
                                                        name="delivery_charge_parcel" id="delivery_charge_parcel"
                                                        value="<?php echo e($setting->delivery_charge_parcel); ?>">
                                                </div>
                                            </div>
                                            <div class="form-group row width-100">
                                                <label
                                                    class="col-3 control-label"><?php echo e(trans('lang.parcel_per_weight_charge')); ?></label>
                                                <div class="col-7">
                                                    <input type="number" class="form-control parcel_per_weight_charge"
                                                        name="parcel_per_weight_charge" id="parcel_per_weight_charge"
                                                        value="<?php echo e($setting->parcel_per_weight_charge); ?>">
                                                </div>
                                            </div>
                                        </div>

                                    </fieldset>

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.map_redirection')); ?></legend>
                                        <div class="form-group row width-100">
                                            <label
                                                class="col-4 control-label"><?php echo e(trans('lang.select_map_type_for_application')); ?></label>
                                            <div class="col-7">
                                                <select name="map_for_app" id="map_for_app"
                                                    class="form-control map_for_app">
                                                    <option value="Google" <?php echo e(($setting->map_for_application=="Google") ?
                                                        "selected"
                                                        : ""); ?> ><?php echo e(trans("lang.google_maps")); ?></option>
                                                    <option value="OSM" <?php echo e(($setting->map_for_application=="OSM" ?
                                                        "selected" : "")); ?>><?php echo e(trans("lang.open_street_map")); ?></option>
                                                </select>
                                               
                                            </div>
                                             <div class="form-text pl-3 text-muted">
                                                    <span><strong><?php echo e(trans("lang.note")); ?> :</strong> <?php echo e(trans("lang.google_map_note")); ?><br>
                                                    <?php echo e(trans("lang.open_street_map_note")); ?><br>
                                                    <strong><?php echo e(trans("lang.recommended_note")); ?></strong></span>
                                                </div>
                                        </div>
                                        <div class="form-group row width-100">
                                            <label class="col-4 control-label"><?php echo e(trans('lang.select_map_type')); ?></label>
                                            <div class="col-7">
                                                <select name="map_type" id="map_type" class="form-control map_type">
                                                    <option value=""><?php echo e(trans("lang.select_type")); ?></option>
                                                    <option value="google" <?php echo e(($setting->mapType=="google") ? "selected"
                                                        : ""); ?> ><?php echo e(trans("lang.google_map")); ?></option>
                                                    <option value="googleGo" <?php echo e(($setting->mapType=="googleGo" ?
                                                        "selected" : "")); ?>><?php echo e(trans("lang.google_go_map")); ?></option>
                                                    <option value="waze" <?php echo e(($setting->mapType=="waze" ? "selected" :
                                                        "")); ?>><?php echo e(trans("lang.waze_map")); ?></option>
                                                    <option value="mapswithme" <?php echo e(($setting->mapType=="mapswithme" ?
                                                        "selected" : "")); ?>><?php echo e(trans("lang.mapswithme_map")); ?></option>
                                                    <option value="yandexNavi" <?php echo e(($setting->mapType=="yandexNavi" ?
                                                        "selected" : "")); ?>><?php echo e(trans("lang.vandexnavi_map")); ?></option>
                                                    <option value="yandexMaps" <?php echo e(($setting->mapType=="yandexMaps" ?
                                                        "selected" : "")); ?>><?php echo e(trans("lang.vandex_map")); ?></option>
                                                    <option value="inappmap" <?php echo e(($setting->mapType=="inappmap" ?
                                                        "selected" : "")); ?>><?php echo e(trans("lang.inapp_map")); ?></option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row width-100">
                                            <label
                                                class="col-4 control-label"><?php echo e(trans('lang.driver_location_update')); ?></label>
                                            <div class="col-7">
                                                <input name="driver_location_update" id="driver_location_update"
                                                    class="form-control" value="<?php echo e($setting->driverLocationUpdate); ?>">
                                            </div>
                                        </div>
                                    </fieldset>

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.contact_us')); ?></legend>

                                        <div class="form-group row width-50">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.contact_us_email')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control contact_us_email"
                                                    name="contact_us_email" id="contact_us_email"
                                                    value="<?php echo e($setting->contact_us_email); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.contact_us_phone')); ?></label>
                                            <div class="col-7">
                                                <input type="number" class="form-control contact_us_phone"
                                                    name="contact_us_phone" id="contact_us_phone"
                                                    value="<?php echo e($setting->contact_us_phone); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.contact_us_address')); ?></label>
                                            <div class="col-7">
                                                <textarea class="form-control contact_us_address" rows="3"
                                                    name="contact_us_address"
                                                    id="contact_us_address"><?php echo e($setting->contact_us_address); ?></textarea>
                                            </div>
                                        </div>

                                    </fieldset>

                                    <fieldset>

                                        <legend><i
                                                class="mr-3 mdi mdi-comment-alert"></i><?php echo e(trans('lang.notification_setting')); ?>

                                        </legend>

                                        <div class="form-group row width-100">
                                            <label class="col-5 control-label"><?php echo e(trans('lang.sender_id')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control" name="senderId"
                                                    value="<?php echo e($setting->senderId); ?>">
                                            </div>
                                            <div class="form-text pl-3 text-muted">
                                                <?php echo e(trans("lang.notification_sender_id_help")); ?>

                                            </div>
                                        </div>

                                        <div class="form-group row width-100">
                                            <label
                                                class="col-3 control-label"><?php echo e(trans('lang.upload_json_file')); ?></label>
                                            <input type="file" name="serviceJson" class="col-7 pb-2">
                                            <?php if(!empty($setting->serviceJson) &&
                                            Storage::disk('local')->has('firebase/credentials.json')): ?>
                                            <div id="uploded_json_file" class="btn-link pl-3">
                                                <a href="<?php echo $setting->serviceJson; ?>" target="_blank">See
                                                    Uploaded File</a>
                                            </div>
                                            <?php endif; ?>
                                            <div class="form-text pl-3 text-muted">
                                                <?php echo e(trans("lang.notification_json_file_help")); ?>

                                            </div>
                                        </div>

                                    </fieldset>

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.version')); ?></legend>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.app_version')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control app_version" name="app_version"
                                                    id="app_version" value="<?php echo e($setting->app_version); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.web_version')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control web_version" name="web_version"
                                                    id="web_version" value="<?php echo e($setting->web_version); ?>">
                                            </div>
                                        </div>

                                    </fieldset>

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.force_version_update')); ?></legend>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.customer_version')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control customer_version" name="customer_version"
                                                    id="customer_version" value="<?php echo e($setting->customer_version); ?>">
                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label"><?php echo e(trans('lang.driver_version')); ?></label>
                                            <div class="col-7">
                                                <input type="text" class="form-control driver_version" name="driver_version"
                                                    id="driver_version" value="<?php echo e($setting->driver_version); ?>">
                                            </div>
                                        </div>

                                    </fieldset>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>


                            <div class="form-group col-12 text-center btm-btn">
                                <input type="hidden" class="form-control address_line1" name="id" id="id"
                                    value="<?php echo e($setting->id); ?>">

                                <button type="submit" class="btn btn-primary  create_user_btn"><i
                                        class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?>

                                </button>
                                <a href="<?php echo route('settings'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
                            </div>

                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('scripts'); ?>

    <script>

        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#uploding_image').attr('src', e.target.result);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }

        function readURL2(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#uploding_image2').attr('src', e.target.result);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        var ischeck = $('#parcel_active').is(':checked');
        console.log(ischeck);
        if (ischeck) {
            $('.parcel_setting').show();
        } else {
            $('.parcel_setting').hide();
        }
        $('#parcel_active').on('click', function () {
            var ischeck = $(this).is(':checked');
            if (ischeck) {
                $('.parcel_setting').show();
            } else {
                $('.parcel_setting').hide();
            }

        });
    </script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/administration_tools/settings/index.blade.php ENDPATH**/ ?>