<?php $__env->startSection('content'); ?>
<div class="page-wrapper">

    <div class="row page-titles">

        <div class="col-md-5 align-self-center">

            <h3 class="text-themecolor"><?php echo e(trans('lang.sos')); ?></h3>

        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a>
                </li>
                <li class="breadcrumb-item active">
                    <?php echo e(trans('lang.sos')); ?>

                </li>
            </ol>
        </div>

    </div>

    <div class="container-fluid">

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <div class="userlist-topsearch d-flex mb-3">

                            <div id="users-table_filter" class="ml-auto">

                                <label><?php echo e(trans('lang.search_by')); ?>

                                    <div class="form-group">
                                        <form action="<?php echo e(route('sos')); ?>" method="get">
                                            <?php if(isset($_GET['selected_search']) && $_GET['selected_search'] != ''): ?>
                                            <select name="selected_search" id="selected_search"
                                                    class="form-control input-sm">
                                                <option value="status" <?php if($_GET[
                                            'selected_search']=='status'): ?>
                                                            selected="selected" <?php endif; ?>><?php echo e(trans('lang.status')); ?></option>

                                            </select>
                                            <?php else: ?>
                                            <select name="selected_search" id="selected_search"
                                                    class="form-control input-sm">
                                                <option value="status"><?php echo e(trans('lang.status')); ?></option>

                                            </select>
                                            <?php endif; ?>
                                            <div class="search-box position-relative">
                                                <?php if(isset($_GET['search']) && $_GET['search'] != ''): ?>
                                                <input type="text" class="search form-control" name="search"
                                                       id="search" value="<?php echo e($_GET['search']); ?>">
                                                <select id="status" class="form-control" name="status" style="display: none">
                                                    <option value="completed"><?php echo e(trans('lang.completed')); ?></option>
                                                    <option value="processing"><?php echo e(trans('lang.processings')); ?></option>
                                                    <option value="initiated"><?php echo e(trans('lang.initiated')); ?></option>
                                                    <option value="user feel"><?php echo e(trans('lang.user_feel_do_not_safe')); ?></option>
                                                </select>
                                                <?php elseif(isset($_GET['status']) && $_GET['status'] != ''): ?>
                                                    <select id="status" class="form-control" name="status">
                                                        <option class="completed"
                                                            <?php if($_GET['status']=='completed'): ?>selected="selected"
                                                                        <?php endif; ?> value="completed"><?php echo e(trans('lang.completed')); ?></option>
                                                        <option value="processing"
                                                            <?php if($_GET['status']=='processing'): ?>selected="selected" <?php endif; ?>><?php echo e(trans('lang.processings')); ?></option>
                                                        <option value="initiated"
                                                                <?php if($_GET['status']=='initiated'): ?>selected="selected" <?php endif; ?>><?php echo e(trans('lang.initiated')); ?></option>
                                                        <option value="user feel"
                                                                <?php if($_GET['status']=='user feel do not safe'): ?>selected="selected" <?php endif; ?>><?php echo e(trans('lang.user_feel_do_not_safe')); ?></option>
                                                    </select>
                                                    <input type="text" id="search" name="search" class="search form-control" placeholder="Search" style="display: none">
                                                <?php else: ?>
                                                <select id="status" class="form-control" name="status">
                                                    <option value="completed"><?php echo e(trans('lang.completed')); ?></option>
                                                    <option value="processing"><?php echo e(trans('lang.processings')); ?></option>
                                                    <option value="initiated"><?php echo e(trans('lang.initiated')); ?></option>
                                                    <option value="user feel"><?php echo e(trans('lang.user_feel_do_not_safe')); ?></option>
                                                </select>
                                                <?php endif; ?>

                                                <button onclick="searchtext();" class="btn btn-warning"><?php echo e(trans('lang.search')); ?></button>

                                                <!-- <button type="submit" class="btn-flat position-absolute"><i
                                                            class="fa fa-search"></i></button> -->

                                                <a class="btn btn-warning btn-flat" href="<?php echo e(url('sos')); ?>">Clear</a>
                                            </div>
                                        </form>
                                    </div>
                            </div>

                        </div>

                        <div class="table-responsive m-t-10">

                            <table id="example24"
                                   class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                   cellspacing="0" width="100%">

                                <thead>

                                <tr>
                                    <th class="delete-all"><input type="checkbox" id="is_active"><label
                                                class="col-3 control-label" for="is_active"><a id="deleteAll"
                                                                                               class="do_not_delete"
                                                                                               href="javascript:void(0)"><i
                                                        class="fa fa-trash"></i> All</a></label></th>
                                    <th><?php echo e(trans('lang.ride_id')); ?></th>
                                    
                                    <th><?php echo e(trans('lang.user_name')); ?></th>
                                    <th><?php echo e(trans('lang.driver_name')); ?></th>

                                    <th><?php echo e(trans('lang.sos_status')); ?></th>
                                    <th><?php echo e(trans('lang.created')); ?></th>

                                    <th><?php echo e(trans('lang.actions')); ?></th>
                                </tr>

                                </thead>

                                <tbody id="append_list1">
								<?php if(count($sos) > 0): ?>
                                <?php $__currentLoopData = $sos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $so): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="delete-all"><input type="checkbox"
                                                                  id="is_open_<?php echo e($so->id); ?>"
                                                                  class="is_open"
                                                                  dataid="<?php echo e($so->id); ?>"><label
                                                class="col-3 control-label"
                                                for="is_open_<?php echo e($so->id); ?>"></label></td>

                                    <td>
                                       
                                       <a href="<?php echo e(route('sos.show',['id'=>$so->id])); ?>"><?php echo e($so->ride_id); ?></a>
                                    </td>
                                    
                                    <td><a href="<?php echo e(route('users.show', $so->id_user_app)); ?>"><?php echo e($so->userPreNom); ?> <?php echo e($so->userNom); ?><a></td>
                                    <td><a href="<?php echo e(route('driver.show', $so->id_conducteur)); ?>"><?php echo e($so->driverPreNom); ?> <?php echo e($so->driverNom); ?></a></td>


                                    <td>
                                        <?php if($so->status=='initiated'): ?>
                                        <span class="badge badge-warning"><?php echo e($so->status); ?></span>
                                        <?php elseif($so->status=='processing'): ?>
                                        <span class="badge badge-primary"><?php echo e($so->status); ?></span>
                                        <?php elseif($so->status == 'user feel not safe'): ?>
                                        <span class="badge badge-danger">User Feel do not Safe</span>
                                        <?php elseif($so->status == 'driver feel not safe'): ?>
                                        <span class="badge badge-danger">Driver Feel do not Safe</span>
                                        <?php else: ?>
                                        <span class="badge badge-success"><?php echo e($so->status); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="date"><?php echo e(date('d F Y',strtotime($so->creer))); ?></span>
                                        <span class="time"><?php echo e(date('h:i A',strtotime($so->creer))); ?></span>
                                    </td>

                                    <td class="action-btn">
                                        <a href="<?php echo e(route('sos.show',['id'=>$so->id])); ?>" data-toggle="tooltip"
                                           data-original-title="Details"><i
                                                    class="fa fa-eye"></i></a>
                                        <a id="'+val.id+'"
                                           class="do_not_delete"
                                           name="user-delete"
                                           href="<?php echo e(route('sos.delete', ['id' => $so->id])); ?>"><i
                                                    class="fa fa-trash"></i></a>

                                    </td>
                                </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                	<tr><td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td></tr>
                                <?php endif; ?>
                                </tbody>

                            </table>

                            <nav aria-label="Page navigation example" class="custom-pagination">
                                <?php echo e($sos->appends(request()->query())->links()); ?>

                            </nav>
                              <?php echo e($sos->links('pagination.pagination')); ?>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
    $(document).ready(function () {

    })

    $("#is_active").click(function () {
        $("#example24 .is_open").prop('checked', $(this).prop('checked'));

    });

    $("#deleteAll").click(function () {
        if ($('#example24 .is_open:checked').length) {
            if (confirm('Are You Sure want to Delete Selected Data ?')) {
                var arrayUsers = [];
                $('#example24 .is_open:checked').each(function () {
                    var dataId = $(this).attr('dataId');
                    arrayUsers.push(dataId);

                });

                arrayUsers = JSON.stringify(arrayUsers);
                var url = "<?php echo e(url('sos/delete', 'id')); ?>";
                url = url.replace('id', arrayUsers);

                $(this).attr('href', url);
            }
        } else {
            alert('Please Select Any One Record .');
        }
    });
    
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/sos/index.blade.php ENDPATH**/ ?>