@extends('layouts.app')

@section('content')

<div class="page-wrapper ridedetail-page">

    <div class="row page-titles non-printable">

        <div class="col-md-5 align-self-center">

            <h3 class="text-themecolor">{{trans('lang.ride_detail')}}</h3>

        </div>

        <div class="col-md-7 align-self-center">

            <ol class="breadcrumb">

                <li class="breadcrumb-item">
                    <a href="{!! url('/dashboard') !!}">{{trans('lang.home')}}</a>
                </li>

                <li class="breadcrumb-item">
                    <a href="{!! route('rides.all') !!}">{{trans('lang.all_rides')}}</a>
                </li>

                <li class="breadcrumb-item active">
                    {{trans('lang.ride_detail')}}
                </li>

            </ol>

        </div>
    </div>

    <div class="container-fluid">

        <div class="row">

            <div class="col-12">

                <div class="card">
                    <div class="card-body">

                        {{-- <div class="row">

                            <div class="col-12">

                                <div class="box">
                                    <div class="box-header bb-2 border-primary">
                                        <h3 class="box-title">{{trans('lang.map_view')}}</h3>
                    </div>
                    <div class="box-body">
                        <div id="map" style="height:300px">
                        </div>
                    </div>
                </div>
            </div>
        </div>--}}
        <div id="data-table_processing" class="dataTables_processing panel panel-default"
            style="display: none;">{{trans('lang.processing')}}</div>
        <div class="col-md-12">
            <div class="print-top non-printable mt-3">
                <div class="text-right print-btn non-printable">
                    <button type="button" class="fa fa-print non-printable"
                        onclick="printDiv('printableArea')"></button>
                </div>
            </div>

            <hr class="non-printable">
        </div>

        <form method="post" action="{{ route('assign_driver_instead_rental_post') }}"
            enctype="multipart/form-data">
            @csrf

            <input name="ride_id" value="{{$ride->id}}" type="hidden">
            <input name="vehical_id" value="{{$ride->vehicle_id}}" type="hidden">


            <div class="order_detail printableArea" id="order_detail">
                <div class="order_detail-top mb-3 ">
                    <div class="row">
                        <div class="order_edit-genrl col-md-6">
                            <div class="card">
                                <div class="card-header bg-white">
                                    <h3>Assign Driver</h3>
                                </div>
                                <div class="card-body">
                                    <div class="order_detail-top-box">

                                        <div class="form-group row width-100 ">
                                            <label class="col-3 control-label">Drivers
                                                :</label>
                                            <div class="col-7">


                                                <select name="driver" id="driver_id" class="form-control" required>
                                                    <option> Select Driver </option>
                                                    @foreach ($driver_list as $key => $d)
                                                    <option value="{{ $d->id }}"> {{ $d->nom }} [{{$d->phone}}]
                                                    </option>
                                                    @endforeach

                                                </select>

                                                <div
                                                    class="form-group col-12 text-center btm-btn non-printable">
                                                    <button type="submit" class="btn btn-primary"><i
                                                            class="fa fa-save"></i>
                                                        {{trans('lang.save')}}</button>

                                                </div>
        </form>
    </div>
</div>

</div>

</div>
</div>
</div>


</div>
</div>



</div>

</div>
</div>
</div>


@endsection

@section('scripts')

<script type="text/javascript">
    $(document).ready(function() {
        $('#driver_id').select2({
            placeholder: "-- Select Driver --",
            allowClear: true,
            width: '100%'
        });

    });
</script>
@endsection