@extends('layouts.app')

@section('content')

<div class="page-wrapper">

    <div class="row page-titles">

        <div class="col-md-5 align-self-center">

            <h3 class="text-themecolor">{{trans('Driver-setting')}}</h3>

        </div>

        <div class="col-md-7 align-self-center">

            <ol class="breadcrumb">

                <li class="breadcrumb-item">
                    <a href="{{url('/dashboard')}}">{{trans('lang.dashboard')}}</a>
                </li>

                <li class="breadcrumb-item active">
                    {{trans('Driver-setting')}}
                </li>

            </ol>

        </div>

        <div>

        </div>

    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card pb-4">


                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">{{trans('lang.processing')}}</div>
                        <div class="error_top"></div>
                        @if($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                        @endif

                        <form action="{{ route('driver-setting.store') }}" method="post" enctype="multipart/form-data" id="">
                            @csrf

                            <div class="error_top" style="display:none"></div>
                            <div class="row restaurant_payout_create">
                                <div class="restaurant_payout_create-inner">
                                    <fieldset>

                                        <legend>{{trans('Driver Setting')}}</legend>

                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label">{{trans('Add Minutes For Assign Driver')}}</label>
                                            <div class="col-7">
                                                <input type="number" class="form-control" name="minutes" id="minutes" required>
                                                <div class="form-text text-muted">{{trans('add minutes here')}}</div>
                                            </div>
                                        </div>

                                    </fieldset>

                                </div>
                            </div>


                            <div class="form-group col-12 text-center btm-btn">
                                <button type="submit" class="btn btn-primary save_driver_btn"><i class="fa fa-save"></i> {{ trans('lang.save')}}</button>
                                <!-- <a href="{!! route('cms') !!}" class="btn btn-default"><i class="fa fa-undo"></i>{{ trans('lang.cancel')}}</a> -->
                            </div>
                        </form>

                          <div class="table-responsive m-t-10">

                            <table id="example24"
                                   class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                   cellspacing="0" width="100%">
                                <thead>
                                <tr>                                  
                                    <th>{{trans('Minutes')}}</th>                                  
                                </tr>
                                </thead>
                                <tbody id="append_list12">
                                @if(count($data) > 0)
                                @foreach($data as $values)
                                <tr>                                  
                                    <td>{{ $values->minutes}}</td>
                                </tr>
                                @endforeach
                                 @else
                            		<tr><td colspan="2" align="center">{{trans("lang.no_result")}}</td></tr>
                            	@endif
                                </tbody>
                            </table>                          
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>
</div>

@endsection


@section('scripts')

<script type="text/javascript">
    $(document).ready(function() {
        $(".shadow-sm").hide();
    })
</script>

@endsection