<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\SoftDeletes;

class SeatSharingRequest extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'seat_sharing_request';
  
    protected $guarded = [];

    protected $appends = ['ride_status_name'];

    public function seatSharingRequestStops()
    {
        return $this->hasMany(SeatSharingRequestStops::class, 'seat_sharing_request_id');
    }

    public function seatSharingRequestPrice()
    {
        return $this->hasMany(SeatSharingRequestPrice::class, 'seat_sharing_request_id');
    }

    public function seatSharingVehicleLayout()
    {
        return $this->hasMany(SeatSharingVehicleLayout::class, 'seat_sharing_request_id');
    }
    public function driver()
    {
        return $this->belongsTo(Driver::class, 'driver_id', 'id')
                    ->select('id', 'phone', 'nom', 'prenom', 'email', 'photo_path');
    }

    // public function seatSharingVehicleLayout()
    // {
    //     return $this->hasMany(SeatSharingVehicleLayout::class, 'seat_sharing_request_id')
    //                         ->leftJoin('driver_vehicle_layout_name as dvln', 'seat_sharing_vehicle_layout.driver_vehicle_layout_name_id', '=', 'dvln.id')
    //                         ->leftJoin('driver_vehicle_layout', 'seat_sharing_vehicle_layout.driver_vehicle_layout_id', '=', 'driver_vehicle_layout.id')
    //                         ->select('seat_sharing_vehicle_layout.is_driver','seat_sharing_vehicle_layout.is_booked','seat_sharing_vehicle_layout.booked_by'
    //                         , 'driver_vehicle_layout.label','driver_vehicle_layout.row','driver_vehicle_layout.position');
    // }

    public function getRideStatusNameAttribute()
    {
        return match ($this->ride_status) {
            0 => 'Not Started',
            1 => 'Started',
            2 => 'Cancelled',
            3 => 'Completed',
            default => 'Unknown',
        };
    }


}
