<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Http\Controllers\API\v1\GcmController;
use App\Models\RequestToDriver;

class SendNotificationJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $fcm_tokens,$message,$id,$ride;
    /**
     * Create a new job instance.
     */
    public function __construct($fcm_tokens,$message,$id,$ride)
    {
        $this->fcm_tokens = $fcm_tokens;
        $this->message = $message;
        $this->id = $id;
        $this->ride = $ride;
       
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $file = fopen('queue.txt','a');
        fwrite($file,'CRON RUN '.date('Y-m-d h:i:s').PHP_EOL);
        fclose($file);

        if ($this->fcm_tokens) {
            foreach($this->fcm_tokens as $fcm_token)
            {
                $check = RequestToDriver::create(['driver_id'=>$fcm_token->id,'request_id'=>$this->id]);
                GcmController::sendNotification($fcm_token->fcm_id, $this->message,$this->ride);                    
            }
        }
    }
}
