<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use Google\Client as Google_Client;

class GcmController extends Controller
{
    public static function sendNotification($token, $messages, $topic = '')
    {

        if (Storage::disk('local')->has('firebase/credentials.json')) {

            $client = new Google_Client();
            $client->setAuthConfig(storage_path('app/firebase/credentials.json'));
            $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
            $client->refreshTokenWithAssertion();
            $client_token = $client->getAccessToken();
            $access_token = $client_token['access_token'];

            if (!empty($access_token) && !empty($topic)) {

                $projectId = env('FIREBASE_PROJECT_ID');
                $url = 'https://fcm.googleapis.com/v1/projects/' . $projectId . '/messages:send';

                $data = [
                    'message' => [
                        'notification' => [
                            'title' => $messages['title'],
                            'body' => $messages['body'],
                            // 'sound' => $messages['sound'],
                        ],
                        // "android" => [
                        //     "notification" => [
                        //         "sound" => $messages['sound']
                        //     ]
                        // ]
                    ],
                ];

                if (!empty($topic) && empty($token)) {
                    $data['message']['topic'] = $topic;
                } else {
                    $data['message']['token'] = $token;
                }

                $headers = array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $access_token
                );

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

                $result = curl_exec($ch);
                if ($result === FALSE) {
                    die('FCM Send Error: ' . curl_error($ch));
                }
                curl_close($ch);
                $result = json_decode($result);

                $myfile = fopen('notification.txt', 'a');
                fwrite($myfile, print_r($result, true));
                fclose($myfile);

                $response = array();
                $response['success'] = true;
                $response['message'] = 'Notification successfully sent.';
                $response['result'] = $result;
            } else {
                $response = array();
                $response['success'] = false;
                $response['message'] = 'Missing access token to send notification.';
            }
        } else {
            $response = array();
            $response['success'] = false;
            $response['message'] = 'Firebase credentials file not found.';
        }

        // if (Storage::disk('local')->has('firebase/credentials.json')) {

        //     \Log::info('🚀 Firebase: Credential file found.');

        //     try {

        //         $client = new Google_Client();
        //         $client->setAuthConfig(storage_path('app/firebase/credentials.json'));
        //         $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        //         $client->refreshTokenWithAssertion();
        //         $client_token = $client->getAccessToken();

        //         \Log::info('Firebase: Access token generated.', $client_token);

        //         $access_token = $client_token['access_token'];

        //         if (!empty($access_token) && !empty($topic)) {

        //             $projectId = env('FIREBASE_PROJECT_ID');
        //             $url = 'https://fcm.googleapis.com/v1/projects/' . $projectId . '/messages:send';

        //             $data = [
        //                 'message' => [
        //                     'notification' => [
        //                         'title' => $messages['title'],
        //                         'body'  => $messages['body'],
        //                     ],
        //                 ],
        //             ];

        //             if (!empty($topic) && empty($token)) {
        //                 $data['message']['topic'] = $topic;
        //                 \Log::info("Firebase: Sending to topic → $topic");
        //             } else {
        //                 $data['message']['token'] = $token;
        //                 \Log::info("Firebase: Sending to token → $token");
        //             }

        //             \Log::info('Firebase Payload:', $data);

        //             $headers = [
        //                 'Content-Type: application/json',
        //                 'Authorization: Bearer ' . $access_token
        //             ];

        //             // CURL
        //             $ch = curl_init();
        //             curl_setopt($ch, CURLOPT_URL, $url);
        //             curl_setopt($ch, CURLOPT_POST, true);
        //             curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        //             curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        //             curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        //             curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        //             curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

        //             $result = curl_exec($ch);

        //             if ($result === FALSE) {
        //                 $error = curl_error($ch);
        //                 \Log::error('❌ FCM Send Error: ' . $error);
        //                 curl_close($ch);

        //                 return [
        //                     'success' => false,
        //                     'message' => 'FCM Send Error: ' . $error
        //                 ];
        //             }

        //             curl_close($ch);
        //             $resultDecoded = json_decode($result, true);

        //             \Log::info('📩 Firebase Response:', $resultDecoded);

        //             return [
        //                 'success' => true,
        //                 'message' => 'Notification successfully sent.',
        //                 'result'  => $resultDecoded,
        //             ];
        //         } else {
        //             \Log::warning('⚠ Firebase: Access token or topic missing.');
        //             return [
        //                 'success' => false,
        //                 'message' => 'Missing access token to send notification.'
        //             ];
        //         }
        //     } catch (\Exception $e) {

        //         \Log::error('🔥 Firebase exception:', [
        //             'error' => $e->getMessage(),
        //             'trace' => $e->getTrace()
        //         ]);

        //         return [
        //             'success' => false,
        //             'message' => 'Firebase Error: ' . $e->getMessage()
        //         ];
        //     }
        // } else {
        //     \Log::error('❌ Firebase credentials.json not found.');

        //     return [
        //         'success' => false,
        //         'message' => 'Firebase credentials file not found.'
        //     ];
        // }


        return response()->json($response);
    }

    public static function sendNotification_new($token, $messages, $topic = '')
    {

        if (Storage::disk('local')->has('firebase/credentials.json')) {

            $client = new Google_Client();
            $client->setAuthConfig(storage_path('app/firebase/credentials.json'));
            $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
            $client->refreshTokenWithAssertion();
            $client_token = $client->getAccessToken();
            $access_token = $client_token['access_token'];

            if (!empty($access_token) && !empty($topic)) {

                $projectId = env('FIREBASE_PROJECT_ID');
                $url = 'https://fcm.googleapis.com/v1/projects/' . $projectId . '/messages:send';

                $data = [
                    'message' => [
                        'notification' => [
                            'title' => $messages['title'],
                            'body' => $messages['body'],
                            'sound' => $messages['sound'],
                        ],
                        // "android" => [
                        //     "notification" => [
                        //         "sound" => $messages['sound']
                        //     ]
                        // ]
                    ],
                ];

                if (!empty($topic) && empty($token)) {
                    $data['message']['topic'] = $topic;
                } else {
                    $data['message']['token'] = $token;
                }

                $headers = array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $access_token
                );

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

                $result = curl_exec($ch);
                if ($result === FALSE) {
                    die('FCM Send Error: ' . curl_error($ch));
                }
                curl_close($ch);
                $result = json_decode($result);

                $myfile = fopen('notification.txt', 'a');
                fwrite($myfile, print_r($result, true));
                fclose($myfile);

                $response = array();
                $response['success'] = true;
                $response['message'] = 'Notification successfully sent.';
                $response['result'] = $result;
            } else {
                $response = array();
                $response['success'] = false;
                $response['message'] = 'Missing access token to send notification.';
            }
        } else {
            $response = array();
            $response['success'] = false;
            $response['message'] = 'Firebase credentials file not found.';
        }

        return response()->json($response);
    }
}
