<?php

namespace App\Http\Controllers;

use App\Models\DriverAssignSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class DriverSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $data = DriverAssignSetting::get();
        return view("driver-setting.index")->with('data' , $data);
    }

    public function edit($id)
    {
        $cmss = Cms::where('cms_id', $id)->first();
        return view('cms.edit', compact('cmss'));
    }



    public function store(Request $request)
    {
        // Validate the input
        $validator = Validator::make($request->all(), [
            'minutes' => 'required|numeric|min:1',
        ], [
            'minutes.required' => 'Please add minutes!',
            'minutes.numeric' => 'Minutes must be a number!',
            'minutes.min' => 'Minutes must be greater than 0!',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        // Check if a record already exists (assuming only one row should exist)
        $cmss = DriverAssignSetting::first();

        if ($cmss) {
            // Update existing
            $cmss->minutes = $request->input('minutes');
            $cmss->save();
        } else {
            // Create new
            $cmss = new DriverAssignSetting;
            $cmss->minutes = $request->input('minutes');
            $cmss->save();
        }

        return redirect('driver-setting')->with('success', 'Setting saved successfully.');
    }




    public function updateCms(Request $request, $id)
    {
        $validator = Validator::make($request->all(), $rules = [
            'cms_name' => ['required', Rule::unique('tj_cms')->ignore($id, 'cms_id')],
            'cms_slug' => ['required', Rule::unique('tj_cms')->ignore($id, 'cms_id')],
            'cms_desc' => 'required',


        ], $messages = [
            'cms_name.required' => 'The Page Name field is required!',
            'cms_desc.required' => 'Please insert page description',

        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)->with(['message' => $messages])
                ->withInput();
        }


        $cmss = Cms::where('cms_id', $id)->first();
        $cmss->cms_name = $request->get('cms_name');
        $cmss->cms_slug = $request->get('cms_slug');
        $cmss->cms_desc = $request->get('cms_desc');

        $cmss->cms_status = $request->has('cms_status') ? 'Publish' : 'Unpublish';
        $cmss->save();
        return redirect('cms');
    }
}
