<?php

namespace App\Http\Controllers;

use App\Models\Discount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use App\Models\CouponSlab;

class CouponController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $today = Carbon::now();
        if ($request->has('search') && $request->search != '' && $request->selected_search == 'code') {
            $search = $request->input('search');
            $discounts = DB::table('tj_discount')
                ->where('tj_discount.code', 'LIKE', '%' . $search . '%')
                ->orderBy('tj_discount.expire_at', 'desc')
                ->paginate(20);
        } else if ($request->has('search') && $request->search != '' && $request->selected_search == 'discount') {
            $search = $request->input('search');
            $discounts = DB::table('tj_discount')
                ->where('tj_discount.discount', 'LIKE', '%' . $search . '%')
                ->orderBy('tj_discount.expire_at', 'desc')
                ->paginate(20);
        } else {
            $discounts =  DB::table('tj_discount')
                ->orderBy('tj_discount.expire_at', 'desc')
                ->paginate(20);
        }
        // dd('aa');
        return view("coupons.index")->with('discounts', $discounts);
    }

    public function edit($id)
    {
        $discount = Discount::where('id', "=", $id)->first();
        if (!$discount) {
            abort(404);
        }

        $slabs = CouponSlab::where('coupon_id', $id)
            ->orderBy('min_ride_amount')
            ->get();

        return view('coupons.edit')->with([
            'discount' => $discount,
            'slabs' => $slabs
        ]);
    }

    public function updateDiscount(Request $request, $id)
    {

        // $validator = Validator::make($request->all(), $rules = [
        //     'code' => 'required',
        //     // 'discount' => 'required',
        //     'type' => 'required',
        //     'expire_at' => 'required|date',
        //     'discription' => 'required',
        //     'coupon_type' => 'required',
        //     'number_time_allowed' => 'required_if:apply_for,normal',
        //     // 'minimun_amount' => 'required',
        //     'apply_for' => 'required',
        //     'rating' => 'required_if:apply_for,completed',
        //     'title' => 'required',
        //     'slabs' => 'required|array|min:1',
        //     'slabs.*.min' => 'required|numeric|min:0',
        //     'slabs.*.discount' => 'required|numeric|min:0',

        // ], $messages = [
        //     'code.required' => 'The Code field is required!',
        //     // 'discount.required' => 'The Discount field is required!',
        //     'type.required' => 'The Discount Type is required!',
        //     'expire_at.required' => 'The Expire date field is required!',
        //     'discription.required' => 'The Description field is required',
        //     'title.required' => 'The Title field is required',
        //     'coupon_type.required' => 'The Coupon Type is required!',
        //     'number_time_allowed.required' => 'The Number Of Type field is required',
        //     // 'minimun_amount.required' => 'The Minimun Amount field is required!',
        //     'rating.required_if' => 'The Rating field is required when Apply For is Completed.',

        // ]);

        // if ($validator->fails()) {
        //     return redirect()->back()
        //         ->withErrors($validator)->with(['message' => $messages])
        //         ->withInput();
        // }

        $rules = [
            'code' => 'required',
            'type' => 'required',
            'expire_at' => 'required|date|after_or_equal:today',
            'discription' => 'required',
            'coupon_type' => 'required',
            'apply_for' => 'required|in:normal,completed',
            'title' => 'required',
        ];

        $messages = [
            'code.required' => 'The Code field is required!',
            'type.required' => 'The Discount Type is required!',
            'expire_at.required' => 'The Expire date field is required!',
            'discription.required' => 'The Description field is required',
            'coupon_type.required' => 'The Coupon Type is required!',
            'rating.required' => 'The Rating field is required when Apply For is Completed.',
            'title.required' => 'The Title is required!',
            'discount.required' => 'The Discount field is required for Normal coupons.',
            'slabs.required' => 'At least one discount slab is required.',
        ];

        if ($request->apply_for === 'completed') {
            $rules['rating'] = 'required|numeric|min:1|max:5';
            $rules['slabs'] = 'required|array|min:1';
            $rules['slabs.*.min'] = 'required|numeric|min:0';
            $rules['slabs.*.discount'] = 'required|numeric|min:0';
        } else {
            $rules['discount'] = 'required|numeric|min:0';
            $rules['minimun_amount'] = 'required|numeric|min:0';
            $rules['number_time_allowed'] = 'required|numeric|min:1';
        }

        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }


        /* ---------- Slab ascending validation ---------- */
        if ($request->apply_for === 'completed') {
            $prev = null;
            foreach ($request->slabs as $i => $slab) {
                if ($prev !== null && $slab['min'] <= $prev) {
                    return back()->withErrors([
                        "message" => "Slab #" . ($i + 1) . " minimum amount must be greater than previous slab."
                    ])->withInput();
                }
                $prev = $slab['min'];
            }
        }

        /* ---------- Prevent duplicate rating coupon ---------- */

        $discount = null;
        if ($request->apply_for == 'completed') {
            $discount = Discount::where('rating', $request->input('rating'))
                ->whereNull('deleted_at')
                ->where('statut', 'yes')
                ->where('id', '!=', $id)
                ->first();
        }

        if ($discount) {
            return back()
                ->withErrors(['coupon' => 'Coupon already generated for given rating'])
                ->withInput();
        }


        $code = $request->input('code');
        $discount = $request->input('discount');
        $type = $request->input('type');
        $expire_at = $request->input('expire_at');
        $description = $request->input('discription');
        $coupon_type = $request->input('coupon_type');
        $minimum_amount = $request->input('minimun_amount');
        $number_time_allowed = $request->input('number_time_allowed') ?? null;
        $rating = $request->input('rating') ?? null;
        $title = $request->input('title');
        $apply_for = $request->input('apply_for');

        $statut = $request->input('statut');
        $date = date('Y-m-d H:i:s');
        $discount_type = $request->type === "Fix Price" ? 'flat' : 'percent';
        $statut = $request->statut === 'on' ? 'yes' : 'no';

        $discounts = Discount::find($id);

        if ($discounts) {
            $discounts->code = $code;
            $discounts->discount = $discount;
            $discounts->type = $type;
            $discounts->expire_at = $expire_at;
            $discounts->discription = $description;
            $discounts->coupon_type = $coupon_type;
            $discounts->apply_for = $apply_for;
            $discounts->rating = $rating;
            $discounts->title = $title;

            $discounts->number_time_allowed = $number_time_allowed;
            $discounts->minimum_amount = $minimum_amount;

            $discounts->statut = $statut;
            $discounts->modifier = $date;
            $discounts->save();


            if ($request->apply_for === 'completed') {
                CouponSlab::where('coupon_id', $id)->delete();

                foreach ($request->slabs as $slab) {
                    CouponSlab::create([
                        'coupon_id' => $id,
                        'min_ride_amount' => $slab['min'],
                        'discount' => $slab['discount'],
                        'discount_type' => $discount_type,
                    ]);
                }
            } else {
                CouponSlab::where('coupon_id', $id)->delete();
            }

            DB::commit();
        }


        return redirect('coupons');
    }

    public function create()
    {
        return view('coupons.create');
    }

    public function store(Request $request)
    {

        // $slabs = $request->input('slabs');

        // $previousMin = null;

        // foreach ($slabs as $index => $slab) {
        //     if ($previousMin !== null && $slab['min'] <= $previousMin) {
        //         return back()
        //             ->withErrors(['message' => "Slab #" . ($index + 1) . " minimum amount must be greater than previous slab."])
        //             ->withInput();
        //     }

        //     $previousMin = $slab['min'];
        // }


        $slabs = $request->input('slabs');

        if ($request->apply_for === 'completed') {
            $previousMin = null;

            foreach ($slabs as $index => $slab) {
                if ($previousMin !== null && $slab['min'] <= $previousMin) {
                    return back()
                        ->withErrors(['message' => "Slab #" . ($index + 1) . " minimum amount must be greater than previous slab."])
                        ->withInput();
                }

                $previousMin = $slab['min'];
            }
        }



        // $validator = Validator::make($request->all(), $rules = [
        //     'code' => 'required',
        //     // 'discount' => 'required',
        //     'type' => 'required',
        //     'expire_at' => 'required|date',
        //     'discription' => 'required',
        //     'coupon_type' => 'required',
        //     'number_time_allowed' => 'required_if:apply_for,normal',
        //     // 'minimun_amount' => 'required',
        //     'apply_for' => 'required',
        //     'rating' => 'required_if:apply_for,completed',
        //     'title' => 'required',
        //     // 'slabs' => 'required|array|min:1',
        //     // 'slabs.*.min' => 'required|numeric|min:0',
        //     // 'slabs.*.discount' => 'required|numeric|min:0',

        //     'slabs' => 'required_if:apply_for,completed|array|min:1',
        //     'slabs.*.min' => 'required_if:apply_for,completed|numeric|min:0',
        //     'slabs.*.discount' => 'required_if:apply_for,completed|numeric|min:0',

        //     'discount' => 'required_if:apply_for,normal|numeric|min:0',



        // ], $messages = [
        //     'code.required' => 'The Code field is required!',
        //     // 'discount.required' => 'The Discount field is required!',
        //     'type.required' => 'The Discount Type is required!',
        //     'expire_at.required' => 'The Expire date field is required!',
        //     'discription.required' => 'The Description field is required',
        //     'coupon_type.required' => 'The Coupon Type is required!',
        //     'number_time_allowed.required_if' => 'The Number Of Type field is required',
        //     // 'minimun_amount.required' => 'The Minimun Amount field is required!',
        //     'rating.required_if' => 'The Rating field is required when Apply For is Completed.',
        //     'title.required' => 'The Title is required!',
        // ]);

        // if ($validator->fails()) {
        //     return back()
        //         ->withErrors($validator)->with(['message' => $messages])
        //         ->withInput();
        // }



        $rules = [
            'code' => 'required',
            'type' => 'required',
            'expire_at' => 'required|date|after_or_equal:today',
            'discription' => 'required',
            'coupon_type' => 'required',
            'apply_for' => 'required|in:normal,completed',
            'title' => 'required',
        ];

        $messages = [
            'code.required' => 'The Code field is required!',
            'type.required' => 'The Discount Type is required!',
            'expire_at.required' => 'The Expire date field is required!',
            'discription.required' => 'The Description field is required',
            'coupon_type.required' => 'The Coupon Type is required!',
            'rating.required' => 'The Rating field is required when Apply For is Completed.',
            'title.required' => 'The Title is required!',
            'discount.required' => 'The Discount field is required for Normal coupons.',
            'slabs.required' => 'At least one discount slab is required.',
        ];

        if ($request->apply_for === 'completed') {

            $rules['rating'] = 'required|numeric|min:1|max:5';
            $rules['slabs'] = 'required|array|min:1';
            $rules['slabs.*.min'] = 'required|numeric|min:0';
            $rules['slabs.*.discount'] = 'required|numeric|min:0';
        } else {

            $rules['discount'] = 'required|numeric|min:0';
            $rules['minimun_amount'] = 'required|numeric|min:0';
            $rules['number_time_allowed'] = 'required|numeric|min:1';
        }

        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        if ($request->type == "Fix Price") {
            $discount_type = 'flat';
        } elseif ($request->type == "Percentage") {
            $discount_type = 'percent';
        }


        $discount = null;
        if ($request->apply_for == 'completed') {
            $discount = Discount::where('rating', $request->input('rating'))
                ->whereNull('deleted_at')
                ->where('statut', 'yes')
                ->first();
        }


        if ($discount) {
            return back()
                ->withErrors(['coupon' => 'Coupon already generated for given rating'])
                ->withInput();
        }


        $code = $request->input('code');
        $discount = $request->input('discount');
        $type = $request->input('type');
        $expire_at = $request->input('expire_at');
        $description = $request->input('discription');
        $coupon_type = $request->input('coupon_type');
        $minimun_amount = $request->input('minimun_amount');
        $number_time_allowed = $request->input('number_time_allowed') ?? null;
        $rating = $request->input('rating');
        $apply_for = $request->input('apply_for');
        $title = $request->input('title');



        $statut = $request->input('statut');
        $date = date('Y-m-d H:i:s');
        if ($statut == "on") {
            $statut = "yes";
        } else {
            $statut = "no";
        }

        // $discounts = new Discount;

        // if ($discounts) {
        //     $discounts->code = $code;
        //     $discounts->discount = $discount;
        //     $discounts->type = $type;
        //     $discounts->expire_at = $expire_at;
        //     $discounts->discription = $description;
        //     $discounts->coupon_type = $coupon_type;
        //     $discounts->apply_for = $apply_for;
        //     $discounts->rating = $rating;
        //     $discounts->title = $title;

        //     $discounts->number_time_allowed = $number_time_allowed;
        //     $discounts->minimun_amount = $minimun_amount;

        //     $discounts->statut = $statut;
        //     $discounts->creer = $date;
        //     $discounts->modifier = $date;
        //     $discounts->save();


        //     foreach ($slabs as $slab) {
        //         CouponSlab::create([
        //             'coupon_id' => $discounts->id,
        //             'min_ride_amount' => $slab['min'],
        //             'discount_amount' => $slab['discount'],
        //             'discount_type' => $slab['discount_type'],
        //         ]);
        //     }
        // }

        // return redirect('coupons');


        DB::beginTransaction();

        try {
            $discounts = new Discount;

            $discounts->code = $request->code;
            $discounts->discount = $request->discount;
            $discounts->type = $request->type;
            $discounts->expire_at = $request->expire_at;
            $discounts->discription = $request->description;
            $discounts->coupon_type = $request->coupon_type;
            $discounts->apply_for = $request->apply_for;
            $discounts->rating = $request->rating;
            $discounts->title = $request->title;
            $discounts->number_time_allowed = $request->number_time_allowed;
            $discounts->minimum_amount = $request->minimun_amount;
            // $discounts->statut = $request->statut;
            $discounts->statut = $statut;

            $discounts->creer = now();
            $discounts->modifier = now();
            $discounts->save();

            if ($request->apply_for === 'completed') {
                foreach ($slabs as $slab) {
                    CouponSlab::create([
                        'coupon_id' => $discounts->id,
                        'min_ride_amount' => $slab['min'],
                        'discount' => $slab['discount'],
                        'discount_type' => $discount_type,
                    ]);
                }
            }

            DB::commit();

            return redirect('coupons');
        } catch (\Exception $e) {
            DB::rollBack();
            // return back()->withErrors(['error' => $e->getMessage()]);
            return back()
                ->withErrors(['coupon' => $e->getMessage()])
                ->withInput();
        }
    }

    public function show($id)
    {

        $discount = Discount::where('id', "=", $id)->first();

        $slabs = CouponSlab::where('coupon_id', $id)
            ->orderBy('min_ride_amount')
            ->get();


        // return view('coupons.show')->with('discount', $discount);
        return view('coupons.show')->with([
            'discount' => $discount,
            'slabs' => $slabs
        ]);
    }

    public function changeStatus($id)
    {
        $discount = Discount::find($id);
        if ($discount->statut == 'no') {
            $discount->statut = 'yes';
        } else {
            $discount->statut = 'no';
        }

        $current_rating = $discount->rating;

        if ($current_rating) {
            $discount = Discount::where('rating', $current_rating)
                ->where('statut', 'yes')
                ->where('id', '!=', $id)
                ->first();

            if ($discount) {
                return back()
                    ->withErrors(['coupon' => 'Coupon already generated for given rating'])
                    ->withInput();
            }
        }



        $discount->save();
        return redirect()->back();
    }

    public function delete($id)
    {

        if ($id != "") {

            $id = json_decode($id);

            if (is_array($id)) {

                for ($i = 0; $i < count($id); $i++) {
                    $user = Discount::find($id[$i]);
                    $user->delete();
                }
            } else {
                $user = Discount::find($id);
                $user->delete();
            }
        }

        return redirect()->back();
    }

    // public function toggalSwitch(Request $request)
    // {
    //     $ischeck = $request->input('ischeck');
    //     $id = $request->input('id');
    //     $discount = Discount::find($id);

    //     $current_rating = $discount->rating;

    //     if ($current_rating) {
    //         $discount = Discount::where('rating', $current_rating)
    //             ->where('statut', 'yes')
    //             ->where('id', '!=', $id)
    //             ->first();

    //         if ($discount) {
    //             return response()->json([
    //                 'status'  => false,
    //                 'message' => 'Coupon already generated for given rating'
    //             ], 422);
    //         }
    //     }

    //     if ($ischeck == "true") {
    //         $discount->statut = 'yes';
    //     } else {
    //         $discount->statut = 'no';
    //     }
    //     $discount->save();


    //     return response()->json([
    //         'status'  => true,
    //         'message' => 'Status updated successfully',
    //         'statut'  => $discount->statut
    //     ]);
    // }

    public function toggalSwitch(Request $request)
    {
        $id      = $request->input('id');
        $ischeck = $request->input('ischeck');

        if (!$id) {
            return response()->json([
                'status' => false,
                'message' => 'ID is missing'
            ]);
        }

        $discount = Discount::find($id);

        if (!$discount) {
            return response()->json([
                'status' => false,
                'message' => 'Discount not found'
            ]);
        }

        $current_rating = $discount->rating;

        // Only check duplicate when enabling
        if ($ischeck == true) {
            $exists = Discount::where('rating', $current_rating)
                ->where('statut', 'yes')
                ->where('id', '!=', $id)
                ->exists();

            if ($exists) {
                return response()->json([
                    'status' => false,
                    'message' => 'Coupon already generated for given rating'
                ]);
            }
        }

        $discount->statut = $ischeck ? 'yes' : 'no';
        $discount->save();

        return response()->json([
            'status' => true,
            'message' => 'Status updated successfully',
            'statut' => $discount->statut
        ]);
    }
}
