<?php

namespace App\Http\Controllers;

use App\Models\Currency;
use App\Models\FavoriteRide;
use App\Models\ParcelOrder;
use App\Models\Referral;
use App\Models\Requests;
use App\Models\Transaction;

use App\Models\User;
use App\Models\UserApp;
use App\Models\VehicleLocation;
use File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Image;
use Validator;

class AdminUserController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $loggedInUserId = auth()->id();

        $query = DB::table('users')
            ->where('users.id', '!=', $loggedInUserId)
            ->where('users.is_delete', 0);

        // Search by name
        if ($request->has('search') && $request->search != '' && $request->selected_search == 'name') {

            $search = $request->input('search');

            $query->where(function ($q) use ($search) {
                $q->where('users.name', 'LIKE', '%' . $search . '%')
                    ->orWhere(DB::raw('CONCAT(users.name, " ", users.name)'), 'LIKE', '%' . $search . '%');
            });
        }
        // Search by email
        else if ($request->has('search') && $request->search != '' && $request->selected_search == 'email') {

            $search = $request->input('search');

            $query->where('users.email', 'LIKE', '%' . $search . '%');
        }

        $users = $query->orderBy('users.id', 'desc')->paginate(20);

        return view("settings.admin-users.index", compact('users'));
    }


    public function create()
    {
        return view("settings.admin-users.create");
    }

    public function storeuser(Request $request)
    {

        $validator = Validator::make($request->all(), $rules = [
            'name' => 'required',
            'password' => 'required',
            'confirm_password' => 'required|same:password',
            'email' => 'required|email|unique:users',
        ], $messages = [
            'name.required' => 'The Name field is required!',
            'email.required' => 'The Email field is required!',
            'email.unique' => 'The Email is already taken!',
            'password.required' => 'The Password field is required!',
            'confirm_password.same' => 'Confirm Password should match the Password',
        ]);

        if ($validator->fails()) {
            return redirect('admin-users/create')
                ->withErrors($validator)->with(['message' => $messages])
                ->withInput();
        }
        $user = new User;
        $user->name = $request->input('name');
        $user->email = $request->input('email');
        $password = $request->input('password');
        $confirm_password = $request->input('confirm_password');
        $user->password = Hash::make($password);
        $user->created_at = date('Y-m-d H:i:s');
        $user->created_by = auth()->id();
        
        $user->updated_at = date('Y-m-d H:i:s');
        $user->save();

        return redirect('admin-users');
    }

    public function edit($id)
    {
        $user = User::where('id', "=", $id)->first();


        if (!empty($user['email'])) {
            $user['email'] = $user['email'];
        }

        return view("settings.admin-users.edit")->with("user", $user);
    }

    public function userUpdate(Request $request, $id)
    {


        $validator = Validator::make($request->all(), $rules = [
            'name' => 'required',
            'email' => 'required|email|unique:users,email,' . $id,
        ], $messages = [
            'name.required' => 'The Name field is required!',
            'email.required' => 'The Email field is required!',
            'email.unique' => 'The Email is already taken!',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)->with(['message' => $messages])
                ->withInput();
        }

        $name = $request->input('name');
        $email = $request->input('email');
        $user = User::find($id);

        if ($user) {
            $user->name = $name;
            $user->email = $email;
            $user->save();
        }

        return redirect('admin-users');
    }

    public function deleteUser($id)
    {
        if (!empty($id)) {

            $id = json_decode($id);

            $user = User::find($id);

            if ($user) {
                $user->is_delete = 1;   // mark as deleted
                $user->save();          // update record
            }
        }

        return redirect()->back();
    }
}
