<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use App\Models\Requests;
use Illuminate\Validation\Rule;
use App\Models\UserApp;
use App\Models\VehicleType;
use App\Models\RequestToDriver;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\API\v1\GcmController;
use App\Jobs\SendNotificationJob;
use Illuminate\Support\Facades\File;
use Exception;
use App\Models\Driver;
use App\Models\Rentalpackages;
use App\Models\AllRentalPackages;


class RequestController extends Controller
{
	public function create()
	{

		$customers = UserApp::whereNull('deleted_at')
			->orderBy('nom')
			->get();


		$sql = VehicleType::select('*')
			->where('status', '=', 'Yes')
			->where('deleted_at', '=', null)
			->get();

		$output = array();
		foreach ($sql as $row) {
			$selected_image = $row->selected_image;

			if (file_exists(public_path('assets/images/type_vehicle' . '/' . $row->image)) && !empty($row->image)) {
				$image_path = asset('assets/images/type_vehicle') . '/' . $row->image;
			} else {
				$image_path	=	asset('assets/images/placeholder_image.jpg');
			}
			if (file_exists(public_path('assets/images/type_vehicle' . '/' . $row->selected_image)) && !empty($row->selected_image)) {
				$selected_image_path = asset('assets/images/type_vehicle') . '/' . $row->selected_image;
			} else {
				$selected_image_path	=	asset('assets/images/placeholder_image.jpg');
			}

			$row->image = $image_path;
			$row->selected_image_path = $selected_image_path;
			$get_commission = DB::table('tj_commission')
				->select('*')
				->where('type', '=', 'fixed')
				->get();

			foreach ($get_commission as $row_commission) {
				$row->statut_commission = $row_commission->statut;
				$row->commission = $row_commission->value;
				$row->type = $row_commission->type;
			}

			$get_commission_perc = DB::table('tj_commission')
				->select('*')
				->where('type', '=', 'percentage')
				->get();

			foreach ($get_commission_perc as $row_commission_perc) {
				$row->statut_commission_perc = $row_commission_perc->statut;
				$row->commission_perc = $row_commission_perc->value;
				$row->type_perc = $row_commission_perc->type;
			}

			//Delivery Charges
			$get_delivery_chagres = DB::table('delivery_charges')
				->select('*')
				->where('id_vehicle_type', '=', $row->id)
				->get();

			foreach ($get_delivery_chagres as $row_delivery_chagres) {
				$row->delivery_charges = $row_delivery_chagres->delivery_charges_per_km;
				$row->minimum_delivery_charges = $row_delivery_chagres->minimum_delivery_charges;
				$row->minimum_delivery_charges_within = $row_delivery_chagres->minimum_delivery_charges_within_km;
				$row->outstation_radius = !empty($row_delivery_chagres->outstation_radius) ? $row_delivery_chagres->outstation_radius : '0.0';
				$row->outstation_delivery_charge_per_km = !empty($row_delivery_chagres->outstation_delivery_charge_per_km) ? $row_delivery_chagres->outstation_delivery_charge_per_km : '0.0';
			}

			$output[] = $row;
		}

		return view('admin.request.create', compact('customers', 'output'));
	}


	public function create_rental()
	{

		$customers = UserApp::whereNull('deleted_at')
			->orderBy('nom')
			->get();


		$rental_package = AllRentalPackages::where('status', 'yes')->orderby('hours', 'ASC')->get();


		return view('admin.request.create_rental', compact('customers', 'rental_package'));
	}


	public function vehicleByPackage(Request $request)
	{
		$package_id = $request->get('package_id');
		$latitude = $request->get('latitude');
		$longitude = $request->get('longitude');
		if ($package_id != '' && $latitude != '' && $longitude != '') {

			$vids = Rentalpackages::where('package_id', $package_id)
				->pluck('vehicle_id')->toArray();

			$types = VehicleType::wherein('id', $vids)->get();

			$all_types = [];
			foreach ($types as $k => $val) {

				$vehicle = DB::table('tj_vehicule')->where('id_type_vehicule', $val->id)->first();

				if (!empty($vehicle)) {
					$driver = DB::table('tj_conducteur')
						//->where('online', 'yes')
						//->where('statut', 'yes')
						->selectRaw("latitude, longitude,
                 ( 6371 * acos( cos( radians(?) ) *
                   cos( radians( latitude ) )
                   * cos( radians( longitude ) - radians(?)
                   ) + sin( radians(?) ) *
                   sin( radians( latitude ) ) )
                 ) AS distance", [$latitude, $longitude, $latitude])
						->where('id', $vehicle->id_conducteur)->first();
					if (!empty($driver)) {
						$distance = ($driver->distance % $vehicle->milage) / $vehicle->milage * 60;
						$types[$k]->distance = $distance . " minutes";
						$rental = Rentalpackages::where('vehicle_id', $val->id)->where('package_id', $package_id)->first();

						$types[$k]->price = $rental->price;
						if (file_exists(public_path('assets/images/type_vehicle' . '/' . $val->image)) && !empty($val->image)) {
							$types[$k]->image = asset('assets/images/type_vehicle') . '/' . $val->image;
						} else {
							$types[$k]->image = asset('assets/images/placeholder_image.jpg');
						}
						$types[$k]->description = 'Comfy, econimacal cars';
						$all_types[] = $val;
					}
				}
			}

			if ($all_types) {
				$response['success'] = 'success';
				$response['data'] = isset($all_types) ? $all_types : [];
			} else {
				$response['success'] = 'Failed';
				$response['error'] = 'No Vehicle Found';
			}
		} else {
			$response['success'] = 'Failed';
			$response['error'] = 'some fields are missing';
		}
		return response()->json($response);
	}



	public function register(Request $request)
	{
		DB::beginTransaction(); // start transaction

		if ($request->has('version')) {
			$version = $request->get('version');
		} else {
			$version = null;
		}

		try {
			// Validate round trip dates
			if (empty($request->get('round_trip'))) {
				return redirect()->back()->withErrors(['Round trip is required']);
			}

			$user_id = $request->get('user_id');
			$lat1 = $request->get('lat1');
			$lng1 = $request->get('lng1');
			$lat2 = $request->get('lat2');
			$lng2 = $request->get('lng2');
			$cout = $request->get('cout');
			$distance = $request->get('distance');
			$duree = $request->get('duree');
			$vehicle_id = $request->get('vehicle_id'); // fixed typo 'vechicle_id' → 'vehicle_id'
			$depart_name = $request->get('source');
			$destination_name = $request->get('destination');


			$number_poeple = '1';
			$trip_objective = 'General';
			$stops = json_encode($request->get('stops'));
			$time_stamp = round(microtime(true) * 1000);

			$return_date = null;
			$return_hour = null;

			if (empty($request->get('round_trip'))) {
				return redirect()->back()->withErrors(['Select round trip']);
			}

			$date = $request->get('date');
			$hour = $request->get('hour');

			if (!empty($hour)) {
				$hour = (strlen($hour) === 5) ? $hour . ':00' : $hour;
			}

			if ($request->get('round_trip') == "Yes") {
				$return_date = $request->get('return_date');
				$return_hour = $request->get('return_hour');

				if (!empty($return_hour)) {
					$return_hour = (strlen($return_hour) === 5) ? $return_hour . ':00' : $return_hour;
				}

				if (empty($return_date) || empty($return_hour) || empty($date) || empty($hour)) {
					return redirect()->back()->withErrors(['All date and time are required for round trip.']);
				}


				$pickup = Carbon::parse($date . ' ' . $hour);
				$return = Carbon::parse($return_date . ' ' . $return_hour);

				if ($return->lessThan($pickup)) {
					return redirect()->back()->withErrors(['Return time must be greater than pickup time.']);
				}

				if ($pickup->diffInMinutes($return, false) < 15) {
					return redirect()->back()->withErrors(['Return time must be at least 15 minutes after pickup time.']);
				}


				$now = Carbon::now()->startOfMinute();
				$pickup = Carbon::parse($date . ' ' . $hour)->startOfMinute();

				if ($pickup->lessThan($now)) {
					return redirect()->back()->withErrors([
						'Pickup date & time must be greater than current time.'
					]);
				}


				$date_retour = $date;
				$heure_retour =  $hour;
			} elseif ($request->get('round_trip') == "No") {

				if ($request->get('ride_type') == 'scheduled') {

					if (empty($date) || empty($hour)) {
						return redirect()->back()->withErrors(['Date and time are required for scheduled trip.']);
					}

					$date_retour = $date;
					$heure_retour = $hour;
				} else {

					$date_retour = date('Y-m-d');
					$heure_retour = date('H:i:s');
				}
			}


			$setting = DB::table('tj_settings')->where('id', 1)->first();
			$under_radious = $setting->driver_radios;
			$minumum_wallet = $setting->minimum_deposit_amount;
			$ride_type = 'customer';
			$remaining_payment = $cout;

			$roundTrip = strtolower($request->get('round_trip'));

			// Insert ride request
			$insertdata = DB::table('tj_requete')->insert([
				'vehicle_id'             => $vehicle_id,
				'time_stamp'             => $time_stamp,
				'remaining_payment'      => $cout,
				'date_retour'            => $date_retour,
				'statut_round' => $roundTrip,
				'heure_retour'           => $heure_retour,
				'number_poeple'          => $number_poeple,
				'id_payment_method'      => 5,
				'depart_name'            => $depart_name,
				'destination_name'       => $destination_name,
				'id_user_app'            => $user_id,
				'latitude_depart'        => $lat1,
				'longitude_depart'       => $lng1,
				'latitude_arrivee'       => $lat2,
				'longitude_arrivee'      => $lng2,
				'statut'                 => 'new',
				'creer'                  => date('Y-m-d H:i:s'),
				'distance'               => $distance,
				'distance_unit'          => DB::table('tj_settings')->value('delivery_distance'),
				'montant'                => $cout,
				'duree'                  => $duree,
				'trip_objective'         => $trip_objective,
				'feel_safe'              => 0,
				'tip_amount'             => 0,
				'statut_paiement'        => '',
				'modifier'               => date('Y-m-d H:i:s'),
				'statut_course'          => '',
				'id_conducteur_accepter' => 0,
				'trip_category'          => '',
				'feel_safe_driver'       => 0,
				'stops'                  => $stops,
				'type' => ($roundTrip === 'yes') ? 'outstation_ride' : 'daily_ride',
				'return_date'            => $return_date ?: null,
				'return_hour'            => $return_hour ?: null,
			]);

			$id = DB::getPdo()->lastInsertId();

			if (!$id) {
				throw new \Exception('Failed to insert ride request');
			}

			if ($id > 0) {
				$get_user = Requests::where('id', $id)->first();
				$rowData = $get_user->toArray();
			}

			$currentTime = Carbon::now();

			// $rideStartHour = Carbon::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . ' ' . $heure_retour);
			$rideStartHour = Carbon::createFromFormat('Y-m-d H:i:s', $date_retour . ' ' . $heure_retour);
			$diffInMinutes = $currentTime->diffInMinutes($rideStartHour);
			if ($diffInMinutes <= 5) {
				$tmsg = '';
				$terrormsg = '';

				$title = str_replace("'", "\'", "New ride");
				$msg = str_replace("'", "\'", "You have just received a request from a client");

				$tab[] = array();
				$tab = explode("\\", $msg);
				$msg_ = "";
				for ($i = 0; $i < count($tab); $i++) {
					$msg_ = $msg_ . "" . $tab[$i];
				}


				$driver_id = DB::table('tj_vehicule')
					->where('id_type_vehicule', $vehicle_id)->get()
					->pluck('id_conducteur')->toArray();

				$busy_drivers =  Requests::whereIn('statut', ["on ride", "confirmed"])
					->whereNotnull('id_conducteur')
					->where('id_conducteur', '!=', '')
					->where('id_conducteur', '!=', null)
					->get()->pluck("id_conducteur")->toArray();

				array_unique($busy_drivers);


				$message = array("body" => $msg_, "title" => $title, "sound" => "order_received", "tag" => "ridenewrider");


				$fcm_tokens = DB::table('tj_conducteur')->selectRaw("id, fcm_id, latitude, longitude,
                    ( 6371 * acos( cos( radians(?) ) *
                    cos( radians( latitude ) )
                    * cos( radians( longitude ) - radians(?)
                    ) + sin( radians(?) ) *
                    sin( radians( latitude ) ) )
                    ) AS distance", [$lat1, $lng1, $lat1])
					->where('fcm_id', '!=', '')
					->where('driver_type', 'In house driver')
					->where('online', 'yes')
					->where('statut', 'yes');
				if (is_array($busy_drivers) &&  sizeof($busy_drivers) > 0) {
					$fcm_tokens =  $fcm_tokens->whereNotIn("id", $busy_drivers);
				}


				$fcm_tokens =   $fcm_tokens->having("distance", "<", $under_radious)
					->orderBy("distance", 'asc')
					->get();



				$ride = ['ride_id' => $id, 'status' => 'new'];
				if ($fcm_tokens) {
					foreach ($fcm_tokens as $fcm_token) {
						$check = RequestToDriver::create(['driver_id' => $fcm_token->id, 'request_id' => $id]);

						if ($version) {

							GcmController::sendNotification_new($fcm_token->fcm_id, $message, $ride);
						} else {

							GcmController::sendNotification($fcm_token->fcm_id, $message, $ride);
						}
					}
				}

				$fcm_tokens = DB::table('tj_conducteur')->selectRaw("id, fcm_id, latitude, longitude,
                    ( 6371 * acos( cos( radians(?) ) *
                    cos( radians( latitude ) )
                    * cos( radians( longitude ) - radians(?)
                    ) + sin( radians(?) ) *
                    sin( radians( latitude ) ) )
                    ) AS distance", [$lat1, $lng1, $lat1])
					->where('fcm_id', '!=', '')
					->where('driver_type', 'Outside driver')
					->where('amount', '>=', $minumum_wallet)
					->where('online', 'yes')
					->where('statut', 'yes');

				if (is_array($busy_drivers) && sizeof($busy_drivers) > 0) {
					$fcm_tokens =  $fcm_tokens->whereNotIn("id", $busy_drivers);
				}
				$fcm_tokens =   $fcm_tokens->having("distance", "<", $under_radious)

					->orderBy("distance", 'asc')
					//->limit(10)
					->get();

				SendNotificationJob::dispatch($fcm_tokens, $message, $id, $ride)->delay(now()->addSeconds(30));
			}

			if ($id > 0) {
				$get_user = Requests::where('id', $id)->first();
				$row = $get_user->toArray();

				$row['stops'] = json_decode($row['stops'], true);
				$row['user_info'] = json_decode($row['user_info'], true);
				if ($row['trajet'] != '') {
					if (file_exists(public_path('images/recu_trajet_course/' . '/' . $row['trajet']))) {
						$image_user = asset('images/recu_trajet_course/') . '/' . $row['trajet'];
					} else {
						$image_user = asset('assets/images/placeholder_image.jpg');
					}
					$row['trajet'] = $image_user;
				}
				$row['remaining_payment'] = $row['montant'] - $row['advance_payment'];

				//AUTO CAPTURE PAYMENT

				$sql = Requests::where('id', $id)->first();

				if ($sql->advance_payment != 0 && ($sql->razorpay_transaction_id != NULL || $sql->razorpay_transaction_id != "")) {
					$this->capture_payment($sql);
				}
			} else {
				return redirect()->back()->withErrors(['Failed']);
			}

			DB::commit();

			return redirect('rides/all')->with('success', 'Ride created successfully');
		} catch (\Exception $e) {
			DB::rollBack(); // rollback transaction			
			return redirect()->back()->withErrors(['Failed to create ride: ' . $e->getMessage()]);
		}
	}

	public function register_rental(Request $request)
	{

		$validated = $request->validate([
			'source' => ['required', 'string', 'max:255'],
			'lat1'   => ['required', 'numeric'],
			'lng1'   => ['required', 'numeric'],

			'user_id' => [
				'required'
			],

			'rental_package_id' => [
				'required',
			],
			'vehicle_id' => [
				'required'
			],
			'cout' => ['required', 'numeric', 'min:0'],
			'ride_type' => ['required'],

		], [
			'source.required' => 'Please select source.',
			'vehicle_id.required' => 'Please select a vehicle.',
			'rental_package_id.required' => 'Please select a rental package.',
			'user_id.required' => 'Please select a customer.',
		]);


		$setting = DB::table('tj_settings')->where('id', 1)->first();
		$under_radious = $setting->driver_radios;

		$user_id = $request->get('user_id');
		$rental_package_id = $request->get('rental_package_id');
		$lat1 = $request->get('lat1');
		$lng1 = $request->get('lng1');
		$cout = $request->get('cout');
		$depart_name = $request->get('source');		
		$razorpay_transaction_id = $request->get('id_payment');
		$vehicle_id = $request->get('vehicle_id');
		

		if (!empty($rental_package_id)) {

			$vehicle = DB::table('rental_packages')->where('package_id', $rental_package_id)
				->where('vehicle_id', $vehicle_id)
				->first();

			$cout = $vehicle->price ?? 0;
			$settings = DB::table('tj_settings')->first();
			$intial_payment_percentage = $settings->intial_payment_percentage;

			if ($intial_payment_percentage != 0) {
				$advance_payment = ($cout * $intial_payment_percentage) / 100;
				$remaining_payment = $cout - $advance_payment;
			}else{
				$remaining_payment = $cout;
			}

			$id_payment = 5;

			$date_heure = date('Y-m-d H:i:s');

			$date = $request->get('date');
			$hour = $request->get('hour');

			if (!empty($hour)) {
				$hour = (strlen($hour) === 5) ? $hour . ':00' : $hour;
			}


			if ($request->get('ride_type') == 'scheduled') {

				if (empty($date) || empty($hour)) {
					return redirect()->back()->withErrors(['Date and time are required for scheduled trip.']);
				}

				$date_retour = $date;
				$heure_retour = $hour;
			} else {

				$date_retour = date('Y-m-d');
				$heure_retour = date('H:i:s');
			}


			DB::table('tj_requete')->insert([
				'vehicle_id'              => $vehicle_id,
				'razorpay_transaction_id' => $razorpay_transaction_id,
				'remaining_payment'       => $remaining_payment,
				'date_retour'             => $date_retour,
				'heure_retour'            => $heure_retour,
				'id_payment_method'       => $id_payment,
				'depart_name'             => $depart_name,
				'id_user_app'             => $user_id,
				'latitude_depart'         => $lat1,
				'longitude_depart'        => $lng1,
				'statut'                  => 'confirmed',
				'creer'                   => $date_heure,
				'montant'                 => $cout,
				'feel_safe'               => 0,
				'tip_amount'              => 0,
				'statut_paiement'         => '',
				'modifier'                => $date_heure,
				'statut_course'           => '',
				'id_conducteur_accepter'  => 0,
				'trip_category'           => '',
				'feel_safe_driver'        => 0,
				'rental_package_id'       => $rental_package_id,
				'type'                    => 'rental_ride',
				// 'advance_payment'         => $advance_payment,
			]);


			$id = DB::getPdo()->lastInsertId();


			if ($id > 0) {
				$get_user = Requests::where('id', $id)->first();
				$row = $get_user->toArray();

				$row['stops'] = json_decode($row['stops'], true);
				$row['user_info'] = json_decode($row['user_info'], true);
				if ($row['trajet'] != '') {
					if (file_exists(public_path('images/recu_trajet_course/' . '/' . $row['trajet']))) {
						$image_user = asset('images/recu_trajet_course/') . '/' . $row['trajet'];
					} else {
						$image_user = asset('assets/images/placeholder_image.jpg');
					}
					$row['trajet'] = $image_user;
				}

				$row['remaining_payment'] = (float)$row['montant'] - $row['advance_payment'];

				//AUTO CAPTURE PAYMENT

				$sql = Requests::where('id', $id)->first();

				if ($sql->advance_payment != 0 && ($sql->razorpay_transaction_id != NULL || $sql->razorpay_transaction_id != "")) {
					$this->capture_payment($sql);
				}
			} else {				
				return redirect()->back()->withErrors(['Failed']);
			}
		} else {
			return redirect()->back()->withErrors(['some field required']);
		}


		return redirect('rental/rides/all')->with('success', 'Ride created successfully');
	}


	// public function register(Request $request)
	// {

	// 	if ($request->has('version')) {
	// 		$version = $request->get('version');
	// 	} else {
	// 		$version = null;
	// 	}

	// 	$user_id = $request->get('user_id');
	// 	$lat1 = $request->get('lat1');
	// 	$lng1 = $request->get('lng1');
	// 	$lat2 = $request->get('lat2');
	// 	$lng2 = $request->get('lng2');
	// 	$cout = $request->get('cout');
	// 	$distance = $request->get('distance');
	// 	$duree = $request->get('duree');

	// 	$vehicle_id = $request->get('vechicle_id');
	// 	$distance_unit = DB::table('tj_settings')->select('delivery_distance')->value('delivery_distance');
	// 	$id_payment = 5;
	// 	$depart_name = $request->get('source');
	// 	$destination_name = $request->get('destination');

	// 	$number_poeple = '1';
	// 	$trip_objective = 'General';
	// 	$stops = json_encode($request->get('stops'));
	// 	$time_stamp = round(microtime(true) * 1000);

	// 	$return_date = '';
	// 	$return_hour = '';

	// 	if (!empty($request->get('round_trip'))) {

	// 		if ($request->get('round_trip') == "Yes") {

	// 			$return_date = $request->get('return_date');
	// 			$return_hour = $request->get('return_hour');
	// 			$date = $request->get('date');
	// 			$hour = $request->get('hour');

	// 			if (empty($return_date) || empty($return_hour) || empty($date) || empty($hour)) {
	// 				return redirect()->back()->withErrors(['All date and time are required for round trip.']);
	// 			}

	// 			$pickup   = Carbon::parse($request->date . ' ' . $request->hour);
	// 			$return   = Carbon::parse($request->return_date . ' ' . $request->return_hour);

	// 			if ($return->lessThan($pickup)) {
	// 				return redirect()->back()->withErrors(['Return time must be greater than pickup time.']);
	// 			}
	// 		} else {
	// 			if (!empty($request->get('date')))
	// 				$date_retour = $request->get('date');
	// 			else
	// 				$date_retour = date('Y-m-d');


	// 			if (!empty($request->get('hour')))
	// 				$heure_retour = $request->get('hour');
	// 			else
	// 				$heure_retour = date('H:i:s');
	// 		}
	// 	} else {
	// 		return redirect()->back()->withErrors(['Round trip is required']);
	// 	}

	// 	$statut_round = $request->get('round_trip');




	// 	$type = 'daily_ride';

	// 	$setting = DB::table('tj_settings')->where('id', 1)->first();
	// 	$under_radious = $setting->driver_radios;
	// 	$minumum_wallet = $setting->minimum_deposit_amount;
	// 	$ride_type = 'customer';
	// 	$remaining_payment = $cout;


	// 	if (!empty($id_payment)) {

	// 		if ($ride_type == "customer") {

	// 			$return_date_sql = $return_date === null ? "NULL" : "'$return_date'";
	// 			$return_hour_sql = $return_hour === null ? "NULL" : "'$return_hour'";

	// 			$insertdata = DB::table('tj_requete')->insert([
	// 				'vehicle_id'               => $vehicle_id,
	// 				'time_stamp'               => $time_stamp,
	// 				'remaining_payment'        => $remaining_payment,
	// 				'date_retour'              => $date_retour,
	// 				'statut_round'             => $statut_round,
	// 				'heure_retour'             => $heure_retour,
	// 				'number_poeple'            => $number_poeple,
	// 				'id_payment_method'        => $id_payment,
	// 				'depart_name'              => $depart_name,
	// 				'destination_name'         => $destination_name,
	// 				'id_user_app'              => $user_id,
	// 				'latitude_depart'          => $lat1,
	// 				'longitude_depart'         => $lng1,
	// 				'latitude_arrivee'         => $lat2,
	// 				'longitude_arrivee'        => $lng2,
	// 				'statut'                   => 'new',
	// 				'creer'                    => date('Y-m-d H:i:s'),
	// 				'distance'                 => $distance,
	// 				'distance_unit'            => $distance_unit,
	// 				'montant'                  => $cout,
	// 				'duree'                    => $duree,
	// 				'trip_objective'           => $trip_objective,
	// 				'feel_safe'                => 0,
	// 				'tip_amount'               => 0,
	// 				'statut_paiement'          => '',
	// 				'modifier'                 => date('Y-m-d H:i:s'),
	// 				'statut_course'            => '',
	// 				'id_conducteur_accepter'   => 0,
	// 				'trip_category'            => '',
	// 				'feel_safe_driver'         => 0,
	// 				'stops'                    => $stops,
	// 				'type'                     => $type,
	// 				'return_date'              => $return_date_sql,
	// 				'return_hour'              => $return_hour_sql,
	// 			]);


	// 			$id = DB::getPdo()->lastInsertId();

	// 			if ($id > 0) {
	// 				$get_user = Requests::where('id', $id)->first();
	// 				$rowData = $get_user->toArray();
	// 			}

	// 			$currentTime = Carbon::now();
	// 			$rideStartHour = Carbon::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . ' ' . $heure_retour);
	// 			$diffInMinutes = $currentTime->diffInMinutes($rideStartHour);
	// 			if ($diffInMinutes <= 5) {
	// 				$tmsg = '';
	// 				$terrormsg = '';

	// 				$title = str_replace("'", "\'", "New ride");
	// 				$msg = str_replace("'", "\'", "You have just received a request from a client");

	// 				$tab[] = array();
	// 				$tab = explode("\\", $msg);
	// 				$msg_ = "";
	// 				for ($i = 0; $i < count($tab); $i++) {
	// 					$msg_ = $msg_ . "" . $tab[$i];
	// 				}


	// 				$driver_id = DB::table('tj_vehicule')
	// 					->where('id_type_vehicule', $vehicle_id)->get()
	// 					->pluck('id_conducteur')->toArray();

	// 				$busy_drivers =  Requests::whereIn('statut', ["on ride", "confirmed"])
	// 					->whereNotnull('id_conducteur')
	// 					->where('id_conducteur', '!=', '')
	// 					->where('id_conducteur', '!=', null)
	// 					->get()->pluck("id_conducteur")->toArray();

	// 				array_unique($busy_drivers);

	// 				$message = array("body" => $msg_, "title" => $title, "sound" => "order_received", "tag" => "ridenewrider");


	// 				$fcm_tokens = DB::table('tj_conducteur')->selectRaw("id, fcm_id, latitude, longitude,
	//                 ( 6371 * acos( cos( radians(?) ) *
	//                 cos( radians( latitude ) )
	//                 * cos( radians( longitude ) - radians(?)
	//                 ) + sin( radians(?) ) *
	//                 sin( radians( latitude ) ) )
	//                 ) AS distance", [$lat1, $lng1, $lat1])
	// 					->where('fcm_id', '!=', '')
	// 					->where('driver_type', 'In house driver')
	// 					->where('online', 'yes')
	// 					->where('statut', 'yes');
	// 				if (is_array($busy_drivers) &&  sizeof($busy_drivers) > 0) {
	// 					$fcm_tokens =  $fcm_tokens->whereNotIn("id", $busy_drivers);
	// 				}

	// 				$fcm_tokens =   $fcm_tokens->having("distance", "<", $under_radious)

	// 					->orderBy("distance", 'asc')
	// 					->get();


	// 				$ride = ['ride_id' => $id, 'status' => 'new'];
	// 				if ($fcm_tokens) {
	// 					foreach ($fcm_tokens as $fcm_token) {
	// 						$check = RequestToDriver::create(['driver_id' => $fcm_token->id, 'request_id' => $id]);

	// 						if ($version) {
	// 							Log::info("Sending new type of notification", [
	// 								'method' => 'sendNotsendNotification_newification',
	// 								'fcm_id' => $fcm_token->fcm_id,
	// 								'message' => $message,
	// 								'ride_id' => $ride->id ?? null
	// 							]);
	// 							GcmController::sendNotification_new($fcm_token->fcm_id, $message, $ride);
	// 						} else {
	// 							Log::info("Sending legacy notification", [
	// 								'method' => 'sendNotification',
	// 								'fcm_id' => $fcm_token->fcm_id,
	// 								'message' => $message,
	// 								'ride_id' => $ride->id ?? null
	// 							]);
	// 							GcmController::sendNotification($fcm_token->fcm_id, $message, $ride);
	// 						}
	// 					}
	// 				}

	// 				$fcm_tokens = DB::table('tj_conducteur')->selectRaw("id, fcm_id, latitude, longitude,
	//                 ( 6371 * acos( cos( radians(?) ) *
	//                 cos( radians( latitude ) )
	//                 * cos( radians( longitude ) - radians(?)
	//                 ) + sin( radians(?) ) *
	//                 sin( radians( latitude ) ) )
	//                 ) AS distance", [$lat1, $lng1, $lat1])
	// 					->where('fcm_id', '!=', '')
	// 					->where('driver_type', 'Outside driver')
	// 					->where('amount', '>=', $minumum_wallet)
	// 					->where('online', 'yes')
	// 					->where('statut', 'yes');

	// 				if (is_array($busy_drivers) && sizeof($busy_drivers) > 0) {
	// 					$fcm_tokens =  $fcm_tokens->whereNotIn("id", $busy_drivers);
	// 				}
	// 				$fcm_tokens =   $fcm_tokens->having("distance", "<", $under_radious)

	// 					->orderBy("distance", 'asc')
	// 					//->limit(10)
	// 					->get();

	// 				SendNotificationJob::dispatch($fcm_tokens, $message, $id, $ride)->delay(now()->addSeconds(30));
	// 			}
	// 		}

	// 		dd($id);

	// 		if ($id > 0) {
	// 			$get_user = Requests::where('id', $id)->first();
	// 			$row = $get_user->toArray();

	// 			$row['stops'] = json_decode($row['stops'], true);
	// 			$row['user_info'] = json_decode($row['user_info'], true);
	// 			if ($row['trajet'] != '') {
	// 				if (file_exists(public_path('images/recu_trajet_course/' . '/' . $row['trajet']))) {
	// 					$image_user = asset('images/recu_trajet_course/') . '/' . $row['trajet'];
	// 				} else {
	// 					$image_user = asset('assets/images/placeholder_image.jpg');
	// 				}
	// 				$row['trajet'] = $image_user;
	// 			}
	// 			$row['remaining_payment'] = $row['montant'] - $row['advance_payment'];

	// 			//AUTO CAPTURE PAYMENT

	// 			$sql = Requests::where('id', $id)->first();

	// 			if ($sql->advance_payment != 0 && ($sql->razorpay_transaction_id != NULL || $sql->razorpay_transaction_id != "")) {
	// 				$this->capture_payment($sql);
	// 			}

	// 			//END

	// 			$output[] = $row;
	// 			$response['success'] = 'success';
	// 			$response['error'] = null;
	// 			$response['message'] = 'Successfully created';
	// 			$response['data'] = $output;
	// 		} else {
	// 			return redirect()->back()->withErrors(['Failed']);
	// 		}
	// 	} else {
	// 		return redirect()->back()->withErrors(['some field required']);
	// 	}


	// 	return redirect('rides/new');
	// }

}
