<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use App\Models\UserApp;
use App\Models\Driver;
use App\Models\Currency;
use App\Models\Country;
use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;

class DiscountController extends Controller
{

    public function __construct()
    {
        $this->limit = 20;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    // public function discountList(Request $request)
    // {
    //   $rideType =$request->get('ride_type');

    //   $today = Carbon::now();

    //   if(!empty($rideType) && $rideType=="parcel"){
    //       $sql = DB::table('tj_discount')
    //       ->where('statut','=','yes')
    //       ->where('coupon_type','=','Parcel')
    //       ->where('expire_at','>=',$today)
    //       ->get();
    //     }else{
    //       $sql = DB::table('tj_discount')
    //       ->where('statut','=','yes')
    //       ->where('coupon_type','=','Ride')
    //       ->where('expire_at','>=',$today)
    //       ->get();
    //     }

    //     if(!empty($sql)){
    //         foreach($sql as $row){
    //             $row->id=(string)$row->id;
    //             $row->expire_at= date('d F Y',strtotime($row->expire_at)).' '. date('h:i A',strtotime($row->expire_at));
    //             $output[] = $row;
    //         }

    //         if(!empty($output)){
    //             $response['success']= 'success';
    //             $response['error']= null;
    //             $response['message']= 'successfully';
    //             $response['data'] = $output;
    //         }else{
    //           $response['success']= 'Failed';
    //           $response['error']= 'No Data Found';
    //           $response['message']= null;
    //         }

    //     } else{
    //         $response['success']= 'Failed';
    //         $response['error']= 'Not Found';
    //     }

    //     return response()->json($response);
    // }

    public function discountList(Request $request)
    {
        $rideType = $request->get('ride_type');
        $user_id = $request->get('id_user_app');

        if (!$user_id) {
            return response()->json([
                'success' => 'Failed',
                'message' => 'User ID not provided',
            ], 400);
        }

        // Check if user exists
        $user_exists = DB::table('tj_user_app')->where('id', $user_id)->exists();
        if (!$user_exists) {
            return response()->json([
                'success' => 'Failed',
                'message' => 'User not found',
            ], 404);
        }

        $today = Carbon::now();

        // Get all valid discounts
        $query = DB::table('tj_discount')
            ->where('statut', 'yes')
            ->where('apply_for', '!=', 'completed')
            ->where('expire_at', '>=', $today);

        if (!empty($rideType) && $rideType === 'parcel') {
            $query->where('coupon_type', 'Parcel');
        } else {
            $query->where('coupon_type', 'Ride');
        }

        $all_coupons = $query->get();
        $valid_coupons = [];

        foreach ($all_coupons as $coupon) {
            // Count how many times this user used this specific coupon

            // if($rideType === 'parcel'){
            //   $usage_count = DB::table('user_coupons')
            //     ->where('user_id', $user_id)
            //     ->where('coupon_id', $coupon->id)
            //     ->count();
            // }

            $usage_count = DB::table('user_coupons')
                ->where('user_id', $user_id)
                ->where('coupon_id', $coupon->id)
                ->count();

            // Only include coupon if user hasn't reached the limit
            if ($usage_count < $coupon->number_time_allowed) {
                $coupon->remaining_count = $coupon->number_time_allowed - $usage_count;
                $coupon->id = (string) $coupon->id;
                $coupon->expire_at = date('d F Y', strtotime($coupon->expire_at)) . ' ' . date('h:i A', strtotime($coupon->expire_at));
                $discription = $coupon->discription;
                $coupon->discription = $coupon->title;

                $coupon->title = $discription;

                $valid_coupons[] = $coupon;
            }
        }

        if (!empty($valid_coupons)) {
            return response()->json([
                'success' => 'success',
                'error' => null,
                'message' => 'Coupons retrieved successfully',
                'data' => $valid_coupons,
            ]);
        } else {
            return response()->json([
                'success' => 'Failed',
                'error' => 'No valid coupons available for your usage limit.',
                'message' => null,
            ]);
        }
    }


    public function completedDiscountList(Request $request)
    {
        $user_id = $request->get('id_user_app');
        $type = $request->get('type');

        if (!$user_id) {
            return response()->json([
                'success' => 'Failed',
                'message' => 'User ID not provided',
            ], 400);
        }

        // Check if user exists
        $user_exists = DB::table('tj_user_app')->where('id', $user_id)->exists();
        if (!$user_exists) {
            return response()->json([
                'success' => 'Failed',
                'message' => 'User not found',
            ], 404);
        }

        // $today = Carbon::now();
        $today = Carbon::now()->format('Y-m-d');


        if ($type == 'both') {
            // $coupons = DB::table('assign_coupon_to_users as acu')
            //     ->join('tj_discount as d', 'acu.coupon_id', '=', 'd.id')
            //     ->where('acu.user_id', $user_id)
            //     ->where('d.apply_for', 'completed')
            //     ->where('acu.used', 0)
            //     ->whereDate('d.expire_at', '>=', $today)
            //     ->select('d.*', 'd.title as discription',  'acu.id as assign_id',   'acu.used')
            //     ->get();

            $coupons = DB::table('assign_coupon_to_users as acu')                
                ->where('acu.user_id', $user_id)                
                ->select(                    
                    'acu.*',
                    'acu.title as discription',
                    'acu.id as assign_id',                  
                    'acu.get_discount as discount' , 
                    'acu.discount_type as type' , 
                    DB::raw("
                    CASE 
                        WHEN acu.expire_at < '{$today}' THEN 1
                            ELSE acu.used
                        END as modify_used
                    ")
                )
                ->get();

        } elseif ($type == 'used') {
            $coupons = DB::table('assign_coupon_to_users as acu')                
                ->where('acu.user_id', $user_id)                
                ->where('acu.used', 1)
                ->whereDate('acu.expire_at', '>=', $today)
                ->select('acu.*', 'acu.title as discription',  'acu.id as assign_id',  'acu.get_discount as discount' ,'acu.discount_type as type' , )
                ->get();
        } elseif ($type == 'unused') {
            $coupons = DB::table('assign_coupon_to_users as acu')                
                ->where('acu.user_id', $user_id)                
                ->where('acu.used', 0)
                ->whereDate('acu.expire_at', '>=', $today)
                ->select('acu.*', 'acu.title as discription', 'acu.id as assign_id', 'acu.display_code',  'acu.get_discount as discount' ,'acu.discount_type as type' , )
                ->get();
        } else {
            $coupons = DB::table('assign_coupon_to_users as acu')
                ->where('acu.user_id', $user_id)                
                ->where('acu.used', 0)
                ->whereDate('acu.expire_at', '>=', $today)
                ->select('acu.*', 'acu.title as discription', 'acu.id as assign_id',  'acu.get_discount as discount' ,'acu.discount_type as type'  )
                ->get();
        }

        // Get all completed coupons assigned to this user


        $valid_coupons = [];

        // foreach ($coupons as $coupon) {

        // Count how many times this user used this coupon
        // $usage_count = DB::table('user_coupons')
        //     ->where('user_id', $user_id)
        //     ->where('coupon_id', $coupon->id)
        //     ->count();

        // Only include coupon if user hasn't reached the limit
        // if ($usage_count < $coupon->number_time_allowed) {
        //     $coupon->remaining_count = $coupon->number_time_allowed - $usage_count;
        //     $coupon->id = (string) $coupon->id;
        //     $coupon->expire_at = date('d F Y h:i A', strtotime($coupon->expire_at));
        //     $valid_coupons[] = $coupon;
        // }
        // }

        if ($coupons) {
            return response()->json([
                'success' => 'success',
                'error' => null,
                'message' => 'Completed coupons retrieved successfully',
                'data' => $coupons,
            ]);
        } else {
            return response()->json([
                'success' => 'Failed',
                'error' => 'No completed coupons available for this user.',
                'message' => null,
            ]);
        }
    }
}
