<?php

namespace App\Http\Controllers\api\v1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\DriverVehicleLayout;
use App\Models\Driver;
use App\Models\DriverVehicleLayoutName;
use App\Models\SeatSharingRequestStops;
use App\Models\SeatSharingRequest;
use App\Models\SeatSharingRequestPrice;
use App\Models\SeatSharingVehicleLayout;
use App\Models\SeatSharingRequestStopsPoint;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use App\Models\TjConducteur;
use App\Http\Controllers\API\v1\GcmController;
use Illuminate\Support\Facades\Log;

class ApiController extends Controller
{

  //  public function __construct()
  //  {

  //  }
  /**
   * Display a listing of the resource.
   *
   * @return \Illuminate\Http\Response
   */

  

public function seatSharingRequest(Request $request)
{
    $layoutId = $request->layoutId ?? null;

    DB::beginTransaction();

    try {
        if (is_null($layoutId) || empty($layoutId)) {
            $DriverVehicleLayoutName = DriverVehicleLayoutName::create([
                'driver_id' => $request->driver_id,
                'vehicle_name' => $request->vehicle_name,
                'vehicle_number' => $request->vehicle_number
            ]);

            $layoutId = $DriverVehicleLayoutName->id;
        } else {
            $DriverVehicleLayoutName = DriverVehicleLayoutName::findOrFail($layoutId);
            // return response()->json($DriverVehicleLayoutName);
        }

        $stops = $request->stops;

        $SeatSharingRequest = SeatSharingRequest::create([
            'driver_id' => $request->driver_id,
        //   'departure_time' => Carbon::parse($request->departure_time)->format('Y-m-d H:i:s'),
            'departure_time' => $request->departure_time,
            'from' => $stops[0]['name'] ?? null,
            'to' => $stops[count($stops) - 1]['name'] ?? null,
            'stops' => implode(',', array_map(fn($s) => trim($s['name']), $stops))
        ]);

        if (is_null($request->layoutId)) {
                        // return response()->json('if');

            foreach ($request->seats as $seat) {
                $DriverVehicleLayout = DriverVehicleLayout::create([
                    'driver_vehicle_layout_name_id' => $layoutId,
                    'label' => $seat['label'],
                    'row' => $seat['row'],
                    'position' => $seat['position'],
                    'is_driver' => $seat['is_driver'],
                ]);

                  SeatSharingVehicleLayout::create([
                        'seat_sharing_request_id' => $SeatSharingRequest->id,
                        'driver_vehicle_layout_name_id' => $layoutId,
                        'driver_vehicle_layout_id' => $DriverVehicleLayout->id,
                        'is_driver' => $seat['is_driver'],
                        'is_booked' => $seat['is_booked'],
                        'booked_by' => $seat['booked_by'],
                    ]);

                   
            }
        } else {
            $existingLayouts = DriverVehicleLayout::where('driver_vehicle_layout_name_id', $layoutId)->get();
            // return response()->json($existingLayouts);
            foreach ($request->seats as $seat) {
                $matchingLayout = $existingLayouts->firstWhere('id', $seat['driver_vehicle_layout_id']);

                if ($matchingLayout) {
                    SeatSharingVehicleLayout::create([
                        'seat_sharing_request_id' => $SeatSharingRequest->id,
                        'driver_vehicle_layout_name_id' => $layoutId,
                        'driver_vehicle_layout_id' => $matchingLayout->id,
                        'is_driver' => $seat['is_driver'],
                        'is_booked' => $seat['is_booked'],
                        'booked_by' => $seat['booked_by'],
                    ]);
                }
            }
        }

        foreach ($stops as $stop) {
          $stopsData =   SeatSharingRequestStops::create([
                'seat_sharing_request_id' => $SeatSharingRequest->id,
                'stop_id' => $stop['id'],
                'name' => $stop['name'],
                'latitude' => $stop['latitude'],
                'longitude' => $stop['longitude'],
                'order' => $stop['order'],
            ]);

               if (!empty($stop['stop_points'])) {
                     foreach ($stop['stop_points'] as $stopPoint) {
                            SeatSharingRequestStopsPoint::create([
                                'seat_sharing_request_stops_id' => $stopsData->id,
                                'stop_points_id' => $stopPoint['stop_points_id'],
                                'name' => $stopPoint['name'],
                                'latitude' => $stopPoint['latitude'],
                                'longitude' => $stopPoint['longitude'],
                                'type' => $stopPoint['type'], // 'pickup', 'drop', 'both'
                            ]);
                        }
                    }

        }

        foreach ($request->pricing as $price) {
            SeatSharingRequestPrice::create([
                'seat_sharing_request_id' => $SeatSharingRequest->id,
                'fromStopId' => $price['fromStopId'],
                'toStopId' => $price['toStopId'],
                'price' => $price['price']
            ]);
        }

        DB::commit();

        return response()->json([
            'status' => true,
            'message' => 'Seat sharing request created successfully',
        ]);
    } catch (\Exception $e) {
        DB::rollBack();

        return response()->json([
            'status' => false,
            'message' => 'Something went wrong',
            'error' => $e->getMessage()
        ], 500);
    }
}


  public function getDriverVehicleLayout($driverId)
  {
      try {
          $DriverVehicleLayoutNames = DriverVehicleLayoutName::with('driverVehicleLayouts')
              ->where('driver_id', $driverId)
              ->get();

          return response()->json([
              'status' => true,
              'data' => $DriverVehicleLayoutNames
          ]);
      } catch (\Exception $e) {
          return response()->json([
              'status' => false,
              'message' => 'Failed to fetch driver vehicle layouts',
              'error' => $e->getMessage()
          ], 500);
      }
  }


    public function getDriverRideList($driverId)
    {
        try {
            if (empty($driverId)) {
                return response()->json([
                    'status' => false,
                    'message' => 'Driver ID is required',
                    'data' => []
                ], 400);
            }

            $data = SeatSharingRequest::where('driver_id', $driverId)
                                    ->where('status', 1)
                                    ->where('is_delete', 0)
                                    ->get();

            if ($data->isEmpty()) {
                return response()->json([
                    'status' => false,
                    'message' => 'No rides found for this driver.',
                    'data' => []
                ]);
            }

            return response()->json([
                'status' => true,
                'message' => 'Rides fetched successfully.',
                'data' => $data
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => 'An error occurred: ' . $e->getMessage(),
                'data' => []
            ], 500);
        }
    }
//     public function getDriverRidedetail(Request $request ,$rideId)
//     {
//         // return response()->json($request->all());
//         $from_stop_id = $request->from_stop_id;
//         $to_stop_id = $request->to_stop_id;
//         try {
//             if (empty($rideId)) {
//                 return response()->json([
//                     'status' => false,
//                     'message' => 'Ride ID is required.',
//                     'data' => []
//                 ], 400);
//             }

//             // Eager load relationships
//           $ride = SeatSharingRequest::with([
//                 'seatSharingRequestStops',
//                 'seatSharingRequestPrice',
//                 'driver'
//             ])->find($rideId);
            

//             $seatLayout = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
//                 // ->where(function ($query) use ($from_stop_id) {
//                 //     $query->where('user_from_stop_id', '!=', $from_stop_id)
//                 //         ->orWhereNull('user_from_stop_id');
//                 // })
//                 // ->where(function ($query) use ($to_stop_id) {
//                 //     $query->where('user_to_stop_id', '!=', $to_stop_id)
//                 //         ->orWhereNull('user_to_stop_id');
//                 // })
//                 //   ->where(function ($query) use ($from_stop_id, $to_stop_id) {
//                 //     $query->where(function ($q) use ($from_stop_id, $to_stop_id) {
//                 //         $q->where(function ($subQuery) use ($from_stop_id) {
//                 //             $subQuery->where('user_from_stop_id', '!=', $from_stop_id)
//                 //                     ->orWhereNull('user_from_stop_id');
//                 //         })->where(function ($subQuery) use ($to_stop_id) {
//                 //             $subQuery->where('user_to_stop_id', '!=', $to_stop_id)
//                 //                     ->orWhereNull('user_to_stop_id');
//                 //         });
//                 //     })->orWhere('is_booked', 0);
//                 // })
//                             ->leftJoin('driver_vehicle_layout_name as dvln', 'seat_sharing_vehicle_layout.driver_vehicle_layout_name_id', '=', 'dvln.id')
//                 ->leftJoin('driver_vehicle_layout', 'seat_sharing_vehicle_layout.driver_vehicle_layout_id', '=', 'driver_vehicle_layout.id')
//                 ->leftJoin('tj_user_app', 'seat_sharing_vehicle_layout.booked_by', '=', 'tj_user_app.id')
//                 ->select(
//                     'seat_sharing_vehicle_layout.driver_vehicle_layout_name_id',
//                     'seat_sharing_vehicle_layout.driver_vehicle_layout_id',
//                     'seat_sharing_vehicle_layout.is_driver',
//                     'seat_sharing_vehicle_layout.is_booked',
//                     'seat_sharing_vehicle_layout.booked_by',
//                     'seat_sharing_vehicle_layout.advance_payment',
//                     'seat_sharing_vehicle_layout.razorpay_transaction_id',
//                     'seat_sharing_vehicle_layout.user_from_stop_id',
//                     'seat_sharing_vehicle_layout.user_to_stop_id',
//                     'driver_vehicle_layout.label',
//                     'driver_vehicle_layout.row',
//                     'driver_vehicle_layout.position',
//                     'dvln.vehicle_name',
//                     'dvln.vehicle_number',
//                      DB::raw("CONCAT(tj_user_app.nom, ' ', tj_user_app.prenom) as user_name"),
//                         'tj_user_app.phone as user_phone'
//                 )
//                 ->get();

//             $vehicleInfo = $seatLayout->first();
//             $vehicleName = $vehicleInfo->vehicle_name ?? null;
//             $vehicleNumber = $vehicleInfo->vehicle_number ?? null;

//             // $seatLayout = $seatLayout->map(function ($item) {
//             //     if (empty($item->booked_by)) {
//             //         $item->booked_by = null;
//             //     } else {
//             //         $item->booked_by = (string) $item->booked_by;
//             //     }
//             //     unset($item->vehicle_name, $item->vehicle_number);
//             //     return $item;
//             // });

//             // $seatLayout = $seatLayout->map(function ($item) use ($from_stop_id, $to_stop_id) {
//             //     $isActuallyBooked = $item->is_booked == 1;

//             //     $sameStops = (
//             //         $item->user_from_stop_id == $from_stop_id &&
//             //         $item->user_to_stop_id == $to_stop_id
//             //     );

//             //     if ($isActuallyBooked && !$sameStops) {
//             //         $item->is_booked = 0;
//             //         $item->booked_by = null;
//             //         $item->advance_payment = null;
//             //         $item->razorpay_transaction_id = null;
//             //         $item->user_name = null;
//             //         $item->user_phone = null;
//             //     } else {
//             //         $item->booked_by = empty($item->booked_by) ? null : (string) $item->booked_by;
//             //     }

//             //     unset($item->vehicle_name, $item->vehicle_number);

//             //     unset($item->user_from_stop_id, $item->user_to_stop_id);

//             //     return $item;
//             // });

//           $seatLayout = $seatLayout->groupBy('driver_vehicle_layout_id')->map(function ($group) use ($from_stop_id, $to_stop_id) {
//     // Try to find seat with matching stops AND booked
//     $matchedBookedSeat = $group->first(function ($item) use ($from_stop_id, $to_stop_id) {
//         return $item->user_from_stop_id == $from_stop_id 
//             && $item->user_to_stop_id == $to_stop_id
//             && $item->is_booked == 1;
//     });

//     if ($matchedBookedSeat) {
//         return $matchedBookedSeat;
//     }

//     // If no booked seat with exact stop match, try any seat with exact stop match
//     $matchedSeat = $group->first(function ($item) use ($from_stop_id, $to_stop_id) {
//         return $item->user_from_stop_id == $from_stop_id 
//             && $item->user_to_stop_id == $to_stop_id;
//     });

//     if ($matchedSeat) {
//         return $matchedSeat;
//     }

//     // Fallback: booked seat if any
//     $bookedSeat = $group->firstWhere('is_booked', 1);
//     if ($bookedSeat) {
//         return $bookedSeat;
//     }

//     // Last fallback: first seat (unbooked or otherwise)
//     return $group->first();
// })->values();


//             $seatLayout = $seatLayout->map(function ($item) use ($from_stop_id, $to_stop_id) {
//     $isActuallyBooked = $item->is_booked == 1;

//     $sameStops = (
//         $item->user_from_stop_id == $from_stop_id ||
//         $item->user_to_stop_id == $to_stop_id
//     );

//     if ($isActuallyBooked && !$sameStops) {
//         $item->is_booked = 0;
//         $item->booked_by = null;
//         $item->advance_payment = null;
//         $item->razorpay_transaction_id = null;
//         $item->user_name = null;
//         $item->user_phone = null;
//     } elseif ($isActuallyBooked && $sameStops) {
//         $item->booked_by = (string) $item->booked_by;
//     } else {
//         $item->booked_by = null;
//     }

//     unset($item->vehicle_name, $item->vehicle_number);
//     unset($item->user_from_stop_id, $item->user_to_stop_id);

//     return $item;
// });

//             $ride->seat_sharing_vehicle_layout = $seatLayout;

//             $ride->vehicle_name = $vehicleName;
//             $ride->vehicle_number = $vehicleNumber;

//             if (!$ride) {
//                 return response()->json([
//                     'status' => false,
//                     'message' => 'Ride not found.',
//                     'data' => []
//                 ], 200);
//             }

//             return response()->json([
//                 'status' => true,
//                 'message' => 'Ride details fetched successfully.',
//                 'data' => $ride,
//             ]);

//         } catch (\Exception $e) {
//             return response()->json([
//                 'status' => false,
//                 'message' => 'An error occurred: ' . $e->getMessage(),
//                 'data' => []
//             ], 500);
//         }
//     }

// some chnages code 


// public function getDriverRidedetail(Request $request ,$rideId)
// {
//     $from_stop_id = $request->from_stop_id;
//     $to_stop_id = $request->to_stop_id;
//     try {
//         if (empty($rideId)) {
//             return response()->json([
//                 'status' => false,
//                 'message' => 'Ride ID is required.',
//                 'data' => []
//             ], 400);
//         }

//         // Load ride with stops etc.
//         $ride = SeatSharingRequest::with([
//             'seatSharingRequestStops',
//             'seatSharingRequestPrice',
//             'driver'
//         ])->find($rideId);

//         if (!$ride) {
//             return response()->json([
//                 'status' => false,
//                 'message' => 'Ride not found.',
//                 'data' => []
//             ], 200);
//         }

//         // Extract stops in order
//         $stops = $ride->seatSharingRequestStops->sortBy('id')->pluck('id')->values();

//         // Find indices of from and to stops
//         $fromIndex = $stops->search($from_stop_id);
//         $toIndex = $stops->search($to_stop_id);

//         if ($fromIndex === false || $toIndex === false) {
//             // Invalid stop IDs
//             return response()->json([
//                 'status' => false,
//                 'message' => 'Invalid from_stop_id or to_stop_id.',
//                 'data' => []
//             ], 400);
//         }

//         // Get all stops between from and to inclusive
//         if ($fromIndex <= $toIndex) {
//             $stopsBetween = $stops->slice($fromIndex, $toIndex - $fromIndex + 1);
//         } else {
//             // If from is after to, reverse slice
//             $stopsBetween = $stops->slice($toIndex, $fromIndex - $toIndex + 1);
//         }

//         $seatLayout = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
//             ->leftJoin('driver_vehicle_layout_name as dvln', 'seat_sharing_vehicle_layout.driver_vehicle_layout_name_id', '=', 'dvln.id')
//             ->leftJoin('driver_vehicle_layout', 'seat_sharing_vehicle_layout.driver_vehicle_layout_id', '=', 'driver_vehicle_layout.id')
//             ->leftJoin('tj_user_app', 'seat_sharing_vehicle_layout.booked_by', '=', 'tj_user_app.id')
//             ->select(
//                 'seat_sharing_vehicle_layout.driver_vehicle_layout_name_id',
//                 'seat_sharing_vehicle_layout.driver_vehicle_layout_id',
//                 'seat_sharing_vehicle_layout.is_driver',
//                 'seat_sharing_vehicle_layout.is_booked',
//                 'seat_sharing_vehicle_layout.booked_by',
//                 'seat_sharing_vehicle_layout.advance_payment',
//                 'seat_sharing_vehicle_layout.razorpay_transaction_id',
//                 'seat_sharing_vehicle_layout.user_from_stop_id',
//                 'seat_sharing_vehicle_layout.user_to_stop_id',
//                 'driver_vehicle_layout.label',
//                 'driver_vehicle_layout.row',
//                 'driver_vehicle_layout.position',
//                 'dvln.vehicle_name',
//                 'dvln.vehicle_number',
//                 DB::raw("CONCAT(tj_user_app.nom, ' ', tj_user_app.prenom) as user_name"),
//                 'tj_user_app.phone as user_phone'
//             )
//             ->get();

//         $vehicleInfo = $seatLayout->first();
//         $vehicleName = $vehicleInfo->vehicle_name ?? null;
//         $vehicleNumber = $vehicleInfo->vehicle_number ?? null;

//         // Grouping logic with new stop range check
//         $seatLayout = $seatLayout->groupBy('driver_vehicle_layout_id')->map(function ($group) use ($stopsBetween) {
//             // Find booked seat where both from and to stops are in stopsBetween
//             $matchedBookedSeat = $group->first(function ($item) use ($stopsBetween) {
//                 return $item->is_booked == 1
//                     && $stopsBetween->contains($item->user_from_stop_id)
//                     && $stopsBetween->contains($item->user_to_stop_id)
//                     // Ensure order of stops: from < to in the sequence
//                     && array_search($item->user_from_stop_id, $stopsBetween->toArray()) 
//                        < array_search($item->user_to_stop_id, $stopsBetween->toArray());
//             });

//             if ($matchedBookedSeat) {
//                 return $matchedBookedSeat;
//             }

//             // Fallback: any seat where stops fall in stopsBetween
//             $matchedSeat = $group->first(function ($item) use ($stopsBetween) {
//                 return $stopsBetween->contains($item->user_from_stop_id)
//                     && $stopsBetween->contains($item->user_to_stop_id)
//                     && array_search($item->user_from_stop_id, $stopsBetween->toArray()) 
//                        < array_search($item->user_to_stop_id, $stopsBetween->toArray());
//             });

//             if ($matchedSeat) {
//                 return $matchedSeat;
//             }

//             // Fallback: booked seat if any
//             $bookedSeat = $group->firstWhere('is_booked', 1);
//             if ($bookedSeat) {
//                 return $bookedSeat;
//             }

//             // Last fallback: first seat
//             return $group->first();
//         })->values();

//         $seatLayout = $seatLayout->map(function ($item) use ($stopsBetween) {
//             $isActuallyBooked = $item->is_booked == 1;

//             $sameStops = (
//                 $stopsBetween->contains($item->user_from_stop_id) ||
//                 $stopsBetween->contains($item->user_to_stop_id)
//             );

//             if ($isActuallyBooked && !$sameStops) {
//                 $item->is_booked = 0;
//                 $item->booked_by = null;
//                 $item->advance_payment = null;
//                 $item->razorpay_transaction_id = null;
//                 $item->user_name = null;
//                 $item->user_phone = null;
//             } elseif ($isActuallyBooked && $sameStops) {
//                 $item->booked_by = (string) $item->booked_by;
//             } else {
//                 $item->booked_by = null;
//             }

//             unset($item->vehicle_name, $item->vehicle_number);
//             unset($item->user_from_stop_id, $item->user_to_stop_id);

//             return $item;
//         });

//         $ride->seat_sharing_vehicle_layout = $seatLayout;
//         $ride->vehicle_name = $vehicleName;
//         $ride->vehicle_number = $vehicleNumber;

//         return response()->json([
//             'status' => true,
//             'message' => 'Ride details fetched successfully.',
//             'data' => $ride,
//         ]);

//     } catch (\Exception $e) {
//         return response()->json([
//             'status' => false,
//             'message' => 'An error occurred: ' . $e->getMessage(),
//             'data' => []
//         ], 500);
//     }
// }

public function getDriverRidedetail(Request $request, $rideId)
{
    $from_stop_id = $request->from_stop_id;
    $to_stop_id = $request->to_stop_id;

    try {
        if (empty($rideId)) {
            return response()->json([
                'status' => false,
                'message' => 'Ride ID is required.',
                'data' => []
            ], 400);
        }

        $ride = SeatSharingRequest::with([
            'seatSharingRequestStops.seatSharingRequestStopsPoints',
            'seatSharingRequestPrice',
            'driver'
        ])->find($rideId);

        if (!$ride) {
            return response()->json([
                'status' => false,
                'message' => 'Ride not found.',
                'data' => []
            ], 200);
        }

        $stops = $ride->seatSharingRequestStops->sortBy('id')->pluck('id')->values();

        $fromIndex = $stops->search($from_stop_id);
        $toIndex = $stops->search($to_stop_id);

        if ($fromIndex === false || $toIndex === false) {
            return response()->json([
                'status' => false,
                'message' => 'Invalid from_stop_id or to_stop_id.',
                'data' => []
            ], 400);
        }

        if ($fromIndex <= $toIndex) {
            $stopsBetween = $stops->slice($fromIndex, $toIndex - $fromIndex + 1);
        } else {
            $stopsBetween = $stops->slice($toIndex, $fromIndex - $toIndex + 1);
        }

        $seatLayout = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
            ->leftJoin('driver_vehicle_layout_name as dvln', 'seat_sharing_vehicle_layout.driver_vehicle_layout_name_id', '=', 'dvln.id')
            ->leftJoin('driver_vehicle_layout', 'seat_sharing_vehicle_layout.driver_vehicle_layout_id', '=', 'driver_vehicle_layout.id')
            ->leftJoin('tj_user_app', 'seat_sharing_vehicle_layout.booked_by', '=', 'tj_user_app.id')
            ->select(
                'seat_sharing_vehicle_layout.driver_vehicle_layout_name_id',
                'seat_sharing_vehicle_layout.driver_vehicle_layout_id',
                'seat_sharing_vehicle_layout.is_driver',
                'seat_sharing_vehicle_layout.is_booked',
                'seat_sharing_vehicle_layout.booked_by',
                'seat_sharing_vehicle_layout.advance_payment',
                'seat_sharing_vehicle_layout.razorpay_transaction_id',
                'seat_sharing_vehicle_layout.user_from_stop_id',
                'seat_sharing_vehicle_layout.user_to_stop_id',
                'driver_vehicle_layout.label',
                'driver_vehicle_layout.row',
                'driver_vehicle_layout.position',
                'dvln.vehicle_name',
                'dvln.vehicle_number',
                DB::raw("CONCAT(tj_user_app.nom, ' ', tj_user_app.prenom) as user_name"),
                'tj_user_app.phone as user_phone'
            )
            ->get();
 Log::info('seatLayout', [
            'seatLayout' => $seatLayout,
          
        ]);
        $vehicleInfo = $seatLayout->first();
        $vehicleName = $vehicleInfo->vehicle_name ?? null;
        $vehicleNumber = $vehicleInfo->vehicle_number ?? null;

//         $seatLayout = $seatLayout->groupBy('driver_vehicle_layout_id')->map(function ($group) {
//             return $group->first();
//         })->values();

//         $seatLayout = $seatLayout->map(function ($item) use ($from_stop_id, $to_stop_id) {
//             $userFrom = $item->user_from_stop_id;
//             $userTo = $item->user_to_stop_id;

//             $isActuallyBooked = $item->is_booked == 1;
//   Log::info('Seat marked as available due to no overlap', [
//             'seat_id' => $item->driver_vehicle_layout_id,
//             'user_from_stop_id' => $userFrom,
//             'user_to_stop_id' => $userTo,
//             'requested_from_stop_id' => $from_stop_id,
//             'requested_to_stop_id' => $to_stop_id,
//         ]);
//             if (
//                 $isActuallyBooked &&
//                 (
//                     ($userTo !== null && $userTo <= $from_stop_id) ||
//                     ($userFrom !== null && $to_stop_id <= $userFrom)
//                 )
//             ) {
           
//                 $item->is_booked = 0;
//                 $item->booked_by = null;
//                 $item->advance_payment = null;
//                 $item->razorpay_transaction_id = null;
//                 $item->user_name = null;
//                 $item->user_phone = null;
//             } elseif ($isActuallyBooked) {
//                 $item->booked_by = (string) $item->booked_by;
//             } else {
//                 $item->booked_by = null;
//             }

//             unset($item->vehicle_name, $item->vehicle_number);
//             unset($item->user_from_stop_id, $item->user_to_stop_id);

//             return $item;
//         });

        $seatLayout = $seatLayout->groupBy('driver_vehicle_layout_id')->map(function ($group) use ($from_stop_id, $to_stop_id) {
            $isBooked = false;
            $activeBooking = null;

            foreach ($group as $item) {
                $userFrom = $item->user_from_stop_id;
                $userTo = $item->user_to_stop_id;

                if (
                    $item->is_booked == 1 &&
                    !(
                        ($userTo !== null && $userTo <= $from_stop_id) ||
                        ($userFrom !== null && $to_stop_id <= $userFrom)
                    )
                ) {
                    // Overlapping booking found
                    $isBooked = true;
                    $activeBooking = $item;
                    break;
                }
            }

            if ($isBooked && $activeBooking !== null) {
                $activeBooking->booked_by = (string) $activeBooking->booked_by;
                // clean up fields as needed
                unset($activeBooking->vehicle_name, $activeBooking->vehicle_number);
                unset($activeBooking->user_from_stop_id, $activeBooking->user_to_stop_id);
                return $activeBooking;
            } else {
                // No overlap: mark as available (take any item as base)
                $base = $group->first();
                $base->is_booked = 0;
                $base->booked_by = null;
                $base->advance_payment = null;
                $base->razorpay_transaction_id = null;
                $base->user_name = null;
                $base->user_phone = null;
                unset($base->vehicle_name, $base->vehicle_number);
                unset($base->user_from_stop_id, $base->user_to_stop_id);
                return $base;
            }
        })->values();


        $ride->seat_sharing_vehicle_layout = $seatLayout;
        $ride->vehicle_name = $vehicleName;
        $ride->vehicle_number = $vehicleNumber;

        return response()->json([
            'status' => true,
            'message' => 'Ride details fetched successfully.',
            'data' => $ride,
        ]);

    } catch (\Exception $e) {
        return response()->json([
            'status' => false,
            'message' => 'An error occurred: ' . $e->getMessage(),
            'data' => []
        ], 500);
    }
}


public function getNewDriverRidedetail(Request $request, $rideId)
{
    try {
        if (empty($rideId)) {
            return response()->json([
                'status' => false,
                'message' => 'Ride ID is required.',
                'data' => []
            ], 400);
        }

        $ride = SeatSharingRequest::with([
            'seatSharingRequestStops.seatSharingRequestStopsPoints',
            'seatSharingRequestPrice',
            'driver'
        ])->find($rideId);

        if (!$ride) {
            return response()->json([
                'status' => false,
                'message' => 'Ride not found.',
                'data' => []
            ], 200);
        }

        $seatLayout = SeatSharingVehicleLayout::where('seat_sharing_vehicle_layout.seat_sharing_request_id', $rideId)
            ->leftJoin('driver_vehicle_layout_name as dvln', 'seat_sharing_vehicle_layout.driver_vehicle_layout_name_id', '=', 'dvln.id')
            ->leftJoin('driver_vehicle_layout', 'seat_sharing_vehicle_layout.driver_vehicle_layout_id', '=', 'driver_vehicle_layout.id')
            ->leftJoin('tj_user_app', 'seat_sharing_vehicle_layout.booked_by', '=', 'tj_user_app.id')
           ->leftJoin('seat_sharing_request_price', 'seat_sharing_vehicle_layout.user_price_id', '=', 'seat_sharing_request_price.id')

            ->leftJoin('seat_sharing_request_stops as from_stop', 'seat_sharing_vehicle_layout.user_from_stop_id', '=', 'from_stop.id')
            ->leftJoin('seat_sharing_request_stops as to_stop', 'seat_sharing_vehicle_layout.user_to_stop_id', '=', 'to_stop.id')

            ->leftJoin('seat_sharing_request_stop_points as pickup', 'seat_sharing_vehicle_layout.user_pickup_point_id', '=', 'pickup.id')
            ->leftJoin('seat_sharing_request_stop_points as drop', 'seat_sharing_vehicle_layout.user_drop_point_id', '=', 'drop.id')
            ->select(
                'seat_sharing_vehicle_layout.driver_vehicle_layout_name_id',
                'seat_sharing_vehicle_layout.driver_vehicle_layout_id',
                'seat_sharing_vehicle_layout.is_driver',
                'seat_sharing_vehicle_layout.is_booked',
                'seat_sharing_vehicle_layout.booked_by',
                'seat_sharing_vehicle_layout.advance_payment',
                'seat_sharing_vehicle_layout.razorpay_transaction_id',
                'seat_sharing_vehicle_layout.user_from_stop_id',
                'seat_sharing_vehicle_layout.user_to_stop_id',
                'seat_sharing_request_price.price',
                'from_stop.name as from_stop_name',
                'to_stop.name as to_stop_name',

                'pickup.name as pickup_name',
                'drop.name as drop_name',

                'driver_vehicle_layout.label',
                'driver_vehicle_layout.row',
                'driver_vehicle_layout.position',
                'dvln.vehicle_name',
                'dvln.vehicle_number',
                DB::raw("CONCAT(tj_user_app.nom, ' ', tj_user_app.prenom) as user_name"),
                'tj_user_app.phone as user_phone'
            )
            ->get();

        $vehicleInfo = $seatLayout->first();

        $groupedSeats = $seatLayout->groupBy('driver_vehicle_layout_id');

        $finalLayout = $groupedSeats->map(function ($seatGroup) {
            $base = $seatGroup->first();

            $users = $seatGroup->filter(function ($item) {
                return $item->is_booked == 1 && !is_null($item->booked_by);
            })->map(function ($item) {
                return [
                    'user_name' => $item->user_name ?? '',
                    'user_phone' => $item->user_phone,
                    'from_stop_id' => $item->user_from_stop_id,
                    'from_stop_name' => $item->from_stop_name,
                    'to_stop_id' => $item->user_to_stop_id,
                    'to_stop_name' => $item->to_stop_name,
                    'pickup_name' => $item->pickup_name,
                    'drop_name' => $item->drop_name,
                    'price' => $item->price,
                    'booked_by' => $item->booked_by ? (string) $item->booked_by : null,
                ];
            })->values();

            return (object) [
                'driver_vehicle_layout_id' => $base->driver_vehicle_layout_id,
                'driver_vehicle_layout_name_id' => $base->driver_vehicle_layout_name_id,
                'label' => $base->label,
                'row' => $base->row,
                'position' => $base->position,
                'is_driver' => $base->is_driver,
                'is_booked' => $base->is_booked,
                'users' => $users,
            ];
        })->values();

        $ride->seat_sharing_vehicle_layout = $finalLayout;
        $ride->vehicle_name = $vehicleInfo->vehicle_name ?? null;
        $ride->vehicle_number = $vehicleInfo->vehicle_number ?? null;

        return response()->json([
            'status' => true,
            'message' => 'Ride details fetched successfully.',
            'data' => $ride,
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'status' => false,
            'message' => 'An error occurred: ' . $e->getMessage(),
            'data' => []
        ], 500);
    }
}

    public function updateRidedetail(Request $request, $rideId)
    {
        try {
            if (empty($rideId)) {
                return response()->json([
                    'status' => false,
                    'message' => 'Ride ID is required.'
                ], 400);
            }

            if ($request->has('seat_sharing_vehicle_layout')) {
                foreach ($request->seat_sharing_vehicle_layout as $layoutItem) {
                    if (isset($layoutItem['driver_vehicle_layout_id'])) {
                        SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
                            ->where('driver_vehicle_layout_id', $layoutItem['driver_vehicle_layout_id'])
                            ->update([
                                'is_booked' => $layoutItem['is_booked'] ?? 0
                            ]);
                    }
                }
            }

            if ($request->has('seat_sharing_request_price')) {
                foreach ($request->seat_sharing_request_price as $priceItem) {
                    if (isset($priceItem['id'])) {
                        SeatSharingRequestPrice::where('id', $priceItem['id'])
                            ->where('seat_sharing_request_id', $rideId)
                            ->update([
                                'price' => $priceItem['price']
                            ]);
                    }
                }
            }

            return response()->json([
                'status' => true,
                'message' => 'Ride details updated successfully.'
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => 'An error occurred: ' . $e->getMessage()
            ], 500);
        }
    }


  public function cancelRide($rideId)
{
    DB::beginTransaction();

    try {
        // Log::info('Cancel ride request received', ['rideId' => $rideId]);

        if (empty($rideId) || !is_numeric($rideId)) {
            Log::warning('Invalid ride ID provided', ['rideId' => $rideId]);
            return response()->json([
                'status' => false,
                'message' => 'Ride ID is required and must be numeric.',
            ], 400);
        }

        $ride = SeatSharingRequest::find($rideId);

        if (!$ride) {
            // Log::warning('Ride not found', ['rideId' => $rideId]);
            return response()->json([
                'status' => false,
                'message' => 'Ride not found.',
            ], 200);
        }

        if ($ride->ride_status == 1) {
            // Log::info('Ride already started; cancellation rejected', ['rideId' => $rideId]);
            return response()->json([
                'status' => false,
                'message' => 'Ride has already started and cannot be cancelled.',
            ], 200);
        }

        if ($ride->ride_status == 2) {
            // Log::info('Ride already cancelled', ['rideId' => $rideId]);
            return response()->json([
                'status' => false,
                'message' => 'Ride is already cancelled.',
            ], 200);
        }

        $ride->ride_status = 2;
        $ride->save();
        // Log::info('Ride status updated to cancelled', ['rideId' => $rideId]);

        $advancePayments = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
            ->whereNotNull('advance_payment')
            ->where('advance_payment', '!=', 0)
            ->get();

        foreach ($advancePayments as $sql) {
            // Log::info('Processing refund for user', [
            //     'user_id' => $sql->booked_by,
            //     'advance_payment' => $sql->advance_payment,
            //     'layout_id' => $sql->id
            // ]);
            $this->refund_payment($sql);
        }

        $title = "Ride Cancelled";
        $notif_msg = "Your ride from {$ride->from} to {$ride->to} has been cancelled.";

        if ($advancePayments->count() > 0) {
            $notif_msg .= " Your advance payment has been refunded.";
        }

        $message = [
            "body" => $notif_msg,
            "title" => $title,
            "sound" => "ipl_horn",
            "tag" => "ride_cancelled"
        ];

        $driverFcmToken = DB::table('tj_conducteur')
            ->where('fcm_id', '!=', '')
            ->where('id', $ride->driver_id)
            ->value('fcm_id');

        if (!empty($driverFcmToken)) {
            GcmController::sendNotification($driverFcmToken, $message);
            // Log::info('Notification sent to driver', ['driver_id' => $ride->driver_id]);

            DB::table('tj_notification')->insert([
                'titre' => $title,
                'message' => $notif_msg,
                'statut' => 'yes',
                'creer' => now(),
                'modifier' => now(),
                'to_id' => $ride->driver_id,
                'from_id' => $ride->driver_id,
                'type' => 'ride_cancelled'
            ]);
        } else {
            // Log::warning('Driver FCM token not found', ['driver_id' => $ride->driver_id]);
        }

        $passengerUserIds = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
            ->whereNotNull('booked_by')
            ->pluck('booked_by')
            ->unique()
            ->toArray();

        if (!empty($passengerUserIds)) {
            $passengerFcmTokens = DB::table('tj_user_app')
                ->whereIn('id', $passengerUserIds)
                ->where('fcm_id', '!=', '')
                ->pluck('fcm_id')
                ->toArray();

            foreach ($passengerFcmTokens as $token) {
                GcmController::sendNotification($token, $message);
            }

            // Log::info('Notifications sent to passengers', ['passenger_ids' => $passengerUserIds]);

            $notifications = [];
            $now = now();
            foreach ($passengerUserIds as $userId) {
                $notifications[] = [
                    'titre' => $title,
                    'message' => $notif_msg,
                    'statut' => 'yes',
                    'creer' => $now,
                    'modifier' => $now,
                    'to_id' => $userId,
                    'from_id' => $ride->driver_id,
                    'type' => 'ride_cancelled'
                ];
            }

            DB::table('tj_notification')->insert($notifications);
        } else {
            // Log::info('No passengers to notify for this ride', ['rideId' => $rideId]);
        }

        DB::commit();

        // Log::info('Ride cancelled successfully', ['rideId' => $rideId]);

        return response()->json([
            'status' => true,
            'message' => 'Ride cancelled successfully.',
        ]);

    } catch (\Exception $e) {
        DB::rollBack();
        // Log::error('Error cancelling ride', [
        //     'rideId' => $rideId,
        //     'error' => $e->getMessage(),
        //     'trace' => $e->getTraceAsString()
        // ]);

        return response()->json([
            'status' => false,
            'message' => 'An error occurred: ' . $e->getMessage(),
        ], 500);
    }
}




 public function refund_payment($request)
    {
                // Log::info('refund_payment');

        try {
            $sql_rezorpay = DB::table('payment_settings')
                ->crossJoin('tj_payment_method')
                ->select(
                    'payment_settings.id',
                    'payment_settings.key',
                    'payment_settings.secret_key',
                    'payment_settings.isEnabled',
                    'payment_settings.isSandboxEnabled',
                    'payment_settings.id_payment_method',
                    'tj_payment_method.libelle'
                )
                ->where('payment_settings.id_payment_method', '=', DB::raw('tj_payment_method.id'))
                ->where('tj_payment_method.libelle', '=', 'Razorpay')
                ->first();



            $key_id = $sql_rezorpay->key;
            $key_secret = $sql_rezorpay->secret_key;

            $pay_id = $request->razorpay_transaction_id;




            //REFUND PAYMENT

            $url = "https://api.razorpay.com/v1/payments/" . $pay_id . "/refund";

            $amount = ($request->advance_payment * 100);

            $data = [
                "amount" => ($request->advance_payment * 100),
                "speed" => "optimum",
                "receipt" => "Receipt No. " . $request->id,
            ];

            Log::info('Capture API Request Payment ID: ' . $pay_id);
            Log::info('Capture API Request amount: ' . $amount);
            Log::info('Capture API Request url: ' . $url);


            $json_data = json_encode($data);



            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_USERPWD, $key_id . ":" . $key_secret);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);
            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                echo 'Curl error: ' . curl_error($ch);
            } else {
                $decoded_response = json_decode($response, true);

                if (isset($decoded_response['id'])) {
                    $refund = 1;
                    $updatedata = DB::update('update tj_requete set is_refund = ? where id = ?', [$refund, $request->id]);
                }

                $file = fopen("refund.txt", "a");
                fwrite($file, print_r($decoded_response, true));
                fclose($file);
            }

            curl_close($ch);

            Log::info('Capture API Response: ' . $response);

            return true;
        } catch (Exception $e) {

            Log::info('Capture API Response: ' . $e->getMessage() . ' || ON LINE NO. :' . $e->getLine() . ' || IN FILE: ' . $e->getFile());
            return false;
        }
    }

    public function startRide($rideId)
{
    try {
        if (empty($rideId) || !is_numeric($rideId)) {
            return response()->json([
                'status' => false,
                'message' => 'Ride ID is required and must be numeric.',
            ], 400);
        }

        $ride = SeatSharingRequest::find($rideId);
        if (!$ride) {
            return response()->json([
                'status' => false,
                'message' => 'Ride not found.',
            ], 200);
        }

        if ($ride->ride_status == 2) {
            return response()->json([
                'status' => false,
                'message' => 'Ride has been cancelled and cannot be started.',
            ], 200);
        }

        if ($ride->ride_status == 1) {
            return response()->json([
                'status' => false,
                'message' => 'Ride has already started.',
                'data' => []
            ], 200);
        }

        if ($ride->ride_status == 3) {
            return response()->json([
                'status' => false,
                'message' => 'Ride is already completed and cannot be started.',
                'data' => []
            ], 200);
        }

        $ride->ride_status = 1;
        $ride->save();

        $title = "Ride Started Successfully";
        $notif_msg = "Your ride from {$ride->from} to {$ride->to} has started.";

        $message = [
            "body" => $notif_msg,
            "title" => $title,
            "sound" => "ipl_horn",
            "tag" => "ride_start"
        ];

        // Notify driver
        $driverFcmToken = DB::table('tj_conducteur')
            ->where('fcm_id', '!=', '')
            ->where('id', $ride->driver_id)
            ->value('fcm_id');

        if (!empty($driverFcmToken)) {
            GcmController::sendNotification($driverFcmToken, $message);

            DB::table('tj_notification')->insert([
                'titre' => $title,
                'message' => $notif_msg,
                'statut' => 'yes',
                'creer' => now(),
                'modifier' => now(),
                'to_id' => $ride->driver_id,
                'from_id' => $ride->driver_id,
                'type' => 'ride_start'
            ]);
        }

        // Notify all passengers booked on this ride
        $passengerUserIds = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
            ->whereNotNull('booked_by')
            ->pluck('booked_by')
            ->unique()
            ->toArray();

        if (!empty($passengerUserIds)) {
            $passengerFcmTokens = DB::table('tj_user_app')
                ->whereIn('id', $passengerUserIds)
                ->where('fcm_id', '!=', '')
                ->pluck('fcm_id')
                ->toArray();

            foreach ($passengerFcmTokens as $token) {
                GcmController::sendNotification($token, $message);
            }

            $notifications = [];
            $now = now();
            foreach ($passengerUserIds as $userId) {
                $notifications[] = [
                    'titre' => $title,
                    'message' => $notif_msg,
                    'statut' => 'yes',
                    'creer' => $now,
                    'modifier' => $now,
                    'to_id' => $userId,
                    'from_id' => $ride->driver_id,
                    'type' => 'ride_start'
                ];
            }
            DB::table('tj_notification')->insert($notifications);
        }

        return response()->json([
            'status' => true,
            'message' => 'Ride started successfully.',
            'data' => $ride
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'status' => false,
            'message' => 'An error occurred: ' . $e->getMessage(),
        ], 500);
    }
}

   public function completeRide($rideId)
{
    try {
        if (empty($rideId) || !is_numeric($rideId)) {
            return response()->json([
                'status' => false,
                'message' => 'Ride ID is required and must be numeric.',
                'data' => []
            ], 400);
        }

        $ride = SeatSharingRequest::find($rideId);

        if (!$ride) {
            return response()->json([
                'status' => false,
                'message' => 'Ride not found.',
                'data' => []
            ], 200);
        }

        if ($ride->ride_status == 0) {
            return response()->json([
                'status' => false,
                'message' => 'Ride has not started yet.',
                'data' => []
            ], 200);
        }

        if ($ride->ride_status == 2) {
            return response()->json([
                'status' => false,
                'message' => 'Ride has been cancelled and cannot be completed.',
                'data' => []
            ], 200);
        }

        if ($ride->ride_status == 3) {
            return response()->json([
                'status' => false,
                'message' => 'Ride is already completed.',
                'data' => []
            ], 200);
        }

        $ride->ride_status = 3;
        $ride->save();

        $title = "Ride Completed Successfully";
        $notif_msg = "Your ride from {$ride->from} to {$ride->to} has been completed.";

        $message = [
            "body" => $notif_msg,
            "title" => $title,
            "sound" => "ipl_horn",
            "tag" => "ride_complete"
        ];

        // Notify driver
        $driverFcmToken = DB::table('tj_conducteur')
            ->where('fcm_id', '!=', '')
            ->where('id', $ride->driver_id)
            ->value('fcm_id');

        if (!empty($driverFcmToken)) {
            GcmController::sendNotification($driverFcmToken, $message);

            DB::table('tj_notification')->insert([
                'titre' => $title,
                'message' => $notif_msg,
                'statut' => 'yes',
                'creer' => now(),
                'modifier' => now(),
                'to_id' => $ride->driver_id,
                'from_id' => $ride->driver_id,
                'type' => 'ride_complete'
            ]);
        }

        // Notify passengers
        $passengerUserIds = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
            ->whereNotNull('booked_by')
            ->pluck('booked_by')
            ->unique()
            ->toArray();

        if (!empty($passengerUserIds)) {
            $passengerFcmTokens = DB::table('tj_user_app')
                ->whereIn('id', $passengerUserIds)
                ->where('fcm_id', '!=', '')
                ->pluck('fcm_id')
                ->toArray();

            foreach ($passengerFcmTokens as $token) {
                GcmController::sendNotification($token, $message);
            }

            $notifications = [];
            $now = now();
            foreach ($passengerUserIds as $userId) {
                $notifications[] = [
                    'titre' => $title,
                    'message' => $notif_msg,
                    'statut' => 'yes',
                    'creer' => $now,
                    'modifier' => $now,
                    'to_id' => $userId,
                    'from_id' => $ride->driver_id,
                    'type' => 'ride_complete'
                ];
            }
            DB::table('tj_notification')->insert($notifications);
        }

        return response()->json([
            'status' => true,
            'message' => 'Ride completed successfully.',
            'data' => $ride
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'status' => false,
            'message' => 'An error occurred: ' . $e->getMessage(),
            'data' => []
        ], 500);
    }
}




    // for customer 
    // public function getRideList(Request $request)
    // {
    //     $from = $request->from;
    //     $to = $request->to;

    //     $rides = SeatSharingRequest::where('status', 1)
    //         ->where('is_delete', 0)
    //         // ->where('ride_status', 0)
    //         ->get()
    //         ->filter(function ($ride) use ($from, $to) {
    //             $stops = explode(',', $ride->stops);
    //             $fromIndex = array_search($from, $stops);
    //             $toIndex = array_search($to, $stops);

    //             return $fromIndex !== false && $toIndex !== false && $fromIndex < $toIndex;
    //         })
    //         ->values(); // reset keys

    //     return response()->json($rides);
    // }

//   public function getRideList(Request $request)
// {
//     try {
//         $from = $request->from;
//         $to = $request->to;

//         // Log::info('GetRideList Request:', [
//         //     'from' => $from,
//         //     'to' => $to,
//         //     'departure_time' => $request->departure_time
//         // ]);

//         $departureDate = null;

//         if ($request->has('departure_time')) {
//             $departureDate = Carbon::parse($request->departure_time)->toDateString();
//         }

//         $now = Carbon::now();
//         // Log::info('Current Time:', ['now' => $now]);

//         $ridesQuery = SeatSharingRequest::select(
//                 'seat_sharing_request.*',
//                 DB::raw('COUNT(ssvl.id) as total_seats'),
//                 DB::raw('SUM(CASE WHEN ssvl.is_booked = 1 OR ssvl.is_driver = 1 THEN 1 ELSE 0 END) as booked_seats')
//             )
//             ->leftJoin('seat_sharing_vehicle_layout as ssvl', 'ssvl.seat_sharing_request_id', '=', 'seat_sharing_request.id')
//             ->where('seat_sharing_request.status', 1)
//             ->where('seat_sharing_request.ride_status', 0)
//             ->where('seat_sharing_request.is_delete', 0);

//        if ($departureDate) {
//             $parsedDeparture = Carbon::parse($request->departure_time);
//             // Log::info('Parsed Departure Time:', ['parsedDeparture' => $parsedDeparture]);

//             if ($parsedDeparture->isToday()) {
//                 // Log::info("Filtering today's rides with future departure time");

//                 $now = Carbon::now()->format('Y-m-d H:i:s');

//                 $ridesQuery->whereRaw("STR_TO_DATE(seat_sharing_request.departure_time, '%Y-%m-%dT%H:%i:%s') > ?", [$now]);

//             } else {
//                 // Log::info('Filtering future rides by date >= selected date');

//                 $futureDateStart = $parsedDeparture->startOfDay()->format('Y-m-d H:i:s');

//                 $ridesQuery->whereRaw("STR_TO_DATE(seat_sharing_request.departure_time, '%Y-%m-%dT%H:%i:%s') >= ?", [$futureDateStart]);
//             }
//         }



//         $rides = $ridesQuery
//             ->groupBy('seat_sharing_request.id')
//             ->get();

//         // Log::info('Fetched Rides Before Stop Filtering:', ['count' => count($rides)]);

//         $rides = $rides->filter(function ($ride) use ($from, $to) {
//             $stops = explode(',', $ride->stops);
//             $fromIndex = array_search($from, $stops);
//             $toIndex = array_search($to, $stops);
//             return $fromIndex !== false && $toIndex !== false && $fromIndex < $toIndex;
//         })->values();

//         // Log::info('Rides After Stop Filter:', ['count' => count($rides)]);

//         foreach ($rides as $ride) {
//             $ride->remaining_seats = max(0, (int)$ride->total_seats - (int)$ride->booked_seats);

//             $fromStop = DB::table('seat_sharing_request_stops')
//                 ->where('seat_sharing_request_id', $ride->id)
//                 ->where('name', $from)
//                 ->first();

//             $toStop = DB::table('seat_sharing_request_stops')
//                 ->where('seat_sharing_request_id', $ride->id)
//                 ->where('name', $to)
//                 ->first();

//             $price = null;
//             if ($fromStop && $toStop) {
//                 $priceRow = DB::table('seat_sharing_request_price')
//                     ->where('seat_sharing_request_id', $ride->id)
//                     ->where('fromStopId', $fromStop->stop_id)
//                     ->where('toStopId', $toStop->stop_id)
//                     ->first();

//                 $price = $priceRow->price ?? null;
//             }

//             $ride->price = $price;
//             $ride->fromStopId = $fromStop->id;
//             $ride->toStopId = $toStop->id;

//             // Log::info('Processed ride:', [
//             //     'ride_id' => $ride->id,
//             //     'departure_time' => $ride->departure_time,
//             //     'remaining_seats' => $ride->remaining_seats,
//             //     'price' => $price
//             // ]);
//         }

//         return response()->json([
//             'status' => true,
//             'message' => 'Ride list fetched successfully.',
//             'data' => $rides
//         ]);

//     } catch (\Exception $e) {
//         Log::error('Error in getRideList:', [
//             'message' => $e->getMessage(),
//             'trace' => $e->getTraceAsString()
//         ]);

//         return response()->json([
//             'status' => false,
//             'message' => 'Error fetching ride list.',
//             'error' => $e->getMessage()
//         ], 500);
//     }
// }


public function getRideList(Request $request)
{
    try {
        $from = $request->from;
        $to = $request->to;

        $departureDate = null;

        if ($request->has('departure_time')) {
            $departureDate = Carbon::parse($request->departure_time)->toDateString();
        }

        $now = Carbon::now();

        $ridesQuery = SeatSharingRequest::select('seat_sharing_request.*')
            ->where('seat_sharing_request.status', 1)
            ->where('seat_sharing_request.ride_status', 0)
            ->where('seat_sharing_request.is_delete', 0);

        if ($departureDate) {
            $parsedDeparture = Carbon::parse($request->departure_time);

            if ($parsedDeparture->isToday()) {
                $now = Carbon::now()->format('Y-m-d H:i:s');
                $ridesQuery->whereRaw("STR_TO_DATE(seat_sharing_request.departure_time, '%Y-%m-%dT%H:%i:%s') > ?", [$now]);
            } else {
                $futureDateStart = $parsedDeparture->startOfDay()->format('Y-m-d H:i:s');
                $ridesQuery->whereRaw("STR_TO_DATE(seat_sharing_request.departure_time, '%Y-%m-%dT%H:%i:%s') >= ?", [$futureDateStart]);
            }
        }

        $rides = $ridesQuery->get();

        $rides = $rides->filter(function ($ride) use ($from, $to) {
            $stops = explode(',', $ride->stops);
            $fromIndex = array_search($from, $stops);
            $toIndex = array_search($to, $stops);
            return $fromIndex !== false && $toIndex !== false && $fromIndex < $toIndex;
        })->values();

        foreach ($rides as $ride) {
            $fromStop = DB::table('seat_sharing_request_stops')
                ->where('seat_sharing_request_id', $ride->id)
                ->where('name', $from)
                ->first();

            $toStop = DB::table('seat_sharing_request_stops')
                ->where('seat_sharing_request_id', $ride->id)
                ->where('name', $to)
                ->first();

            $price = null;
            if ($fromStop && $toStop) {
                $priceRow = DB::table('seat_sharing_request_price')
                    ->where('seat_sharing_request_id', $ride->id)
                    ->where('fromStopId', $fromStop->stop_id)
                    ->where('toStopId', $toStop->stop_id)
                    ->first();

                $price = $priceRow->price ?? null;
            }

            $seatLayout = DB::table('seat_sharing_vehicle_layout')
                ->where('seat_sharing_request_id', $ride->id)
                ->get();

            $seatGroups = $seatLayout->groupBy('driver_vehicle_layout_id');

            $totalSeats = 0;
            $bookedSeats = 0;

            foreach ($seatGroups as $driverLayoutId => $group) {
                $totalSeats++; // Count this unique seat

                $isBooked = false;

                foreach ($group as $item) {
                    $userFrom = $item->user_from_stop_id;
                    $userTo = $item->user_to_stop_id;

                    if (
                        $item->is_booked == 1 &&
                        !(
                            ($userTo !== null && $userTo <= $fromStop->id) ||
                            ($userFrom !== null && $toStop->id <= $userFrom)
                        )
                    ) {
                        $isBooked = true;
                        break;
                    }
                }

                if ($isBooked) {
                    $bookedSeats++;
                }
            }

            $ride->total_seats = $totalSeats;
            $ride->booked_seats = $bookedSeats;
            $ride->remaining_seats = max(0, $totalSeats - $bookedSeats);
            $ride->price = $price;
            $ride->fromStopId = $fromStop->id ?? null;
            $ride->toStopId = $toStop->id ?? null;
        }

        return response()->json([
            'status' => true,
            'message' => 'Ride list fetched successfully.',
            'data' => $rides
        ]);
    } catch (\Exception $e) {
        Log::error('Error in getRideList:', [
            'message' => $e->getMessage(),
            'trace' => $e->getTraceAsString()
        ]);

        return response()->json([
            'status' => false,
            'message' => 'Error fetching ride list.',
            'error' => $e->getMessage()
        ], 500);
    }
}



 

// public function bookRide(Request $request, $rideId)
// {
//     try {
//         if (!$rideId || !is_numeric($rideId)) {
//             return response()->json([
//                 'status' => false,
//                 'message' => 'Ride ID is required and must be numeric.'
//             ], 200);
//         }

//         $validator = Validator::make($request->all(), [
//             'seat_book' => 'required|array|min:1',
//             'seat_book.*.driver_vehicle_layout_id' => 'required|integer',
//             'seat_book.*.user_id' => [
//                 'required',
//                 'integer',
//                 Rule::exists('tj_user_app', 'id')
//             ],
//         ]);

//         if ($validator->fails()) {
//             return response()->json([
//                 'status' => false,
//                 'message' => 'Validation failed.',
//                 'errors' => $validator->errors()
//             ], 200);
//         }

//         $ride = SeatSharingRequest::find($rideId);
//         $driver = Driver::find($ride->driver_id);

//         if (!$ride) {
//             return response()->json([
//                 'status' => false,
//                 'message' => 'Ride not found.',
//                 'data' => []
//             ], 200);
//         }

//         if (!$driver) {
//             return response()->json([
//                 'status' => false,
//                 'message' => 'Driver not found.',
//                 'data' => []
//             ], 200);
//         }

//         DB::beginTransaction();
//         $seats = [];
//         foreach ($request->seat_book as $book) {
//             $layout = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
//                 ->where('driver_vehicle_layout_id', $book['driver_vehicle_layout_id'])
//                 ->first();

//             if ($layout) {
//                 if ($layout->is_driver == 1) {
//                     DB::rollBack();
//                     return response()->json([
//                         'status' => false,
//                         'message' => 'Seat is assigned to the driver.',
//                         'seat_issue' => [
//                             'driver_vehicle_layout_id' => $book['driver_vehicle_layout_id'],
//                             'user_id' => $book['user_id'],
                            
//                         ]
//                     ], 200);
//                 }

//                 if ($layout->is_booked == 1) {
//                     DB::rollBack();
//                     return response()->json([
//                         'status' => false,
//                         'message' => 'Seat already booked.',
//                         'seat_issue' => [
//                             'driver_vehicle_layout_id' => $book['driver_vehicle_layout_id'],
//                             'user_id' => $book['user_id']
//                         ]
//                     ], 200);
//                 }

//                 $layout->is_booked = 1;
//                 $layout->booked_by = $book['user_id'];
//                 $layout->user_price_id = $book['user_price_id'] ?? null;
//                 $layout->user_from_stop_id = $book['user_from_stop_id'] ?? null;
//                 $layout->user_to_stop_id = $book['user_to_stop_id'] ?? null;
//                 $layout->save();
                
//                 $Vlayout = DriverVehicleLayout::find($layout->driver_vehicle_layout_id);
//                  if ($Vlayout) {
//                     $seats[] = [
//                         'label' => $Vlayout->label,
//                         'row' => $Vlayout->row,
//                         'position' => $Vlayout->position
//                     ];
//                 }
//             }
//         }

//             $seatNames = [];

//             foreach ($seats as $seat) {
//                 $seatNames[] = $seat['row'] . $seat['position']; // Or use $seat['label'] if preferred
//             }

//             $seatsString = implode(', ', $seatNames);

//             $title = "Seats booked successfully";
//             $notif_msg = "A passenger has booked seat(s) [$seatsString] for your ride from {$ride->from} to {$ride->to}.";

        
//             // $fcm_token = DB::table('tj_user_app')->where('fcm_id','!=','')->where('id','=',$id_user_app)->value('fcm_id');
//             $message=array("body"=>$notif_msg,"title"=>$title,"sound"=>"ipl_horn","tag"=>"seat__book_success");
//             $fcm_token = DB::table('tj_conducteur')->where('fcm_id', '!=', '')->where('id', '=', $ride->driver_id)->value('fcm_id');

//             // Send push notification 
//             if (!empty($fcm_token)) {
//                 // GcmController::sendNotification($fcm_token, $message);
//                 // if($version == null){
//                     GcmController::sendNotification($fcm_token, $message);
//                 // }else{
//                 //     GcmController::sendNotification_new($fcm_token, $message);
//                 // }

//                 // Optional: save to tj_notification
//                 $from_id = $ride->driver_id;
//                 $to_id = $ride->driver_id;
//                 $date_heure = date('Y-m-d H:i:s');

//                 DB::table('tj_notification')->insert([
//                     'titre' => $title,
//                     'message' => $notif_msg, 
//                     'statut' => 'yes',
//                     'creer' => $date_heure,
//                     'modifier' => $date_heure,
//                     'to_id' => $to_id,
//                     'from_id' => $from_id,
//                     'type' => 'payment_success'
//                 ]);
//             }

//         DB::commit();

        

//         return response()->json([
//             'status' => true,
//             'message' => 'Seats booked successfully.',
//             'data' => $ride
//         ]);

//     } catch (\Exception $e) {
//         DB::rollBack();

//         return response()->json([
//             'status' => false,
//             'message' => 'Error processing ride booking.',
//             'error' => $e->getMessage()
//         ], 500);
//     }
// }

public function bookRide(Request $request, $rideId)
{
    try {
        if (!$rideId || !is_numeric($rideId)) {
            // Log::error('Invalid Ride ID:', ['rideId' => $rideId]);
            return response()->json([
                'status' => false,
                'message' => 'Ride ID is required and must be numeric.'
            ], 200);
        }

        $validator = Validator::make($request->all(), [
            'seat_book' => 'required|array|min:1',
            'seat_book.*.driver_vehicle_layout_id' => 'required|integer',
            'seat_book.*.user_id' => [
                'required',
                'integer',
                Rule::exists('tj_user_app', 'id')
            ],
        ]);

        if ($validator->fails()) {
            // Log::error('Validation Failed', $validator->errors()->toArray());
            return response()->json([
                'status' => false,
                'message' => 'Validation failed.',
                'errors' => $validator->errors()
            ], 200);
        }

        $ride = SeatSharingRequest::find($rideId);
        if (!$ride) {
            // Log::error('Ride not found', ['rideId' => $rideId]);
            return response()->json([
                'status' => false,
                'message' => 'Ride not found.',
                'data' => []
            ], 200);
        }

        $driver = Driver::find($ride->driver_id);
        if (!$driver) {
            // Log::error('Driver not found', ['driver_id' => $ride->driver_id]);
            return response()->json([
                'status' => false,
                'message' => 'Driver not found.',
                'data' => []
            ], 200);
        }

        DB::beginTransaction();
    $count = count($request->seat_book);
    $advance_payment = ($request->advance_payment)/$count;
        $seats = [];


        foreach ($request->seat_book as $book) {
// Log::info('Processing seat booking', ['book' => $book]);

            // $layout = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
            //     ->where('driver_vehicle_layout_id', $book['driver_vehicle_layout_id'])
            //     ->first();
           $layoutQuery = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
                ->where('driver_vehicle_layout_id', $book['driver_vehicle_layout_id'])
                ->first();

            if ($layoutQuery && $layoutQuery->user_from_stop_id !== null && $layoutQuery->user_to_stop_id !== null) {
                $layout = SeatSharingVehicleLayout::where('seat_sharing_request_id', $rideId)
                    ->where('driver_vehicle_layout_id', $book['driver_vehicle_layout_id'])
                    ->where('user_from_stop_id', $book['user_from_stop_id'])
                    ->where('user_to_stop_id', $book['user_to_stop_id'])
                    ->first();
            } else {
                $layout = $layoutQuery;
            }

// Log::info('layout', ['layout' => $layout]);

            if ($layout) {
                if ($layout->is_driver == 1) {
                    DB::rollBack();
                    // Log::warning('Seat assigned to driver', $book);
                    return response()->json([
                        'status' => false,
                        'message' => 'Seat is assigned to the driver.',
                        'seat_issue' => [
                            'driver_vehicle_layout_id' => $book['driver_vehicle_layout_id'],
                            'user_id' => $book['user_id'],
                        ]
                    ], 200);
                }

                if ($layout->is_booked == 1) {
                    DB::rollBack();
                    // Log::warning('Seat already booked', $book);
                    return response()->json([
                        'status' => false,
                        'message' => 'Seat already booked.',
                        'seat_issue' => [
                            'driver_vehicle_layout_id' => $book['driver_vehicle_layout_id'],
                            'user_id' => $book['user_id']
                        ]
                    ], 200);
                }

                $layout->is_booked = 1;
                $layout->booked_by = $book['user_id'];
                $layout->user_price_id = $book['user_price_id'] ?? null;
                $layout->user_from_stop_id = $book['user_from_stop_id'] ?? null;
                $layout->user_to_stop_id = $book['user_to_stop_id'] ?? null;
                $layout->user_pickup_point_id = $book['user_pickup_point_id'] ?? null;
                $layout->user_drop_point_id = $book['user_drop_point_id'] ?? null;
                $layout->advance_payment = $advance_payment ?? null;
                $layout->razorpay_transaction_id = $request->razorpay_transaction_id ?? null;
                $layout->save();
            // Log::info('layout saveeee');

                $Vlayout = DriverVehicleLayout::find($layout->driver_vehicle_layout_id);

                if ($Vlayout) {
                    // Log::info('Vlayout', ['data' => $Vlayout]);

                    $seats[] = [
                        'label' => $Vlayout->label,
                        'row' => $Vlayout->row,
                        'position' => $Vlayout->position
                    ];
                }else{
                    // Log::info('Vlayout nooo');

                }
            } else{
                
            $stopsIds = SeatSharingRequestStops::where('seat_sharing_request_id', $rideId)->pluck('id')->toArray();

            if (in_array($book['user_from_stop_id'], $stopsIds) && in_array($book['user_to_stop_id'], $stopsIds)) {
               $booking = SeatSharingVehicleLayout::create([
                    'seat_sharing_request_id' => $rideId,
                    'driver_vehicle_layout_name_id' => $book['driver_vehicle_layout_name_id'],
                    'driver_vehicle_layout_id' => $book['driver_vehicle_layout_id'],
                    'is_booked' => 1, 
                    'booked_by' => $book['user_id'], 
                    'user_price_id' =>$book['user_price_id'] ?? null,
                    'user_from_stop_id' => $book['user_from_stop_id'] ?? null, 
                    'user_to_stop_id' => $book['user_to_stop_id'] ?? null, 
                    'user_pickup_point_id' => $book['user_pickup_point_id'] ?? null, 
                    'user_drop_point_id' => $book['user_drop_point_id'] ?? null, 
                    'advance_payment' => $advance_payment ?? null, 
                    'razorpay_transaction_id' => $request->razorpay_transaction_id ?? null,
                     
                ]);

                 $Vlayout = DriverVehicleLayout::find($booking->driver_vehicle_layout_id);

                if ($Vlayout) {
                    // Log::info('Vlayout', ['data' => $Vlayout]);

                    $seats[] = [
                        'label' => $Vlayout->label,
                        'row' => $Vlayout->row,
                        'position' => $Vlayout->position
                    ];
                }else{
                    // Log::info('Vlayout nooo');

                }

            }else{

                    DB::rollBack();
                        // Log::warning('Seat assigned to driver', $book);
                        return response()->json([
                            'status' => false,
                            'message' => 'Seat layout is not found Wrong Ride.',
                            'seat_issue' => [
                                'driver_vehicle_layout_id' => $book['driver_vehicle_layout_id'],
                                'user_id' => $book['user_id'],
                            ]
                        ], 200);
                }
            }
        }

        $seatNames = [];
        foreach ($seats as $seat) {
            $seatNames[] =  $seat['label'] ;
        }

        $seatsString = implode(', ', $seatNames);
        // Log::info('Booked seats:', ['seats' => $seatsString]);

        $title = "Seats booked successfully";
        $notif_msg = "A passenger has booked  [$seatsString] seats for your ride from {$ride->from} to {$ride->to}.";

        $message = [
            "body" => $notif_msg,
            "title" => $title,
            "sound" => "ipl_horn",
            "tag" => "seat_book_success"
        ];

        $fcm_token = DB::table('tj_conducteur')
            ->where('fcm_id', '!=', '')
            ->where('id', '=', $ride->driver_id)
            ->value('fcm_id');

        if (!empty($fcm_token)) {
            GcmController::sendNotification($fcm_token, $message);

            $from_id = $ride->driver_id;
            $to_id = $ride->driver_id;
            $date_heure = now();

            DB::table('tj_notification')->insert([
                'titre' => $title,
                'message' => $notif_msg,
                'statut' => 'yes',
                'creer' => $date_heure,
                'modifier' => $date_heure,
                'to_id' => $to_id,
                'from_id' => $from_id,
                'type' => 'payment_success'
            ]);

            // Log::info('Notification sent and saved to DB', ['to_id' => $to_id, 'fcm_token' => $fcm_token]);
        } 
        // else {
        //     // Log::warning('FCM token not found for driver', ['driver_id' => $ride->driver_id]);
        // }

        DB::commit();

        return response()->json([
            'status' => true,
            'message' => 'Seats booked successfully.',
            'data' => $ride
        ]);
    } catch (\Exception $e) {
        DB::rollBack();
        Log::error('Error in bookRide(): ' . $e->getMessage(), ['trace' => $e->getTraceAsString()]);

        return response()->json([
            'status' => false,
            'message' => 'Error processing ride booking.',
            'error' => $e->getMessage()
        ], 500);
    }
}

//    public function getUserRideList($userId)
//     {
//         try {
//             $rides = SeatSharingVehicleLayout::where('seat_sharing_vehicle_layout.booked_by', $userId)
//                 ->leftJoin('seat_sharing_request as ssr', 'seat_sharing_vehicle_layout.seat_sharing_request_id', '=', 'ssr.id')
//                 ->leftJoin('driver_vehicle_layout as dvl', 'seat_sharing_vehicle_layout.driver_vehicle_layout_id', '=', 'dvl.id')
//                 ->leftJoin('seat_sharing_request_stops as from_stop', 'from_stop.id', '=', 'seat_sharing_vehicle_layout.user_from_stop_id')
//                 ->leftJoin('seat_sharing_request_stops as to_stop', 'to_stop.id', '=', 'seat_sharing_vehicle_layout.user_to_stop_id')
//                 ->leftJoin('seat_sharing_request_price as ssrp', 'ssrp.id', '=', 'seat_sharing_vehicle_layout.user_price_id')
//                 ->select(
//                     'seat_sharing_vehicle_layout.*',
//                     // 'ssr.ride_status',
//                     'ssr.departure_time',
//                     'ssr.created_at as ride_created_at',
//                     'ssr.ride_status',
//                     'dvl.label as layout_label',
//                     'dvl.row as layout_row',
//                     'dvl.position as layout_position',
//                     'from_stop.name as from_stop_name',
//                     'to_stop.name as to_stop_name',
//                     'ssrp.price'
//                 )
//                 ->get();

//             return response()->json([
//                 'status' => true,
//                 'message' => 'User rides fetched successfully.',
//                 'data' => $rides,
//             ]);
//         } catch (\Exception $e) {
//             return response()->json([
//                 'status' => false,
//                 'message' => 'An error occurred: ' . $e->getMessage(),
//                 'data' => [],
//             ], 500);
//         }
//     }
public function getUserRideList($userId)
{
    try {
        $rides = SeatSharingVehicleLayout::where('seat_sharing_vehicle_layout.booked_by', $userId)
            ->leftJoin('seat_sharing_request as ssr', 'seat_sharing_vehicle_layout.seat_sharing_request_id', '=', 'ssr.id')
            ->leftJoin('driver_vehicle_layout as dvl', 'seat_sharing_vehicle_layout.driver_vehicle_layout_id', '=', 'dvl.id')
            ->leftJoin('seat_sharing_request_stops as from_stop', 'from_stop.id', '=', 'seat_sharing_vehicle_layout.user_from_stop_id')
            ->leftJoin('seat_sharing_request_stops as to_stop', 'to_stop.id', '=', 'seat_sharing_vehicle_layout.user_to_stop_id')
            ->leftJoin('seat_sharing_request_price as ssrp', 'ssrp.id', '=', 'seat_sharing_vehicle_layout.user_price_id')
            ->select(
                'seat_sharing_vehicle_layout.seat_sharing_request_id',
                DB::raw("CONCAT(COUNT(seat_sharing_vehicle_layout.id), ' seats') as layout_label"),
                'ssr.departure_time',
                'ssr.created_at as ride_created_at',
                'ssr.ride_status',
                'from_stop.name as from_stop_name',
                'to_stop.name as to_stop_name',

                'from_stop.id as from_stop_id',
                'to_stop.id as to_stop_id',
                DB::raw('GROUP_CONCAT(dvl.label) as layout_labelss'),
                DB::raw('SUM(ssrp.price) as total_price'),
                DB::raw('ssrp.price as price')
            )
            ->groupBy('seat_sharing_vehicle_layout.seat_sharing_request_id', 'ssr.departure_time', 'ssr.created_at', 'ssr.ride_status', 'from_stop.name', 'to_stop.name')
            ->get();

        return response()->json([
            'status' => true,
            'message' => 'User rides fetched successfully.',
            'data' => $rides,
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'status' => false,
            'message' => 'An error occurred: ' . $e->getMessage(),
            'data' => [],
        ], 500);
    }
}





}
